/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfStoreVersionIncompatibleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YarnConfigurationStore
implements AutoCloseable {
    public static final Logger LOG = LoggerFactory.getLogger(YarnConfigurationStore.class);

    public abstract void initialize(Configuration var1, Configuration var2, RMContext var3) throws Exception;

    @Override
    public abstract void close() throws IOException;

    public abstract void logMutation(LogMutation var1) throws Exception;

    public abstract void confirmMutation(LogMutation var1, boolean var2) throws Exception;

    public abstract Configuration retrieve() throws IOException;

    public abstract void format() throws Exception;

    public abstract long getConfigVersion() throws Exception;

    public abstract List<LogMutation> getConfirmedConfHistory(long var1);

    protected abstract Version getConfStoreVersion() throws Exception;

    protected abstract LinkedList<LogMutation> getLogs() throws Exception;

    protected abstract void storeVersion() throws Exception;

    protected abstract Version getCurrentVersion();

    public void checkVersion() throws Exception {
        Version loadedVersion = this.getConfStoreVersion();
        Version currentVersion = this.getCurrentVersion();
        LOG.info("Loaded configuration store version info {}", (Object)loadedVersion);
        if (currentVersion == null || currentVersion.equals(loadedVersion)) {
            return;
        }
        if (loadedVersion != null && !loadedVersion.isCompatibleTo(currentVersion)) {
            throw new YarnConfStoreVersionIncompatibleException("Expecting configuration store version " + currentVersion + ", but loading version " + loadedVersion);
        }
        LOG.info("Storing configuration store version info {}", (Object)currentVersion);
        this.storeVersion();
    }

    public static class LogMutation
    implements Serializable {
        private static final long serialVersionUID = 7754046036718906356L;
        private Map<String, String> updates;
        private String user;

        LogMutation(Map<String, String> updates, String user) {
            this.updates = updates;
            this.user = user;
        }

        public Map<String, String> getUpdates() {
            return this.updates;
        }

        public String getUser() {
            return this.user;
        }
    }
}

