/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.thirdparty.com.google.common.collect.Iterables;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProtectedDirectories {
    static final Logger LOG = LoggerFactory.getLogger(TestProtectedDirectories.class);
    @Rule
    public Timeout timeout = new Timeout(300000);

    public MiniDFSCluster setupTestCase(Configuration conf, Collection<Path> protectedDirs, Collection<Path> unProtectedDirs) throws Throwable {
        conf.set("fs.protected.directories", Joiner.on((String)",").skipNulls().join(protectedDirs));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            for (Path path : Iterables.concat(protectedDirs, unProtectedDirs)) {
                fs.mkdirs(path);
            }
            return cluster;
        }
        catch (Throwable t) {
            cluster.shutdown();
            throw t;
        }
    }

    private Collection<TestMatrixEntry> createTestMatrix() {
        ArrayList<TestMatrixEntry> matrix = new ArrayList<TestMatrixEntry>();
        matrix.add(TestMatrixEntry.get().addUnprotectedDir("/1", true));
        matrix.add(TestMatrixEntry.get().addProtectedDir("/1", true));
        matrix.add(TestMatrixEntry.get().addUnprotectedDir("/1", true).addUnprotectedDir("/1/2", true).addUnprotectedDir("/1/2/3", true).addUnprotectedDir("/1/2/3/4", true));
        matrix.add(TestMatrixEntry.get().addProtectedDir("/1", false).addUnprotectedDir("/1/2", true));
        matrix.add(TestMatrixEntry.get().addProtectedDir("/1/2", true).addUnprotectedDir("/1/2", true));
        matrix.add(TestMatrixEntry.get().addProtectedDir("/1", false).addProtectedDir("/1/2", true));
        matrix.add(TestMatrixEntry.get().addProtectedDir("/1", true).addUnprotectedDir("/a", true));
        matrix.add(TestMatrixEntry.get().addProtectedDir("/1/2", false).addUnprotectedDir("/1/2/3", true).addUnprotectedDir("/1", false));
        matrix.add(TestMatrixEntry.get().addProtectedDir("/1/2.2", false).addUnprotectedDir("/1/2.2/3", true).addUnprotectedDir("/1/2.1", true).addUnprotectedDir("/1/2.3", true).addUnprotectedDir("/1", false));
        matrix.add(TestMatrixEntry.get().addProtectedDir("/1/2/3/4/5", false).addUnprotectedDir("/1/2/3/4/5/6", true).addUnprotectedDir("/1", false).addUnprotectedDir("/1/2", false).addUnprotectedDir("/1/2/3", false).addUnprotectedDir("/1/2/3/4", false));
        matrix.add(TestMatrixEntry.get().addProtectedDir("/1/2", false).addProtectedDir("/a/b", false).addUnprotectedDir("/1/2/3", true).addUnprotectedDir("/a/b/c", true));
        matrix.add(TestMatrixEntry.get().addProtectedDir("/a1", false).addUnprotectedDir("/a1/a2", true).addUnprotectedDir("/a", true));
        matrix.add(TestMatrixEntry.get().addProtectedDir("/a/b", false).addUnprotectedDir("/a/b/c", true).addUnprotectedDir("/a/", false));
        matrix.add(TestMatrixEntry.get().addProtectedDir("/a/b", true).addUnprotectedDir("/a/", true));
        return matrix;
    }

    private Collection<TestMatrixEntry> createTestMatrixForProtectSubDirs() {
        ArrayList<TestMatrixEntry> matrix = new ArrayList<TestMatrixEntry>();
        matrix.add(TestMatrixEntry.get().addUnprotectedDir("/1", true).addUnprotectedDir("/1/2", true).addUnprotectedDir("/1/2/3", true).addUnprotectedDir("/1/2/3/4", true));
        matrix.add(TestMatrixEntry.get().addProtectedDir("/1", false).addUnprotectedDir("/1/2", false).addUnprotectedDir("/1/2/3", false).addUnprotectedDir("/1/2/3/4", true));
        return matrix;
    }

    @Test
    public void testReconfigureProtectedPaths() throws Throwable {
        HdfsConfiguration conf = new HdfsConfiguration();
        List<Path> protectedPaths = Arrays.asList(new Path("/a"), new Path("/b"), new Path("/c"));
        List<Path> unprotectedPaths = Arrays.asList(new Path[0]);
        MiniDFSCluster cluster = this.setupTestCase((Configuration)conf, protectedPaths, unprotectedPaths);
        TreeSet protectedPathsNew = new TreeSet(FSDirectory.normalizePaths(Arrays.asList("/aa", "/bb", "/cc"), (String)"fs.protected.directories"));
        String protectedPathsStrNew = "/aa,/bb,/cc";
        NameNode nn = cluster.getNameNode();
        nn.reconfigureProperty("fs.protected.directories", protectedPathsStrNew);
        FSDirectory fsDirectory = nn.getNamesystem().getFSDirectory();
        Assert.assertEquals((String)String.format("%s has wrong value", "fs.protected.directories"), protectedPathsNew, (Object)fsDirectory.getProtectedDirectories());
        Assert.assertEquals((String)String.format("%s has wrong value", "fs.protected.directories"), (Object)protectedPathsStrNew, (Object)nn.getConf().get("fs.protected.directories"));
        nn.reconfigureProperty("fs.protected.directories", null);
        Assert.assertEquals((String)String.format("%s has wrong value", "fs.protected.directories"), new TreeSet(), (Object)fsDirectory.getProtectedDirectories());
        Assert.assertEquals((String)String.format("%s has wrong value", "fs.protected.directories"), null, (Object)nn.getConf().get("fs.protected.directories"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete() throws Throwable {
        for (TestMatrixEntry testMatrixEntry : this.createTestMatrix()) {
            HdfsConfiguration conf = new HdfsConfiguration();
            MiniDFSCluster cluster = this.setupTestCase((Configuration)conf, testMatrixEntry.getProtectedPaths(), testMatrixEntry.getUnprotectedPaths());
            try {
                LOG.info("Running {}", (Object)testMatrixEntry);
                DistributedFileSystem fs = cluster.getFileSystem();
                for (Path path : testMatrixEntry.getAllPathsToBeDeleted()) {
                    long countBefore = cluster.getNamesystem().getFilesTotal();
                    Assert.assertThat((String)(testMatrixEntry + ": Testing whether " + path + " can be deleted"), (Object)this.deletePath((FileSystem)fs, path), (Matcher)Is.is((Object)testMatrixEntry.canPathBeDeleted(path)));
                    long countAfter = cluster.getNamesystem().getFilesTotal();
                    if (testMatrixEntry.canPathBeDeleted(path)) continue;
                    Assert.assertThat((String)"Either all paths should be deleted or none", (Object)countAfter, (Matcher)Is.is((Object)countBefore));
                }
            }
            finally {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveToTrash() throws Throwable {
        for (TestMatrixEntry testMatrixEntry : this.createTestMatrix()) {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setInt("fs.trash.interval", 3600);
            MiniDFSCluster cluster = this.setupTestCase((Configuration)conf, testMatrixEntry.getProtectedPaths(), testMatrixEntry.getUnprotectedPaths());
            try {
                LOG.info("Running {}", (Object)testMatrixEntry);
                DistributedFileSystem fs = cluster.getFileSystem();
                for (Path path : testMatrixEntry.getAllPathsToBeDeleted()) {
                    Assert.assertThat((String)(testMatrixEntry + ": Testing whether " + path + " can be moved to trash"), (Object)this.moveToTrash((FileSystem)fs, path, (Configuration)conf), (Matcher)Is.is((Object)testMatrixEntry.canPathBeDeleted(path)));
                }
            }
            finally {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRename() throws Throwable {
        for (TestMatrixEntry testMatrixEntry : this.createTestMatrix()) {
            HdfsConfiguration conf = new HdfsConfiguration();
            MiniDFSCluster cluster = this.setupTestCase((Configuration)conf, testMatrixEntry.getProtectedPaths(), testMatrixEntry.getUnprotectedPaths());
            try {
                LOG.info("Running {}", (Object)testMatrixEntry);
                DistributedFileSystem fs = cluster.getFileSystem();
                for (Path srcPath : testMatrixEntry.getAllPathsToBeDeleted()) {
                    Assert.assertThat((String)(testMatrixEntry + ": Testing whether " + srcPath + " can be renamed"), (Object)this.renamePath((FileSystem)fs, srcPath, new Path(srcPath.toString() + "_renamed")), (Matcher)Is.is((Object)testMatrixEntry.canPathBeRenamed(srcPath)));
                }
            }
            finally {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameProtectSubDirs() throws Throwable {
        for (TestMatrixEntry testMatrixEntry : this.createTestMatrixForProtectSubDirs()) {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setBoolean("dfs.protected.subdirectories.enable", true);
            MiniDFSCluster cluster = this.setupTestCase((Configuration)conf, testMatrixEntry.getProtectedPaths(), testMatrixEntry.getUnprotectedPaths());
            try {
                LOG.info("Running {}", (Object)testMatrixEntry);
                DistributedFileSystem fs = cluster.getFileSystem();
                for (Path srcPath : testMatrixEntry.getAllPathsToBeDeleted()) {
                    Assert.assertThat((String)(testMatrixEntry + ": Testing whether " + srcPath + " can be renamed"), (Object)this.renamePath((FileSystem)fs, srcPath, new Path(srcPath.toString() + "_renamed")), (Matcher)Is.is((Object)testMatrixEntry.canPathBeRenamed(srcPath)));
                }
            }
            finally {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveProtectedSubDirsToTrash() throws Throwable {
        for (TestMatrixEntry testMatrixEntry : this.createTestMatrixForProtectSubDirs()) {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setBoolean("dfs.protected.subdirectories.enable", true);
            conf.setInt("fs.trash.interval", 3600);
            MiniDFSCluster cluster = this.setupTestCase((Configuration)conf, testMatrixEntry.getProtectedPaths(), testMatrixEntry.getUnprotectedPaths());
            try {
                LOG.info("Running {}", (Object)testMatrixEntry);
                DistributedFileSystem fs = cluster.getFileSystem();
                for (Path srcPath : testMatrixEntry.getAllPathsToBeDeleted()) {
                    Assert.assertThat((String)(testMatrixEntry + ": Testing whether " + srcPath + " can be moved to trash"), (Object)this.moveToTrash((FileSystem)fs, srcPath, (Configuration)conf), (Matcher)Is.is((Object)testMatrixEntry.canPathBeRenamed(srcPath)));
                }
            }
            finally {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteProtectSubDirs() throws Throwable {
        for (TestMatrixEntry testMatrixEntry : this.createTestMatrixForProtectSubDirs()) {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setBoolean("dfs.protected.subdirectories.enable", true);
            MiniDFSCluster cluster = this.setupTestCase((Configuration)conf, testMatrixEntry.getProtectedPaths(), testMatrixEntry.getUnprotectedPaths());
            try {
                LOG.info("Running {}", (Object)testMatrixEntry);
                DistributedFileSystem fs = cluster.getFileSystem();
                for (Path path : testMatrixEntry.getAllPathsToBeDeleted()) {
                    long countBefore = cluster.getNamesystem().getFilesTotal();
                    Assert.assertThat((String)(testMatrixEntry + ": Testing whether " + path + " can be deleted"), (Object)this.deletePath((FileSystem)fs, path), (Matcher)Is.is((Object)testMatrixEntry.canPathBeDeleted(path)));
                    long countAfter = cluster.getNamesystem().getFilesTotal();
                    if (testMatrixEntry.canPathBeDeleted(path)) continue;
                    Assert.assertThat((String)"Either all paths should be deleted or none", (Object)countAfter, (Matcher)Is.is((Object)countBefore));
                }
            }
            finally {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testProtectedDirNormalization1() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.protected.directories", "/foo//bar");
        SortedSet paths = FSDirectory.parseProtectedDirectories((Configuration)conf);
        Assert.assertThat((Object)paths.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(paths.iterator().next(), (Matcher)Is.is((Object)"/foo/bar"));
    }

    @Test
    public void testProtectedDirNormalization2() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.protected.directories", "/a/b/,/c,/d/e/f/");
        SortedSet paths = FSDirectory.parseProtectedDirectories((Configuration)conf);
        for (String path : paths) {
            Assert.assertFalse((boolean)path.endsWith("/"));
        }
    }

    @Test
    public void testProtectedDirIsCanonicalized() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.protected.directories", "/foo/../bar/");
        SortedSet paths = FSDirectory.parseProtectedDirectories((Configuration)conf);
        Assert.assertThat((Object)paths.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(paths.iterator().next(), (Matcher)Is.is((Object)"/bar"));
    }

    @Test
    public void testProtectedRootDirectory() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.protected.directories", "/");
        SortedSet paths = FSDirectory.parseProtectedDirectories((Configuration)conf);
        Assert.assertThat((Object)paths.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(paths.iterator().next(), (Matcher)Is.is((Object)"/"));
    }

    @Test
    public void testBadPathsInConfig() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("fs.protected.directories", "hdfs://foo/,/.reserved/foo");
        SortedSet paths = FSDirectory.parseProtectedDirectories((Configuration)conf);
        Assert.assertThat((String)("Unexpected directories " + paths), (Object)paths.size(), (Matcher)Is.is((Object)0));
    }

    private boolean deletePath(FileSystem fs, Path path) throws IOException {
        try {
            fs.delete(path, true);
            return true;
        }
        catch (AccessControlException ace) {
            return false;
        }
    }

    private boolean moveToTrash(FileSystem fs, Path path, Configuration conf) {
        try {
            return Trash.moveToAppropriateTrash((FileSystem)fs, (Path)path, (Configuration)conf);
        }
        catch (FileNotFoundException fnf) {
            return true;
        }
        catch (IOException ace) {
            return false;
        }
    }

    private boolean renamePath(FileSystem fs, Path srcPath, Path dstPath) throws IOException {
        try {
            fs.rename(srcPath, dstPath);
            return true;
        }
        catch (AccessControlException ace) {
            return false;
        }
    }

    private static class TestMatrixEntry {
        final Map<Path, Boolean> protectedPaths = Maps.newHashMap();
        final Map<Path, Boolean> unProtectedPaths = Maps.newHashMap();

        private TestMatrixEntry() {
        }

        public static TestMatrixEntry get() {
            return new TestMatrixEntry();
        }

        public Collection<Path> getProtectedPaths() {
            return this.protectedPaths.keySet();
        }

        public Collection<Path> getUnprotectedPaths() {
            return this.unProtectedPaths.keySet();
        }

        public Iterable<Path> getAllPathsToBeDeleted() {
            ArrayList<Path> combined = new ArrayList<Path>();
            combined.addAll(this.protectedPaths.keySet());
            combined.addAll(this.unProtectedPaths.keySet());
            Collections.sort(combined);
            return combined;
        }

        public boolean canPathBeDeleted(Path path) {
            return this.protectedPaths.containsKey(path) ? this.protectedPaths.get(path).booleanValue() : this.unProtectedPaths.get(path).booleanValue();
        }

        public boolean canPathBeRenamed(Path path) {
            return this.protectedPaths.containsKey(path) ? this.protectedPaths.get(path).booleanValue() : this.unProtectedPaths.get(path).booleanValue();
        }

        public TestMatrixEntry addProtectedDir(String dir, boolean canBeDeleted) {
            this.protectedPaths.put(new Path(dir), canBeDeleted);
            return this;
        }

        public TestMatrixEntry addUnprotectedDir(String dir, boolean canBeDeleted) {
            this.unProtectedPaths.put(new Path(dir), canBeDeleted);
            return this;
        }

        public String toString() {
            return "TestMatrixEntry - ProtectedPaths=[" + Joiner.on((String)", ").join(this.protectedPaths.keySet()) + "]; UnprotectedPaths=[" + Joiner.on((String)", ").join(this.unProtectedPaths.keySet()) + "]";
        }
    }
}

