/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.stream.IntStream;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ReservoirSample;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestReservoirSample {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReservoirSample.class);

    @Test
    public void test() {
        int round = 100000;
        int containsOne = 0;
        for (int i = 0; i < round; ++i) {
            ReservoirSample rs = new ReservoirSample(10);
            for (int j = 0; j < 100; ++j) {
                rs.add((Object)j);
                if (j < 10) {
                    Assert.assertEquals((long)(j + 1), (long)rs.getSamplingResult().size());
                    continue;
                }
                Assert.assertEquals((long)10L, (long)rs.getSamplingResult().size());
            }
            if (!rs.getSamplingResult().contains(1)) continue;
            ++containsOne;
        }
        Assert.assertTrue(((double)containsOne > (double)(round / 10) * 0.95 ? 1 : 0) != 0);
        Assert.assertTrue(((double)containsOne < (double)(round / 10) * 1.05 ? 1 : 0) != 0);
    }

    @Test
    public void testIterator() {
        int round = 100000;
        int containsOne = 0;
        for (int i = 0; i < round; ++i) {
            ReservoirSample rs = new ReservoirSample(10);
            rs.add(IntStream.range(0, 100).mapToObj(Integer::valueOf).iterator());
            if (!rs.getSamplingResult().contains(1)) continue;
            ++containsOne;
        }
        Assert.assertTrue(((double)containsOne > (double)(round / 10) * 0.95 ? 1 : 0) != 0);
        Assert.assertTrue(((double)containsOne < (double)(round / 10) * 1.05 ? 1 : 0) != 0);
    }

    @Test
    public void testStream() {
        int round = 100000;
        int containsOne = 0;
        for (int i = 0; i < round; ++i) {
            ReservoirSample rs = new ReservoirSample(10);
            rs.add(IntStream.range(0, 100).mapToObj(Integer::valueOf));
            if (!rs.getSamplingResult().contains(1)) continue;
            ++containsOne;
        }
        Assert.assertTrue(((double)containsOne > (double)(round / 10) * 0.95 ? 1 : 0) != 0);
        Assert.assertTrue(((double)containsOne < (double)(round / 10) * 1.05 ? 1 : 0) != 0);
    }

    @Test
    public void testNegativeSamplingNumber() {
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new ReservoirSample(-1));
        Assert.assertEquals((Object)"negative sampling number(-1) is not allowed", (Object)e.getMessage());
    }
}

