/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.quotas.GlobalQuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.SpaceLimitSettings;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class GlobalQuotaSettingsImpl
extends GlobalQuotaSettings {
    private final QuotaProtos.Throttle throttleProto;
    private final Boolean bypassGlobals;
    private final QuotaProtos.SpaceQuota spaceProto;

    protected GlobalQuotaSettingsImpl(String username, TableName tableName, String namespace, String regionServer, QuotaProtos.Quotas quotas) {
        this(username, tableName, namespace, regionServer, quotas != null && quotas.hasThrottle() ? quotas.getThrottle() : null, quotas != null && quotas.hasBypassGlobals() ? Boolean.valueOf(quotas.getBypassGlobals()) : null, quotas != null && quotas.hasSpace() ? quotas.getSpace() : null);
    }

    protected GlobalQuotaSettingsImpl(String userName, TableName tableName, String namespace, String regionServer, QuotaProtos.Throttle throttleProto, Boolean bypassGlobals, QuotaProtos.SpaceQuota spaceProto) {
        super(userName, tableName, namespace, regionServer);
        this.throttleProto = throttleProto;
        this.bypassGlobals = bypassGlobals;
        this.spaceProto = spaceProto;
    }

    @Override
    public List<QuotaSettings> getQuotaSettings() {
        ArrayList<QuotaSettings> settings = new ArrayList<QuotaSettings>();
        if (this.throttleProto != null) {
            settings.addAll(QuotaSettingsFactory.fromThrottle(this.getUserName(), this.getTableName(), this.getNamespace(), this.getRegionServer(), this.throttleProto));
        }
        if (this.bypassGlobals != null && this.bypassGlobals.booleanValue()) {
            settings.add(new QuotaSettingsFactory.QuotaGlobalsSettingsBypass(this.getUserName(), this.getTableName(), this.getNamespace(), this.getRegionServer(), true));
        }
        if (this.spaceProto != null) {
            settings.add(QuotaSettingsFactory.fromSpace(this.getTableName(), this.getNamespace(), this.spaceProto));
        }
        return settings;
    }

    protected QuotaProtos.Throttle getThrottleProto() {
        return this.throttleProto;
    }

    protected Boolean getBypassGlobals() {
        return this.bypassGlobals;
    }

    protected QuotaProtos.SpaceQuota getSpaceProto() {
        return this.spaceProto;
    }

    protected QuotaProtos.Quotas toQuotas() {
        QuotaProtos.Quotas.Builder builder = QuotaProtos.Quotas.newBuilder();
        if (this.getThrottleProto() != null) {
            builder.setThrottle(this.getThrottleProto());
        }
        if (this.getBypassGlobals() != null) {
            builder.setBypassGlobals(this.getBypassGlobals());
        }
        if (this.getSpaceProto() != null) {
            builder.setSpace(this.getSpaceProto());
        }
        return builder.build();
    }

    private boolean hasThrottle(QuotaProtos.ThrottleType quotaType, QuotaProtos.Throttle.Builder throttleBuilder) {
        boolean hasThrottle = false;
        switch (quotaType) {
            case REQUEST_NUMBER: {
                if (!throttleBuilder.hasReqNum()) break;
                hasThrottle = true;
                break;
            }
            case REQUEST_SIZE: {
                if (!throttleBuilder.hasReqSize()) break;
                hasThrottle = true;
                break;
            }
            case WRITE_NUMBER: {
                if (!throttleBuilder.hasWriteNum()) break;
                hasThrottle = true;
                break;
            }
            case WRITE_SIZE: {
                if (!throttleBuilder.hasWriteSize()) break;
                hasThrottle = true;
                break;
            }
            case READ_NUMBER: {
                if (!throttleBuilder.hasReadNum()) break;
                hasThrottle = true;
                break;
            }
            case READ_SIZE: {
                if (!throttleBuilder.hasReadSize()) break;
                hasThrottle = true;
                break;
            }
            case REQUEST_CAPACITY_UNIT: {
                if (!throttleBuilder.hasReqCapacityUnit()) break;
                hasThrottle = true;
                break;
            }
            case READ_CAPACITY_UNIT: {
                if (!throttleBuilder.hasReadCapacityUnit()) break;
                hasThrottle = true;
                break;
            }
            case WRITE_CAPACITY_UNIT: {
                if (!throttleBuilder.hasWriteCapacityUnit()) break;
                hasThrottle = true;
                break;
            }
            case ATOMIC_READ_SIZE: {
                if (!throttleBuilder.hasAtomicReadSize()) break;
                hasThrottle = true;
                break;
            }
            case ATOMIC_REQUEST_NUMBER: {
                if (!throttleBuilder.hasAtomicReqNum()) break;
                hasThrottle = true;
                break;
            }
            case ATOMIC_WRITE_SIZE: {
                if (!throttleBuilder.hasAtomicWriteSize()) break;
                hasThrottle = true;
                break;
            }
            case REQUEST_HANDLER_USAGE_MS: {
                if (!throttleBuilder.hasReqHandlerUsageMs()) break;
                hasThrottle = true;
                break;
            }
        }
        return hasThrottle;
    }

    @Override
    protected GlobalQuotaSettingsImpl merge(QuotaSettings other) throws IOException {
        QuotaProtos.SpaceQuota.Builder spaceBuilder;
        QuotaProtos.Throttle.Builder throttleBuilder;
        this.validateQuotaTarget(other);
        QuotaProtos.Throttle.Builder builder = throttleBuilder = this.throttleProto == null ? null : this.throttleProto.toBuilder();
        if (other instanceof ThrottleSettings) {
            QuotaProtos.ThrottleRequest otherProto;
            ThrottleSettings otherThrottle = (ThrottleSettings)other;
            if (!otherThrottle.proto.hasType() || !otherThrottle.proto.hasTimedQuota()) {
                otherProto = otherThrottle.proto;
                if (throttleBuilder != null && !otherThrottle.proto.hasTimedQuota() && otherThrottle.proto.hasType()) {
                    QuotaProtos.ThrottleType quotaType;
                    switch (otherProto.getType()) {
                        case REQUEST_NUMBER: {
                            throttleBuilder.clearReqNum();
                            break;
                        }
                        case REQUEST_SIZE: {
                            throttleBuilder.clearReqSize();
                            break;
                        }
                        case WRITE_NUMBER: {
                            throttleBuilder.clearWriteNum();
                            break;
                        }
                        case WRITE_SIZE: {
                            throttleBuilder.clearWriteSize();
                            break;
                        }
                        case READ_NUMBER: {
                            throttleBuilder.clearReadNum();
                            break;
                        }
                        case READ_SIZE: {
                            throttleBuilder.clearReadSize();
                            break;
                        }
                        case REQUEST_CAPACITY_UNIT: {
                            throttleBuilder.clearReqCapacityUnit();
                            break;
                        }
                        case READ_CAPACITY_UNIT: {
                            throttleBuilder.clearReadCapacityUnit();
                            break;
                        }
                        case WRITE_CAPACITY_UNIT: {
                            throttleBuilder.clearWriteCapacityUnit();
                            break;
                        }
                        case ATOMIC_READ_SIZE: {
                            throttleBuilder.clearAtomicReadSize();
                            break;
                        }
                        case ATOMIC_REQUEST_NUMBER: {
                            throttleBuilder.clearAtomicReqNum();
                            break;
                        }
                        case ATOMIC_WRITE_SIZE: {
                            throttleBuilder.clearAtomicWriteSize();
                            break;
                        }
                        case REQUEST_HANDLER_USAGE_MS: {
                            throttleBuilder.clearReqHandlerUsageMs();
                            break;
                        }
                    }
                    boolean hasThrottle = false;
                    QuotaProtos.ThrottleType[] throttleTypeArray = QuotaProtos.ThrottleType.values();
                    int n = throttleTypeArray.length;
                    for (int i = 0; i < n && !(hasThrottle = this.hasThrottle(quotaType = throttleTypeArray[i], throttleBuilder)); ++i) {
                    }
                    if (!hasThrottle) {
                        throttleBuilder = null;
                    }
                } else {
                    throttleBuilder = null;
                }
            } else {
                otherProto = otherThrottle.proto;
                this.validateTimedQuota(otherProto.getTimedQuota());
                if (throttleBuilder == null) {
                    throttleBuilder = QuotaProtos.Throttle.newBuilder();
                }
                switch (otherProto.getType()) {
                    case REQUEST_NUMBER: {
                        throttleBuilder.setReqNum(otherProto.getTimedQuota());
                        break;
                    }
                    case REQUEST_SIZE: {
                        throttleBuilder.setReqSize(otherProto.getTimedQuota());
                        break;
                    }
                    case WRITE_NUMBER: {
                        throttleBuilder.setWriteNum(otherProto.getTimedQuota());
                        break;
                    }
                    case WRITE_SIZE: {
                        throttleBuilder.setWriteSize(otherProto.getTimedQuota());
                        break;
                    }
                    case READ_NUMBER: {
                        throttleBuilder.setReadNum(otherProto.getTimedQuota());
                        break;
                    }
                    case READ_SIZE: {
                        throttleBuilder.setReadSize(otherProto.getTimedQuota());
                        break;
                    }
                    case REQUEST_CAPACITY_UNIT: {
                        throttleBuilder.setReqCapacityUnit(otherProto.getTimedQuota());
                        break;
                    }
                    case READ_CAPACITY_UNIT: {
                        throttleBuilder.setReadCapacityUnit(otherProto.getTimedQuota());
                        break;
                    }
                    case WRITE_CAPACITY_UNIT: {
                        throttleBuilder.setWriteCapacityUnit(otherProto.getTimedQuota());
                        break;
                    }
                    case ATOMIC_READ_SIZE: {
                        throttleBuilder.setAtomicReadSize(otherProto.getTimedQuota());
                        break;
                    }
                    case ATOMIC_REQUEST_NUMBER: {
                        throttleBuilder.setAtomicReqNum(otherProto.getTimedQuota());
                        break;
                    }
                    case ATOMIC_WRITE_SIZE: {
                        throttleBuilder.setAtomicWriteSize(otherProto.getTimedQuota());
                        break;
                    }
                    case REQUEST_HANDLER_USAGE_MS: {
                        throttleBuilder.setReqHandlerUsageMs(otherProto.getTimedQuota());
                    }
                }
            }
        }
        QuotaProtos.SpaceQuota.Builder builder2 = spaceBuilder = this.spaceProto == null ? null : this.spaceProto.toBuilder();
        if (other instanceof SpaceLimitSettings) {
            SpaceLimitSettings settingsToMerge;
            QuotaProtos.SpaceLimitRequest spaceRequest;
            if (spaceBuilder == null) {
                spaceBuilder = QuotaProtos.SpaceQuota.newBuilder();
            }
            if ((spaceRequest = (settingsToMerge = (SpaceLimitSettings)other).getProto()).hasQuota()) {
                QuotaProtos.SpaceQuota quotaToMerge = spaceRequest.getQuota();
                if (!Objects.equals(this.getTableName(), settingsToMerge.getTableName()) && !Objects.equals(this.getNamespace(), settingsToMerge.getNamespace())) {
                    throw new IllegalArgumentException("Cannot merge " + settingsToMerge + " into " + this);
                }
                if (quotaToMerge.getRemove()) {
                    spaceBuilder.setRemove(true).clearSoftLimit().clearViolationPolicy();
                } else {
                    spaceBuilder.mergeFrom(quotaToMerge);
                }
            }
        }
        boolean removeSpaceBuilder = spaceBuilder == null || spaceBuilder.hasRemove() && spaceBuilder.getRemove();
        Boolean bypassGlobals = this.bypassGlobals;
        if (other instanceof QuotaSettingsFactory.QuotaGlobalsSettingsBypass) {
            bypassGlobals = ((QuotaSettingsFactory.QuotaGlobalsSettingsBypass)other).getBypass();
        }
        if (throttleBuilder == null && removeSpaceBuilder && bypassGlobals == null) {
            return null;
        }
        return new GlobalQuotaSettingsImpl(this.getUserName(), this.getTableName(), this.getNamespace(), this.getRegionServer(), throttleBuilder == null ? null : throttleBuilder.build(), bypassGlobals, removeSpaceBuilder ? null : spaceBuilder.build());
    }

    private void validateTimedQuota(QuotaProtos.TimedQuota timedQuota) throws IOException {
        if (timedQuota.getSoftLimit() < 1L) {
            throw new DoNotRetryIOException(new UnsupportedOperationException("The throttle limit must be greater then 0, got " + timedQuota.getSoftLimit()));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GlobalQuota: ");
        if (this.throttleProto != null) {
            Map<ThrottleType, QuotaProtos.TimedQuota> throttleQuotas = this.buildThrottleQuotas(this.throttleProto);
            builder.append(" { TYPE => THROTTLE ");
            for (Map.Entry<ThrottleType, QuotaProtos.TimedQuota> entry : throttleQuotas.entrySet()) {
                ThrottleType type = entry.getKey();
                QuotaProtos.TimedQuota timedQuota = entry.getValue();
                builder.append("{THROTTLE_TYPE => ").append(type.name()).append(", LIMIT => ");
                if (timedQuota.hasSoftLimit()) {
                    switch (type) {
                        case REQUEST_NUMBER: 
                        case WRITE_NUMBER: 
                        case READ_NUMBER: 
                        case ATOMIC_REQUEST_NUMBER: {
                            builder.append(String.format("%dreq", timedQuota.getSoftLimit()));
                            break;
                        }
                        case REQUEST_SIZE: 
                        case WRITE_SIZE: 
                        case READ_SIZE: 
                        case ATOMIC_READ_SIZE: 
                        case ATOMIC_WRITE_SIZE: {
                            builder.append(GlobalQuotaSettingsImpl.sizeToString(timedQuota.getSoftLimit()));
                            break;
                        }
                        case REQUEST_CAPACITY_UNIT: 
                        case READ_CAPACITY_UNIT: 
                        case WRITE_CAPACITY_UNIT: {
                            builder.append(String.format("%dCU", timedQuota.getSoftLimit()));
                            break;
                        }
                        case REQUEST_HANDLER_USAGE_MS: {
                            builder.append(String.format("%dms", timedQuota.getSoftLimit()));
                            break;
                        }
                    }
                } else if (timedQuota.hasShare()) {
                    builder.append(String.format("%.2f%%", Float.valueOf(timedQuota.getShare())));
                }
                builder.append('/');
                builder.append(GlobalQuotaSettingsImpl.timeToString(ProtobufUtil.toTimeUnit(timedQuota.getTimeUnit())));
                if (!timedQuota.hasScope()) continue;
                builder.append(", SCOPE => ");
                builder.append(timedQuota.getScope().toString());
            }
            builder.append("} } ");
        } else {
            builder.append(" {} ");
        }
        if (this.bypassGlobals != null) {
            builder.append(" { GLOBAL_BYPASS => " + this.bypassGlobals + " } ");
        }
        if (this.spaceProto != null) {
            builder.append(" { TYPE => SPACE");
            if (this.getTableName() != null) {
                builder.append(", TABLE => ").append(this.getTableName());
            }
            if (this.getNamespace() != null) {
                builder.append(", NAMESPACE => ").append(this.getNamespace());
            }
            if (this.spaceProto.getRemove()) {
                builder.append(", REMOVE => ").append(this.spaceProto.getRemove());
            } else {
                builder.append(", LIMIT => ").append(GlobalQuotaSettingsImpl.sizeToString(this.spaceProto.getSoftLimit()));
                builder.append(", VIOLATION_POLICY => ").append(this.spaceProto.getViolationPolicy());
            }
            builder.append(" } ");
        }
        return builder.toString();
    }

    private Map<ThrottleType, QuotaProtos.TimedQuota> buildThrottleQuotas(QuotaProtos.Throttle proto) {
        HashMap<ThrottleType, QuotaProtos.TimedQuota> quotas = new HashMap<ThrottleType, QuotaProtos.TimedQuota>();
        if (proto.hasReadNum()) {
            quotas.put(ThrottleType.READ_NUMBER, proto.getReadNum());
        }
        if (proto.hasReadSize()) {
            quotas.put(ThrottleType.READ_SIZE, proto.getReadSize());
        }
        if (proto.hasReqNum()) {
            quotas.put(ThrottleType.REQUEST_NUMBER, proto.getReqNum());
        }
        if (proto.hasReqSize()) {
            quotas.put(ThrottleType.REQUEST_SIZE, proto.getReqSize());
        }
        if (proto.hasWriteNum()) {
            quotas.put(ThrottleType.WRITE_NUMBER, proto.getWriteNum());
        }
        if (proto.hasWriteSize()) {
            quotas.put(ThrottleType.WRITE_SIZE, proto.getWriteSize());
        }
        if (proto.hasReqCapacityUnit()) {
            quotas.put(ThrottleType.REQUEST_CAPACITY_UNIT, proto.getReqCapacityUnit());
        }
        if (proto.hasReadCapacityUnit()) {
            quotas.put(ThrottleType.READ_CAPACITY_UNIT, proto.getReqCapacityUnit());
        }
        if (proto.hasWriteCapacityUnit()) {
            quotas.put(ThrottleType.WRITE_CAPACITY_UNIT, proto.getWriteCapacityUnit());
        }
        return quotas;
    }
}

