/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.agrona.generation;

import java.security.SecureClassLoader;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.apache.hadoop.hbase.shaded.org.agrona.generation.JavaClassObject;

public class ClassFileManager<M extends JavaFileManager>
extends ForwardingJavaFileManager<M> {
    private final Map<String, JavaClassObject> classObjectByNameMap = new HashMap<String, JavaClassObject>();

    public ClassFileManager(M standardManager) {
        super(standardManager);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return new SecureClassLoader(){

            @Override
            protected Class<?> findClass(String name) {
                byte[] buffer = ((JavaClassObject)ClassFileManager.this.classObjectByNameMap.get(name)).getBytes();
                return super.defineClass(name, buffer, 0, buffer.length);
            }
        };
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
        JavaClassObject javaClassObject = new JavaClassObject(className, kind);
        this.classObjectByNameMap.put(className, javaClassObject);
        return javaClassObject;
    }
}

