/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CloseChecker {
    public static final String SIZE_LIMIT_KEY = "hbase.hstore.close.check.interval";
    public static final String TIME_LIMIT_KEY = "hbase.hstore.close.check.time.interval";
    private final int closeCheckSizeLimit;
    private final long closeCheckTimeLimit;
    private long bytesWrittenProgressForCloseCheck;
    private long lastCloseCheckMillis;

    public CloseChecker(Configuration conf, long currentTime) {
        this.closeCheckSizeLimit = conf.getInt(SIZE_LIMIT_KEY, 10000000);
        this.closeCheckTimeLimit = conf.getLong(TIME_LIMIT_KEY, 10000L);
        this.bytesWrittenProgressForCloseCheck = 0L;
        this.lastCloseCheckMillis = currentTime;
    }

    public boolean isSizeLimit(Store store, long bytesWritten) {
        if (this.closeCheckSizeLimit <= 0) {
            return false;
        }
        this.bytesWrittenProgressForCloseCheck += bytesWritten;
        if (this.bytesWrittenProgressForCloseCheck <= (long)this.closeCheckSizeLimit) {
            return false;
        }
        this.bytesWrittenProgressForCloseCheck = 0L;
        return !store.areWritesEnabled();
    }

    public boolean isTimeLimit(Store store, long now) {
        if (this.closeCheckTimeLimit <= 0L) {
            return false;
        }
        long elapsedMillis = now - this.lastCloseCheckMillis;
        if (elapsedMillis <= this.closeCheckTimeLimit) {
            return false;
        }
        this.lastCloseCheckMillis = now;
        return !store.areWritesEnabled();
    }
}

