/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MiscTests.class, MediumTests.class})
public class TestHBaseMetaEdit {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseMetaEdit.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @Before
    public void before() throws Exception {
        UTIL.startMiniCluster();
    }

    @After
    public void after() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private TableDescriptor getMetaDescriptor() throws TableNotFoundException, IOException {
        Admin admin = UTIL.getAdmin();
        TableDescriptor get = admin.getDescriptor(TableName.META_TABLE_NAME);
        TableDescriptor list = admin.listTableDescriptors(null, true).stream().filter(td -> td.isMetaTable()).findAny().get();
        TableDescriptor listByName = (TableDescriptor)admin.listTableDescriptors(Collections.singletonList(TableName.META_TABLE_NAME)).get(0);
        TableDescriptor listByNs = admin.listTableDescriptorsByNamespace(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME).stream().filter(td -> td.isMetaTable()).findAny().get();
        Assert.assertEquals((Object)get, (Object)list);
        Assert.assertEquals((Object)get, (Object)listByName);
        Assert.assertEquals((Object)get, (Object)listByNs);
        return get;
    }

    @Test
    public void testEditMeta() throws IOException {
        Admin admin = UTIL.getAdmin();
        admin.tableExists(TableName.META_TABLE_NAME);
        TableDescriptor originalDescriptor = this.getMetaDescriptor();
        ColumnFamilyDescriptor cfd = originalDescriptor.getColumnFamily(HConstants.CATALOG_FAMILY);
        int oldVersions = cfd.getMaxVersions();
        cfd = ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)cfd).setMaxVersions(oldVersions + 1).setConfiguration("DATA_BLOCK_ENCODING", DataBlockEncoding.ROW_INDEX_V1.toString()).build();
        admin.modifyColumnFamily(TableName.META_TABLE_NAME, cfd);
        byte[] extraColumnFamilyName = Bytes.toBytes((String)"xtra");
        ColumnFamilyDescriptor newCfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])extraColumnFamilyName).build();
        admin.addColumnFamily(TableName.META_TABLE_NAME, newCfd);
        TableDescriptor descriptor = this.getMetaDescriptor();
        Assert.assertEquals((long)(oldVersions + 1), (long)descriptor.getColumnFamily(HConstants.CATALOG_FAMILY).getMaxVersions());
        descriptor = this.getMetaDescriptor();
        Assert.assertEquals((long)(oldVersions + 1), (long)descriptor.getColumnFamily(HConstants.CATALOG_FAMILY).getMaxVersions());
        Assert.assertTrue((descriptor.getColumnFamily(newCfd.getName()) != null ? 1 : 0) != 0);
        String encoding = (String)descriptor.getColumnFamily(HConstants.CATALOG_FAMILY).getConfiguration().get("DATA_BLOCK_ENCODING");
        Assert.assertEquals((Object)encoding, (Object)DataBlockEncoding.ROW_INDEX_V1.toString());
        HRegion r = UTIL.getHBaseCluster().getRegionServer(0).getRegion(RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedName());
        Assert.assertEquals((long)(oldVersions + 1), (long)r.getStore(HConstants.CATALOG_FAMILY).getColumnFamilyDescriptor().getMaxVersions());
        encoding = r.getStore(HConstants.CATALOG_FAMILY).getColumnFamilyDescriptor().getConfigurationValue("DATA_BLOCK_ENCODING");
        Assert.assertEquals((Object)encoding, (Object)DataBlockEncoding.ROW_INDEX_V1.toString());
        Assert.assertTrue((r.getStore(extraColumnFamilyName) != null ? 1 : 0) != 0);
        admin.deleteColumnFamily(TableName.META_TABLE_NAME, newCfd.getName());
        descriptor = this.getMetaDescriptor();
        Assert.assertTrue((descriptor.getColumnFamily(newCfd.getName()) == null ? 1 : 0) != 0);
        try {
            admin.deleteColumnFamily(TableName.META_TABLE_NAME, HConstants.CATALOG_FAMILY);
            Assert.fail((String)"Should not reach here");
        }
        catch (HBaseIOException hioe) {
            Assert.assertTrue((boolean)hioe.getMessage().contains("Delete of hbase:meta"));
        }
    }

    @Test
    public void testAlterMetaWithReadOnly() throws IOException {
        Admin admin = UTIL.getAdmin();
        TableDescriptor origMetaTableDesc = admin.getDescriptor(TableName.META_TABLE_NAME);
        Assert.assertFalse((boolean)origMetaTableDesc.isReadOnly());
        TableDescriptor newTD = TableDescriptorBuilder.newBuilder((TableDescriptor)origMetaTableDesc).setReadOnly(true).build();
        try {
            admin.modifyTable(newTD);
            Assert.fail((String)"Meta table can't be set as read only");
        }
        catch (Exception e) {
            Assert.assertFalse((boolean)admin.getDescriptor(TableName.META_TABLE_NAME).isReadOnly());
        }
        TableName tableName = TableName.valueOf((String)"tempTable");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tableName).setReadOnly(true).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"f1")).build()).build();
        UTIL.getAdmin().createTable(td);
        UTIL.deleteTable(tableName);
    }
}

