/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.QueryMetrics;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceImpl;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableQueryMetrics {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableQueryMetrics.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"ResultMetrics");
    private static final byte[] CF = Bytes.toBytes((String)"cf");
    private static final byte[] CQ = Bytes.toBytes((String)"cq");
    private static final byte[] VALUE = Bytes.toBytes((String)"value");
    private static final byte[] ROW_1 = Bytes.toBytes((String)"zzz1");
    private static final byte[] ROW_2 = Bytes.toBytes((String)"zzz2");
    private static final byte[] ROW_3 = Bytes.toBytes((String)"zzz3");
    private static AsyncConnection CONN;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(3);
        try (Table table = UTIL.createMultiRegionTable(TABLE_NAME, CF);){
            table.put(Arrays.asList(new Put(ROW_1).addColumn(CF, CQ, VALUE), new Put(ROW_2).addColumn(CF, CQ, VALUE), new Put(ROW_3).addColumn(CF, CQ, VALUE)));
        }
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();
        CONN.getAdmin().flush(TABLE_NAME).join();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)CONN, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void itTestsGets() throws Exception {
        Get g1 = new Get(ROW_1);
        g1.setQueryMetricsEnabled(true);
        long bbs = TestAsyncTableQueryMetrics.getClusterBlockBytesScanned();
        Result result = (Result)CONN.getTable(TABLE_NAME).get(g1).get();
        Assert.assertNotNull((Object)result.getMetrics());
        Assert.assertEquals((long)TestAsyncTableQueryMetrics.getClusterBlockBytesScanned(), (long)(bbs += result.getMetrics().getBlockBytesScanned()));
        Get g2 = new Get(ROW_2);
        g2.setQueryMetricsEnabled(true);
        Get g3 = new Get(ROW_3);
        g3.setQueryMetricsEnabled(true);
        List futures = CONN.getTable(TABLE_NAME).get((List)ImmutableList.of((Object)g1, (Object)g2, (Object)g3));
        for (CompletableFuture future : futures) {
            result = (Result)future.join();
            Assert.assertNotNull((Object)result.getMetrics());
            bbs += result.getMetrics().getBlockBytesScanned();
        }
        Assert.assertEquals((long)TestAsyncTableQueryMetrics.getClusterBlockBytesScanned(), (long)bbs);
    }

    @Test
    public void itTestsDefaultGetNoMetrics() throws Exception {
        Get g1 = new Get(ROW_1);
        Result result = (Result)CONN.getTable(TABLE_NAME).get(g1).get();
        Assert.assertNull((Object)result.getMetrics());
        Get g2 = new Get(ROW_2);
        Get g3 = new Get(ROW_3);
        List futures = CONN.getTable(TABLE_NAME).get((List)ImmutableList.of((Object)g1, (Object)g2, (Object)g3));
        futures.forEach(f -> Assert.assertNull((Object)((Result)f.join()).getMetrics()));
    }

    @Test
    public void itTestsScans() {
        Scan scan = new Scan();
        scan.setQueryMetricsEnabled(true);
        long bbs = TestAsyncTableQueryMetrics.getClusterBlockBytesScanned();
        try (ResultScanner scanner = CONN.getTable(TABLE_NAME).getScanner(scan);){
            for (Result result : scanner) {
                Assert.assertNotNull((Object)result.getMetrics());
                Assert.assertEquals((long)TestAsyncTableQueryMetrics.getClusterBlockBytesScanned(), (long)(bbs += result.getMetrics().getBlockBytesScanned()));
            }
        }
    }

    @Test
    public void itTestsDefaultScanNoMetrics() {
        Scan scan = new Scan();
        try (ResultScanner scanner = CONN.getTable(TABLE_NAME).getScanner(scan);){
            for (Result result : scanner) {
                Assert.assertNull((Object)result.getMetrics());
            }
        }
    }

    @Test
    public void itTestsAtomicOperations() {
        CheckAndMutate cam = CheckAndMutate.newBuilder((byte[])ROW_1).ifEquals(CF, CQ, VALUE).queryMetricsEnabled(true).build(new Put(ROW_1).addColumn(CF, CQ, VALUE));
        long bbs = TestAsyncTableQueryMetrics.getClusterBlockBytesScanned();
        CheckAndMutateResult result = (CheckAndMutateResult)CONN.getTable(TABLE_NAME).checkAndMutate(cam).join();
        QueryMetrics metrics = result.getMetrics();
        Assert.assertNotNull((Object)metrics);
        Assert.assertEquals((long)TestAsyncTableQueryMetrics.getClusterBlockBytesScanned(), (long)(bbs + metrics.getBlockBytesScanned()));
        bbs = TestAsyncTableQueryMetrics.getClusterBlockBytesScanned();
        ArrayList<CheckAndMutate> batch = new ArrayList<CheckAndMutate>();
        batch.add(cam);
        batch.add(CheckAndMutate.newBuilder((byte[])ROW_2).queryMetricsEnabled(true).ifEquals(CF, CQ, VALUE).build(new Put(ROW_2).addColumn(CF, CQ, VALUE)));
        batch.add(CheckAndMutate.newBuilder((byte[])ROW_3).queryMetricsEnabled(true).ifEquals(CF, CQ, VALUE).build(new Put(ROW_3).addColumn(CF, CQ, VALUE)));
        List res = (List)CONN.getTable(TABLE_NAME).batchAll(batch).join();
        long totalBbs = res.stream().mapToLong(r -> ((CheckAndMutateResult)r).getMetrics().getBlockBytesScanned()).sum();
        Assert.assertEquals((long)TestAsyncTableQueryMetrics.getClusterBlockBytesScanned(), (long)(bbs + totalBbs));
        bbs = TestAsyncTableQueryMetrics.getClusterBlockBytesScanned();
        CONN.getAdmin().flush(TABLE_NAME).join();
        List futures = CONN.getTable(TABLE_NAME).batch(batch);
        totalBbs = futures.stream().map(CompletableFuture::join).mapToLong(r -> ((CheckAndMutateResult)r).getMetrics().getBlockBytesScanned()).sum();
        Assert.assertEquals((long)TestAsyncTableQueryMetrics.getClusterBlockBytesScanned(), (long)(bbs + totalBbs));
    }

    @Test
    public void itTestsDefaultAtomicOperations() {
        CheckAndMutate cam = CheckAndMutate.newBuilder((byte[])ROW_1).ifEquals(CF, CQ, VALUE).build(new Put(ROW_1).addColumn(CF, CQ, VALUE));
        CheckAndMutateResult result = (CheckAndMutateResult)CONN.getTable(TABLE_NAME).checkAndMutate(cam).join();
        QueryMetrics metrics = result.getMetrics();
        Assert.assertNull((Object)metrics);
        ArrayList<CheckAndMutate> batch = new ArrayList<CheckAndMutate>();
        batch.add(cam);
        batch.add(CheckAndMutate.newBuilder((byte[])ROW_2).ifEquals(CF, CQ, VALUE).build(new Put(ROW_2).addColumn(CF, CQ, VALUE)));
        batch.add(CheckAndMutate.newBuilder((byte[])ROW_3).ifEquals(CF, CQ, VALUE).build(new Put(ROW_3).addColumn(CF, CQ, VALUE)));
        List res = (List)CONN.getTable(TABLE_NAME).batchAll(batch).join();
        for (Object r : res) {
            Assert.assertNull((Object)((CheckAndMutateResult)r).getMetrics());
        }
        CONN.getAdmin().flush(TABLE_NAME).join();
        List futures = CONN.getTable(TABLE_NAME).batch(batch);
        for (CompletableFuture future : futures) {
            Object r = future.join();
            Assert.assertNull((Object)((CheckAndMutateResult)r).getMetrics());
        }
    }

    private static long getClusterBlockBytesScanned() {
        long bbs = 0L;
        for (JVMClusterUtil.RegionServerThread rs : UTIL.getHBaseCluster().getRegionServerThreads()) {
            MetricsRegionServer metrics = rs.getRegionServer().getMetrics();
            MetricsRegionServerSourceImpl source = (MetricsRegionServerSourceImpl)metrics.getMetricsSource();
            bbs += source.getMetricsRegistry().getCounter("blockBytesScannedCount", 0L).value();
        }
        return bbs;
    }
}

