/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.region;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestChangeSFTForMasterRegion {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestChangeSFTForMasterRegion.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName NAME = TableName.valueOf((String)"test");
    private static byte[] FAMILY = Bytes.toBytes((String)"family");

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().set("hbase.master.store.region.file-tracker.impl", StoreFileTrackerFactory.Trackers.DEFAULT.name());
        UTIL.getConfiguration().set("hbase.client.registry.impl", "org.apache.hadoop.hbase.client.ZKConnectionRegistry");
        UTIL.startMiniCluster(1);
        UTIL.createTable(NAME, FAMILY).close();
    }

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        UTIL.getMiniHBaseCluster().stopMaster(0).join();
        UTIL.getMiniHBaseCluster().getConf().set("hbase.master.store.region.file-tracker.impl", StoreFileTrackerFactory.Trackers.FILE.name());
        UTIL.getMiniHBaseCluster().startMaster();
        UTIL.waitTableAvailable(NAME);
        TableDescriptor td = TestChangeSFTForMasterRegion.UTIL.getMiniHBaseCluster().getMaster().getMasterRegion().region.getTableDescriptor();
        Assert.assertEquals((Object)StoreFileTrackerFactory.Trackers.FILE.name(), (Object)td.getValue("hbase.store.file-tracker.impl"));
    }
}

