/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.io.crypto.tls.KeyStoreFileType;
import org.apache.hadoop.hbase.io.crypto.tls.X509KeyType;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestContext;
import org.apache.hadoop.hbase.io.crypto.tls.X509TestContextProvider;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.security.AbstractTestTlsRejectPlainText;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={RPCTests.class, MediumTests.class})
public class TestMutualTlsClientSideNonLocalhost {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMutualTlsClientSideNonLocalhost.class);
    protected static HBaseCommonTestingUtility UTIL;
    protected static File DIR;
    protected static X509TestContextProvider PROVIDER;
    private X509TestContext x509TestContext;
    protected RpcServer rpcServer;
    protected RpcClient rpcClient;
    private TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub;
    @Parameterized.Parameter(value=0)
    public boolean supportPlaintext;

    @Parameterized.Parameters(name="{index}: supportPlaintext={0}")
    public static List<Boolean> data() {
        return Arrays.asList(true, false);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws IOException {
        UTIL = new HBaseCommonTestingUtility();
        Security.addProvider((Provider)new BouncyCastleProvider());
        DIR = new File(UTIL.getDataTestDir(AbstractTestTlsRejectPlainText.class.getSimpleName()).toString()).getCanonicalFile();
        FileUtils.forceMkdir((File)DIR);
        Configuration conf = UTIL.getConfiguration();
        conf.setClass("hbase.rpc.client.impl", NettyRpcClient.class, RpcClient.class);
        conf.setClass("hbase.rpc.server.impl", NettyRpcServer.class, RpcServer.class);
        conf.setBoolean("hbase.server.netty.tls.enabled", true);
        conf.setBoolean("hbase.client.netty.tls.enabled", true);
        PROVIDER = new X509TestContextProvider(conf, DIR);
    }

    @AfterClass
    public static void cleanUp() {
        Security.removeProvider("BC");
        UTIL.cleanupTestDir();
    }

    @Before
    public void setUp() throws Exception {
        this.x509TestContext = PROVIDER.get(X509KeyType.RSA, X509KeyType.RSA, "keyPassword".toCharArray());
        this.x509TestContext.setConfigurations(KeyStoreFileType.JKS, KeyStoreFileType.JKS);
        Configuration serverConf = new Configuration(UTIL.getConfiguration());
        Configuration clientConf = new Configuration(UTIL.getConfiguration());
        this.initialize(serverConf, clientConf);
        InetSocketAddress isa = new InetSocketAddress(InetAddress.getLocalHost(), 0);
        this.rpcServer = new NettyRpcServer(null, "testRpcServer", (List)Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)}), isa, serverConf, (RpcScheduler)new FifoRpcScheduler(serverConf, 1), true);
        this.rpcServer.start();
        this.rpcClient = new NettyRpcClient(clientConf);
        this.stub = TestProtobufRpcServiceImpl.newBlockingStub(this.rpcClient, this.rpcServer.getListenerAddress());
    }

    private void initialize(Configuration serverConf, Configuration clientConf) throws GeneralSecurityException, IOException, OperatorCreationException {
        serverConf.setBoolean("hbase.server.netty.tls.supportplaintext", this.supportPlaintext);
        clientConf.setBoolean("hbase.client.netty.tls.verify.server.hostname", true);
        this.x509TestContext.regenerateStores(X509KeyType.RSA, X509KeyType.RSA, KeyStoreFileType.JKS, KeyStoreFileType.JKS, new String[]{InetAddress.getLocalHost().getHostName()});
    }

    @After
    public void tearDown() throws IOException {
        if (this.rpcServer != null) {
            this.rpcServer.stop();
        }
        Closeables.close((Closeable)this.rpcClient, (boolean)true);
        this.x509TestContext.clearConfigurations();
        this.x509TestContext.getConf().unset("hbase.rpc.tls.ocsp");
        this.x509TestContext.getConf().unset("hbase.rpc.tls.clr");
        this.x509TestContext.getConf().unset("hbase.rpc.tls.protocol");
        System.clearProperty("com.sun.net.ssl.checkRevocation");
        System.clearProperty("com.sun.security.enableCRLDP");
        Security.setProperty("ocsp.enable", Boolean.FALSE.toString());
        Security.setProperty("com.sun.security.enableCRLDP", Boolean.FALSE.toString());
    }

    @Test
    public void testClientAuth() throws Exception {
        this.stub.echo(null, TestProtos.EchoRequestProto.newBuilder().setMessage("hello world").build());
    }
}

