/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.helix.controller.dataproviders.WorkflowControllerDataProvider;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.monitoring.mbeans.ClusterEventMonitor;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitorMBean;
import org.apache.helix.monitoring.mbeans.CustomizedViewMonitor;
import org.apache.helix.monitoring.mbeans.InstanceMonitor;
import org.apache.helix.monitoring.mbeans.JobMonitor;
import org.apache.helix.monitoring.mbeans.MonitorDomainNames;
import org.apache.helix.monitoring.mbeans.PerInstanceResourceMonitor;
import org.apache.helix.monitoring.mbeans.ResourceMonitor;
import org.apache.helix.monitoring.mbeans.WorkflowMonitor;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStatusMonitor
implements ClusterStatusMonitorMBean {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterStatusMonitor.class);
    static final String MESSAGE_QUEUE_STATUS_KEY = "MessageQueueStatus";
    static final String RESOURCE_STATUS_KEY = "ResourceStatus";
    public static final String PARTICIPANT_STATUS_KEY = "ParticipantStatus";
    public static final String CLUSTER_DN_KEY = "cluster";
    public static final String RESOURCE_DN_KEY = "resourceName";
    static final String INSTANCE_DN_KEY = "instanceName";
    static final String MESSAGE_QUEUE_DN_KEY = "messageQueue";
    static final String JOB_TYPE_DN_KEY = "jobType";
    static final String DEFAULT_WORKFLOW_JOB_TYPE = "DEFAULT";
    public static final String DEFAULT_TAG = "DEFAULT";
    private final String _clusterName;
    private final MBeanServer _beanServer;
    private boolean _enabled = true;
    private boolean _inMaintenance = false;
    private boolean _paused = false;
    private Set<String> _liveInstances = Collections.emptySet();
    private Set<String> _instances = Collections.emptySet();
    private Set<String> _disabledInstances = Collections.emptySet();
    private Map<String, Map<String, List<String>>> _disabledPartitions = Collections.emptyMap();
    private Map<String, List<String>> _oldDisabledPartitions = Collections.emptyMap();
    private AtomicLong _totalMsgQueueSize = new AtomicLong(0L);
    private AtomicLong _maxInstanceMsgQueueSize = new AtomicLong(0L);
    private AtomicLong _totalPastDueMsgSize = new AtomicLong(0L);
    private boolean _rebalanceFailure = false;
    private AtomicLong _rebalanceFailureCount = new AtomicLong(0L);
    private AtomicLong _continuousResourceRebalanceFailureCount = new AtomicLong(0L);
    private AtomicLong _continuousTaskRebalanceFailureCount = new AtomicLong(0L);
    private final ConcurrentHashMap<String, ResourceMonitor> _resourceMonitorMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, InstanceMonitor> _instanceMonitorMap = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, ClusterEventMonitor> _clusterEventMonitorMap = new ConcurrentHashMap();
    private CustomizedViewMonitor _customizedViewMonitor;
    private final Map<PerInstanceResourceMonitor.BeanName, PerInstanceResourceMonitor> _perInstanceResourceMonitorMap = new ConcurrentHashMap<PerInstanceResourceMonitor.BeanName, PerInstanceResourceMonitor>();
    private final Map<String, WorkflowMonitor> _perTypeWorkflowMonitorMap = new ConcurrentHashMap<String, WorkflowMonitor>();
    private final Map<String, JobMonitor> _perTypeJobMonitorMap = new ConcurrentHashMap<String, JobMonitor>();

    public ClusterStatusMonitor(String clusterName) {
        this._clusterName = clusterName;
        this._beanServer = ManagementFactory.getPlatformMBeanServer();
    }

    public ObjectName getObjectName(String name) throws MalformedObjectNameException {
        return new ObjectName(String.format("%s:%s", MonitorDomainNames.ClusterStatus.name(), name));
    }

    public String getClusterName() {
        return this._clusterName;
    }

    @Override
    public long getDownInstanceGauge() {
        return this._instances.size() - this._liveInstances.size();
    }

    @Override
    public long getInstancesGauge() {
        return this._instances.size();
    }

    @Override
    public long getDisabledInstancesGauge() {
        return this._disabledInstances.size();
    }

    @Override
    public long getDisabledPartitionsGauge() {
        int numDisabled = 0;
        for (Map<String, List<String>> map : this._disabledPartitions.values()) {
            for (List<String> partitions : map.values()) {
                if (partitions == null) continue;
                numDisabled += partitions.size();
            }
        }
        for (List list : this._oldDisabledPartitions.values()) {
            if (list == null) continue;
            numDisabled += list.size();
        }
        return numDisabled;
    }

    @Override
    public long getRebalanceFailureGauge() {
        return this._rebalanceFailure ? 1L : 0L;
    }

    public void setRebalanceFailureGauge(boolean isFailure) {
        this._rebalanceFailure = isFailure;
    }

    public void setResourceRebalanceStates(Collection<String> resources, ResourceMonitor.RebalanceStatus state) {
        for (String resource : resources) {
            ResourceMonitor resourceMonitor = this.getOrCreateResourceMonitor(resource);
            if (resourceMonitor == null) continue;
            resourceMonitor.setRebalanceState(state);
        }
    }

    @Override
    public long getMaxMessageQueueSizeGauge() {
        return this._maxInstanceMsgQueueSize.get();
    }

    @Override
    public long getInstanceMessageQueueBacklog() {
        return this._totalMsgQueueSize.get();
    }

    @Override
    public long getTotalPastDueMessageGauge() {
        return this._totalPastDueMsgSize.get();
    }

    private void register(Object bean, ObjectName name) {
        try {
            if (this._beanServer.isRegistered(name)) {
                this._beanServer.unregisterMBean(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            LOG.info("Register MBean: " + name);
            this._beanServer.registerMBean(bean, name);
        }
        catch (Exception e) {
            LOG.warn("Could not register MBean: " + name, (Throwable)e);
        }
    }

    private void unregister(ObjectName name) {
        try {
            if (this._beanServer.isRegistered(name)) {
                LOG.info("Unregistering " + name.toString());
                this._beanServer.unregisterMBean(name);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not unregister MBean: " + name, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClusterInstanceStatus(Set<String> liveInstanceSet, Set<String> instanceSet, Set<String> disabledInstanceSet, Map<String, Map<String, List<String>>> disabledPartitions, Map<String, List<String>> oldDisabledPartitions, Map<String, Set<String>> tags, Map<String, Set<Message>> instanceMessageMap) {
        ConcurrentHashMap<String, InstanceMonitor> concurrentHashMap = this._instanceMonitorMap;
        synchronized (concurrentHashMap) {
            HashSet toUnregister = Sets.newHashSet((Iterable)this._instanceMonitorMap.keySet());
            toUnregister.removeAll(instanceSet);
            this.unregisterInstances(toUnregister);
            HashSet toRegister = Sets.newHashSet(instanceSet);
            toRegister.removeAll(this._instanceMonitorMap.keySet());
            HashSet monitorsToRegister = Sets.newHashSet();
            for (String instanceName : toRegister) {
                try {
                    ObjectName objectName = this.getObjectName(this.getInstanceBeanName(instanceName));
                    InstanceMonitor bean = new InstanceMonitor(this._clusterName, instanceName, objectName);
                    bean.updateInstance(tags.get(instanceName), disabledPartitions.get(instanceName), oldDisabledPartitions.get(instanceName), liveInstanceSet.contains(instanceName), !disabledInstanceSet.contains(instanceName));
                    monitorsToRegister.add(bean);
                }
                catch (MalformedObjectNameException ex) {
                    LOG.error("Failed to create instance monitor for instance: {}.", (Object)instanceName);
                }
            }
            try {
                this.registerInstances(monitorsToRegister);
            }
            catch (JMException e) {
                LOG.error("Could not register instances with MBean server: {}.", (Object)toRegister, (Object)e);
            }
            this._instances = instanceSet;
            this._liveInstances = liveInstanceSet;
            this._disabledInstances = disabledInstanceSet;
            this._disabledPartitions = disabledPartitions;
            this._oldDisabledPartitions = oldDisabledPartitions;
            long totalMsgQueueSize = 0L;
            long maxInstanceMsgQueueSize = 0L;
            long totalPastDueMsgSize = 0L;
            long now = System.currentTimeMillis();
            for (String instanceName : instanceSet) {
                String newSensorName;
                if (!this._instanceMonitorMap.containsKey(instanceName)) continue;
                InstanceMonitor bean = this._instanceMonitorMap.get(instanceName);
                String oldSensorName = bean.getSensorName();
                bean.updateInstance(tags.get(instanceName), disabledPartitions.get(instanceName), oldDisabledPartitions.get(instanceName), liveInstanceSet.contains(instanceName), !disabledInstanceSet.contains(instanceName));
                Set<Message> messages = instanceMessageMap.get(instanceName);
                if (messages != null) {
                    long msgQueueSize = messages.size();
                    bean.updateMessageQueueSize(msgQueueSize);
                    totalMsgQueueSize += msgQueueSize;
                    if (msgQueueSize > maxInstanceMsgQueueSize) {
                        maxInstanceMsgQueueSize = msgQueueSize;
                    }
                    long pastDueMsgCount = messages.stream().filter(m -> m.getCompletionDueTimeStamp() <= now).count();
                    bean.updatePastDueMessageGauge(pastDueMsgCount);
                    totalPastDueMsgSize += pastDueMsgCount;
                    LOG.debug("There are totally {} messages, {} are past due on instance {}", new Object[]{msgQueueSize, pastDueMsgCount, instanceName});
                }
                if (oldSensorName.equals(newSensorName = bean.getSensorName())) continue;
                try {
                    this.unregisterInstances(Arrays.asList(instanceName));
                    this.registerInstances(Arrays.asList(bean));
                }
                catch (JMException e) {
                    LOG.error("Could not refresh registration with MBean server: {}", (Object)instanceName, (Object)e);
                }
            }
            this._maxInstanceMsgQueueSize.set(maxInstanceMsgQueueSize);
            this._totalMsgQueueSize.set(totalMsgQueueSize);
            this._totalPastDueMsgSize.set(totalPastDueMsgSize);
        }
    }

    public void updateClusterEventDuration(String phase, long duration) {
        ClusterEventMonitor monitor = this.getOrCreateClusterEventMonitor(phase);
        if (monitor != null) {
            monitor.reportDuration(duration);
        }
    }

    public synchronized CustomizedViewMonitor getOrCreateCustomizedViewMonitor(String clusterName) {
        if (this._customizedViewMonitor == null) {
            this._customizedViewMonitor = new CustomizedViewMonitor(clusterName);
            try {
                this._customizedViewMonitor.register();
            }
            catch (JMException e) {
                LOG.error("Failed to register CustomizedViewMonitorMBean for cluster " + this._clusterName, (Throwable)e);
            }
        }
        return this._customizedViewMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterEventMonitor getOrCreateClusterEventMonitor(String phase) {
        block6: {
            try {
                if (this._clusterEventMonitorMap.containsKey(phase)) break block6;
                ConcurrentHashMap<String, ClusterEventMonitor> concurrentHashMap = this._clusterEventMonitorMap;
                synchronized (concurrentHashMap) {
                    if (!this._clusterEventMonitorMap.containsKey(phase)) {
                        ClusterEventMonitor monitor = new ClusterEventMonitor(this, phase);
                        monitor.register();
                        this._clusterEventMonitorMap.put(phase, monitor);
                    }
                }
            }
            catch (JMException e) {
                LOG.error("Failed to register ClusterEventMonitorMbean for cluster " + this._clusterName + " and phase type: " + phase, (Throwable)e);
            }
        }
        return this._clusterEventMonitorMap.get(phase);
    }

    public void increaseMessageReceived(List<Message> messages) {
        HashMap<String, Long> messageCountPerInstance = new HashMap<String, Long>();
        HashMap<String, Long> messageCountPerResource = new HashMap<String, Long>();
        for (Message message : messages) {
            String instanceName = message.getAttribute(Message.Attributes.TGT_NAME);
            String resourceName = message.getAttribute(Message.Attributes.RESOURCE_NAME);
            if (instanceName != null) {
                if (!messageCountPerInstance.containsKey(instanceName)) {
                    messageCountPerInstance.put(instanceName, 0L);
                }
                messageCountPerInstance.put(instanceName, (Long)messageCountPerInstance.get(instanceName) + 1L);
            }
            if (resourceName == null) continue;
            if (!messageCountPerResource.containsKey(resourceName)) {
                messageCountPerResource.put(resourceName, 0L);
            }
            messageCountPerResource.put(resourceName, (Long)messageCountPerResource.get(resourceName) + 1L);
        }
        for (String instance : messageCountPerInstance.keySet()) {
            InstanceMonitor instanceMonitor = this._instanceMonitorMap.get(instance);
            if (instanceMonitor == null) continue;
            instanceMonitor.increaseMessageCount((Long)messageCountPerInstance.get(instance));
        }
        for (String resource : messageCountPerResource.keySet()) {
            ResourceMonitor resourceMonitor = this._resourceMonitorMap.get(resource);
            if (resourceMonitor == null) continue;
            resourceMonitor.increaseMessageCount((Long)messageCountPerResource.get(resource));
            resourceMonitor.increaseMessageCountWithCounter((Long)messageCountPerResource.get(resource));
        }
    }

    public void updateInstanceCapacityStatus(String instanceName, double maxUsage, Map<String, Integer> capacityMap) {
        InstanceMonitor monitor = this._instanceMonitorMap.get(instanceName);
        if (monitor == null) {
            LOG.warn("Failed to update instance capacity status because instance monitor is not found, instance: {}.", (Object)instanceName);
            return;
        }
        monitor.updateMaxCapacityUsage(maxUsage);
        monitor.updateCapacity(capacityMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPerInstanceResourceStatus(BestPossibleStateOutput bestPossibleStates, Map<String, InstanceConfig> instanceConfigMap, Map<String, Resource> resourceMap, Map<String, StateModelDefinition> stateModelDefMap) {
        HashMap<PerInstanceResourceMonitor.BeanName, Map> beanMap = new HashMap<PerInstanceResourceMonitor.BeanName, Map>();
        HashSet<String> resourceSet = new HashSet<String>(bestPossibleStates.resourceSet());
        for (String resource : resourceSet) {
            HashMap<Partition, Map<String, String>> partitionStateMap = new HashMap<Partition, Map<String, String>>(bestPossibleStates.getResourceMap(resource));
            for (Object partition : partitionStateMap.keySet()) {
                Map instanceStateMap = (Map)partitionStateMap.get(partition);
                for (String instance : instanceStateMap.keySet()) {
                    String state = (String)instanceStateMap.get(instance);
                    PerInstanceResourceMonitor.BeanName beanName = new PerInstanceResourceMonitor.BeanName(this._clusterName, instance, resource);
                    beanMap.computeIfAbsent(beanName, k -> new HashMap()).put(partition, state);
                }
            }
        }
        Map<PerInstanceResourceMonitor.BeanName, PerInstanceResourceMonitor> map = this._perInstanceResourceMonitorMap;
        synchronized (map) {
            InstanceConfig config;
            String stateModelDefName;
            PerInstanceResourceMonitor bean;
            HashSet toUnregister = Sets.newHashSet(this._perInstanceResourceMonitorMap.keySet());
            toUnregister.removeAll(beanMap.keySet());
            try {
                this.unregisterPerInstanceResources(toUnregister);
            }
            catch (MalformedObjectNameException e) {
                LOG.error("Fail to unregister per-instance resource from MBean server: " + toUnregister, (Throwable)e);
            }
            HashSet toRegister = Sets.newHashSet(beanMap.keySet());
            toRegister.removeAll(this._perInstanceResourceMonitorMap.keySet());
            HashSet monitorsToRegister = Sets.newHashSet();
            for (PerInstanceResourceMonitor.BeanName beanName : toRegister) {
                bean = new PerInstanceResourceMonitor(this._clusterName, beanName.instanceName(), beanName.resourceName());
                stateModelDefName = resourceMap.get(beanName.resourceName()).getStateModelDefRef();
                config = instanceConfigMap.get(beanName.instanceName());
                bean.update((Map)beanMap.get(beanName), Sets.newHashSet(config.getTags()), stateModelDefMap.get(stateModelDefName));
                monitorsToRegister.add(bean);
            }
            try {
                this.registerPerInstanceResources(monitorsToRegister);
            }
            catch (JMException e) {
                LOG.error("Fail to register per-instance resource with MBean server: " + toRegister, (Throwable)e);
            }
            for (PerInstanceResourceMonitor.BeanName beanName : this._perInstanceResourceMonitorMap.keySet()) {
                bean = this._perInstanceResourceMonitorMap.get(beanName);
                stateModelDefName = resourceMap.get(beanName.resourceName()).getStateModelDefRef();
                config = instanceConfigMap.get(beanName.instanceName());
                bean.update((Map)beanMap.get(beanName), Sets.newHashSet(config.getTags()), stateModelDefMap.get(stateModelDefName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retainResourceMonitor(Set<String> resourceNames) {
        HashSet<String> resourcesToRemove = new HashSet<String>();
        ConcurrentHashMap<String, ResourceMonitor> concurrentHashMap = this._resourceMonitorMap;
        synchronized (concurrentHashMap) {
            resourceNames.retainAll(this._resourceMonitorMap.keySet());
            resourcesToRemove.addAll(this._resourceMonitorMap.keySet());
        }
        resourcesToRemove.removeAll(resourceNames);
        try {
            this.registerResources(resourceNames);
        }
        catch (JMException e) {
            LOG.error(String.format("Could not register beans for the following resources: %s", Joiner.on((char)',').join(resourceNames)), (Throwable)e);
        }
        try {
            this.unregisterResources(resourcesToRemove);
        }
        catch (Exception e) {
            LOG.error(String.format("Could not unregister beans for the following resources: %s", Joiner.on((char)',').join(resourcesToRemove)), (Throwable)e);
        }
    }

    public void setResourceState(String resourceName, ExternalView externalView, IdealState idealState, StateModelDefinition stateModelDef) {
        try {
            ResourceMonitor resourceMonitor = this.getOrCreateResourceMonitor(resourceName);
            if (resourceMonitor != null) {
                resourceMonitor.updateResourceState(externalView, idealState, stateModelDef);
            }
        }
        catch (Exception e) {
            LOG.error("Fail to set resource status, resource: " + idealState.getResourceName(), (Throwable)e);
        }
    }

    public void setResourcePendingMessages(String resourceName, int messageCount) {
        try {
            ResourceMonitor resourceMonitor = this.getOrCreateResourceMonitor(resourceName);
            if (resourceMonitor != null) {
                resourceMonitor.updatePendingStateTransitionMessages(messageCount);
            }
        }
        catch (Exception e) {
            LOG.error("Fail to set pending resource messages, resource: " + resourceName, (Throwable)e);
        }
    }

    public void updatePartitionWeight(String resourceName, Map<String, Integer> averageWeightMap) {
        ResourceMonitor monitor = this.getOrCreateResourceMonitor(resourceName);
        if (monitor == null) {
            LOG.warn("Failed to update partition weight metric for resource: {} because resource monitor is not created.", (Object)resourceName);
            return;
        }
        monitor.updatePartitionWeightStats(averageWeightMap);
    }

    public void updateMissingTopStateDurationStats(String resourceName, long totalDuration, long helixLatency, boolean isGraceful, boolean succeeded) {
        ResourceMonitor resourceMonitor = this.getOrCreateResourceMonitor(resourceName);
        if (resourceMonitor != null) {
            resourceMonitor.updateStateHandoffStats(ResourceMonitor.MonitorState.TOP_STATE, totalDuration, helixLatency, isGraceful, succeeded);
        }
    }

    public void updateRebalancerStats(String resourceName, long numPendingRecoveryRebalancePartitions, long numPendingLoadRebalancePartitions, long numRecoveryRebalanceThrottledPartitions, long numLoadRebalanceThrottledPartitions, boolean rebalanceThrottledByErrorPartitions) {
        ResourceMonitor resourceMonitor = this.getOrCreateResourceMonitor(resourceName);
        if (resourceMonitor != null) {
            resourceMonitor.updateRebalancerStats(numPendingRecoveryRebalancePartitions, numPendingLoadRebalancePartitions, numRecoveryRebalanceThrottledPartitions, numLoadRebalanceThrottledPartitions, rebalanceThrottledByErrorPartitions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceMonitor getOrCreateResourceMonitor(String resourceName) {
        block6: {
            try {
                if (this._resourceMonitorMap.containsKey(resourceName)) break block6;
                ConcurrentHashMap<String, ResourceMonitor> concurrentHashMap = this._resourceMonitorMap;
                synchronized (concurrentHashMap) {
                    if (!this._resourceMonitorMap.containsKey(resourceName)) {
                        String beanName = this.getResourceBeanName(resourceName);
                        ResourceMonitor bean = new ResourceMonitor(this._clusterName, resourceName, this.getObjectName(beanName));
                        this._resourceMonitorMap.put(resourceName, bean);
                    }
                }
            }
            catch (JMException ex) {
                LOG.error("Fail to register resource mbean, resource: " + resourceName);
            }
        }
        return this._resourceMonitorMap.get(resourceName);
    }

    public void resetMaxMissingTopStateGauge() {
        for (ResourceMonitor monitor : this._resourceMonitorMap.values()) {
            monitor.resetMaxTopStateHandoffGauge();
        }
    }

    public void active() {
        LOG.info("Active ClusterStatusMonitor");
        try {
            this.register(this, this.getObjectName(this.clusterBeanName()));
        }
        catch (Exception e) {
            LOG.error("Fail to register ClusterStatusMonitor", (Throwable)e);
        }
    }

    public void reset() {
        LOG.info("Reset ClusterStatusMonitor");
        try {
            this.unregisterAllResources();
            this.unregisterAllInstances();
            this.unregisterAllPerInstanceResources();
            this.unregister(this.getObjectName(this.clusterBeanName()));
            this.unregisterAllEventMonitors();
            this.unregisterAllWorkflowsMonitor();
            this.unregisterAllJobs();
            this._liveInstances.clear();
            this._instances.clear();
            this._disabledInstances.clear();
            this._disabledPartitions.clear();
            this._oldDisabledPartitions.clear();
            this._rebalanceFailure = false;
            this._maxInstanceMsgQueueSize.set(0L);
            this._totalPastDueMsgSize.set(0L);
            this._totalMsgQueueSize.set(0L);
            this._rebalanceFailureCount.set(0L);
            this._continuousResourceRebalanceFailureCount.set(0L);
            this._continuousTaskRebalanceFailureCount.set(0L);
        }
        catch (Exception e) {
            LOG.error("Fail to reset ClusterStatusMonitor, cluster: " + this._clusterName, (Throwable)e);
        }
    }

    public void refreshWorkflowsStatus(WorkflowControllerDataProvider cache) {
        for (Map.Entry<String, WorkflowMonitor> workflowMonitor : this._perTypeWorkflowMonitorMap.entrySet()) {
            workflowMonitor.getValue().resetGauges();
        }
        Map<String, WorkflowConfig> workflowConfigMap = cache.getWorkflowConfigMap();
        for (String workflow : workflowConfigMap.keySet()) {
            if (workflowConfigMap.get(workflow).isRecurring() || workflow.isEmpty()) continue;
            WorkflowContext workflowContext = cache.getWorkflowContext(workflow);
            TaskState currentState = workflowContext == null ? TaskState.NOT_STARTED : workflowContext.getWorkflowState();
            this.updateWorkflowGauges(workflowConfigMap.get(workflow), currentState);
        }
    }

    public void updateWorkflowCounters(WorkflowConfig workflowConfig, TaskState to) {
        this.updateWorkflowCounters(workflowConfig, to, -1L);
    }

    public void updateWorkflowCounters(WorkflowConfig workflowConfig, TaskState to, long latency) {
        String workflowType = workflowConfig.getWorkflowType();
        WorkflowMonitor workflowMonitor = this._perTypeWorkflowMonitorMap.get(workflowType = this.preProcessWorkflow(workflowType));
        if (workflowMonitor != null) {
            workflowMonitor.updateWorkflowCounters(to, latency);
        }
    }

    private void updateWorkflowGauges(WorkflowConfig workflowConfig, TaskState current) {
        String workflowType = workflowConfig.getWorkflowType();
        WorkflowMonitor workflowMonitor = this._perTypeWorkflowMonitorMap.get(workflowType = this.preProcessWorkflow(workflowType));
        if (workflowMonitor != null) {
            workflowMonitor.updateWorkflowGauges(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String preProcessWorkflow(String workflowType) {
        if (workflowType == null || workflowType.length() == 0) {
            workflowType = "DEFAULT";
        }
        Map<String, WorkflowMonitor> map = this._perTypeWorkflowMonitorMap;
        synchronized (map) {
            if (!this._perTypeWorkflowMonitorMap.containsKey(workflowType)) {
                WorkflowMonitor monitor = new WorkflowMonitor(this._clusterName, workflowType);
                try {
                    monitor.register();
                }
                catch (JMException e) {
                    LOG.error("Failed to register object for workflow type : " + workflowType, (Throwable)e);
                }
                this._perTypeWorkflowMonitorMap.put(workflowType, monitor);
            }
        }
        return workflowType;
    }

    public void refreshJobsStatus(WorkflowControllerDataProvider cache) {
        for (Map.Entry<String, JobMonitor> jobMonitor : this._perTypeJobMonitorMap.entrySet()) {
            jobMonitor.getValue().resetJobGauge();
        }
        for (String workflow : cache.getWorkflowConfigMap().keySet()) {
            WorkflowConfig workflowConfig;
            if (workflow.isEmpty() || (workflowConfig = cache.getWorkflowConfig(workflow)) == null) continue;
            Set<String> allJobs = workflowConfig.getJobDag().getAllNodes();
            WorkflowContext workflowContext = cache.getWorkflowContext(workflow);
            for (String job : allJobs) {
                TaskState currentState = workflowContext == null ? TaskState.NOT_STARTED : workflowContext.getJobState(job);
                this.updateJobGauges(workflowConfig.getJobTypes() == null ? null : workflowConfig.getJobTypes().get(job), currentState);
            }
        }
    }

    public void updateJobCounters(JobConfig jobConfig, TaskState to) {
        this.updateJobCounters(jobConfig, to, -1L);
    }

    public void updateJobCounters(JobConfig jobConfig, TaskState to, long latency) {
        String jobType = jobConfig.getJobType();
        JobMonitor jobMonitor = this._perTypeJobMonitorMap.get(jobType = this.preProcessJobMonitor(jobType));
        if (jobMonitor != null) {
            jobMonitor.updateJobMetricsWithLatency(to, latency);
        }
    }

    public void updateAvailableThreadsPerJob(Map<String, Integer> threadCapacityMap) {
        for (String jobType : threadCapacityMap.keySet()) {
            JobMonitor jobMonitor = this.getJobMonitor(jobType);
            jobMonitor.updateAvailableThreadGauge(threadCapacityMap.get(jobType).intValue());
        }
    }

    public JobMonitor getJobMonitor(String jobType) {
        return this._perTypeJobMonitorMap.get(this.preProcessJobMonitor(jobType));
    }

    private void updateJobGauges(String jobType, TaskState current) {
        JobMonitor jobMonitor = this._perTypeJobMonitorMap.get(jobType = this.preProcessJobMonitor(jobType));
        if (jobMonitor != null) {
            jobMonitor.updateJobGauge(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String preProcessJobMonitor(String jobType) {
        if (jobType == null || jobType.length() == 0) {
            jobType = "DEFAULT";
        }
        Map<String, JobMonitor> map = this._perTypeJobMonitorMap;
        synchronized (map) {
            if (!this._perTypeJobMonitorMap.containsKey(jobType)) {
                String jobMonitorBeanName = this.getJobBeanName(jobType);
                JobMonitor monitor = null;
                try {
                    monitor = new JobMonitor(this._clusterName, jobType, this.getObjectName(jobMonitorBeanName));
                    monitor.register();
                }
                catch (Exception e) {
                    LOG.error("Failed to register job type : " + jobType, (Throwable)e);
                }
                if (monitor != null) {
                    this._perTypeJobMonitorMap.put(jobType, monitor);
                }
            }
        }
        return jobType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerInstances(Collection<InstanceMonitor> instances) throws JMException {
        ConcurrentHashMap<String, InstanceMonitor> concurrentHashMap = this._instanceMonitorMap;
        synchronized (concurrentHashMap) {
            for (InstanceMonitor monitor : instances) {
                String instanceName = monitor.getInstanceName();
                InstanceMonitor removedMonitor = this._instanceMonitorMap.remove(instanceName);
                if (removedMonitor != null) {
                    removedMonitor.unregister();
                }
                monitor.register();
                this._instanceMonitorMap.put(instanceName, monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAllInstances() {
        ConcurrentHashMap<String, InstanceMonitor> concurrentHashMap = this._instanceMonitorMap;
        synchronized (concurrentHashMap) {
            this.unregisterInstances(this._instanceMonitorMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterInstances(Collection<String> instances) {
        ConcurrentHashMap<String, InstanceMonitor> concurrentHashMap = this._instanceMonitorMap;
        synchronized (concurrentHashMap) {
            for (String instanceName : instances) {
                InstanceMonitor monitor = this._instanceMonitorMap.remove(instanceName);
                if (monitor == null) continue;
                monitor.unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerResources(Collection<String> resources) throws JMException {
        ConcurrentHashMap<String, ResourceMonitor> concurrentHashMap = this._resourceMonitorMap;
        synchronized (concurrentHashMap) {
            for (String resourceName : resources) {
                ResourceMonitor monitor = this._resourceMonitorMap.get(resourceName);
                if (monitor == null) continue;
                monitor.register();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAllResources() {
        ConcurrentHashMap<String, ResourceMonitor> concurrentHashMap = this._resourceMonitorMap;
        synchronized (concurrentHashMap) {
            this.unregisterResources(this._resourceMonitorMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterResources(Collection<String> resources) {
        ConcurrentHashMap<String, ResourceMonitor> concurrentHashMap = this._resourceMonitorMap;
        synchronized (concurrentHashMap) {
            for (String resourceName : resources) {
                ResourceMonitor monitor = this._resourceMonitorMap.get(resourceName);
                if (monitor == null) continue;
                monitor.unregister();
            }
            ((ConcurrentHashMap.KeySetView)this._resourceMonitorMap.keySet()).removeAll((Collection)resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAllEventMonitors() {
        ConcurrentHashMap<String, ClusterEventMonitor> concurrentHashMap = this._clusterEventMonitorMap;
        synchronized (concurrentHashMap) {
            for (ClusterEventMonitor monitor : this._clusterEventMonitorMap.values()) {
                monitor.unregister();
            }
            this._clusterEventMonitorMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPerInstanceResources(Collection<PerInstanceResourceMonitor> monitors) throws JMException {
        Map<PerInstanceResourceMonitor.BeanName, PerInstanceResourceMonitor> map = this._perInstanceResourceMonitorMap;
        synchronized (map) {
            for (PerInstanceResourceMonitor monitor : monitors) {
                String instanceName = monitor.getInstanceName();
                String resourceName = monitor.getResourceName();
                monitor.register();
                this._perInstanceResourceMonitorMap.put(new PerInstanceResourceMonitor.BeanName(this._clusterName, instanceName, resourceName), monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAllPerInstanceResources() throws MalformedObjectNameException {
        Map<PerInstanceResourceMonitor.BeanName, PerInstanceResourceMonitor> map = this._perInstanceResourceMonitorMap;
        synchronized (map) {
            this.unregisterPerInstanceResources(this._perInstanceResourceMonitorMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterPerInstanceResources(Collection<PerInstanceResourceMonitor.BeanName> beanNames) throws MalformedObjectNameException {
        Map<PerInstanceResourceMonitor.BeanName, PerInstanceResourceMonitor> map = this._perInstanceResourceMonitorMap;
        synchronized (map) {
            for (PerInstanceResourceMonitor.BeanName beanName : beanNames) {
                if (this._perInstanceResourceMonitorMap.get(beanName) == null) continue;
                this._perInstanceResourceMonitorMap.get(beanName).unregister();
            }
            this._perInstanceResourceMonitorMap.keySet().removeAll(beanNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAllWorkflowsMonitor() {
        Map<String, WorkflowMonitor> map = this._perTypeWorkflowMonitorMap;
        synchronized (map) {
            Iterator<Map.Entry<String, WorkflowMonitor>> workflowIter = this._perTypeWorkflowMonitorMap.entrySet().iterator();
            while (workflowIter.hasNext()) {
                Map.Entry<String, WorkflowMonitor> workflowEntry = workflowIter.next();
                workflowEntry.getValue().unregister();
                workflowIter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAllJobs() {
        Map<String, JobMonitor> map = this._perTypeJobMonitorMap;
        synchronized (map) {
            Iterator<Map.Entry<String, JobMonitor>> jobIter = this._perTypeJobMonitorMap.entrySet().iterator();
            while (jobIter.hasNext()) {
                Map.Entry<String, JobMonitor> jobEntry = jobIter.next();
                jobEntry.getValue().unregister();
                jobIter.remove();
            }
        }
    }

    public ResourceMonitor getResourceMonitor(String resourceName) {
        return this._resourceMonitorMap.get(resourceName);
    }

    protected String clusterBeanName() {
        return String.format("%s=%s", CLUSTER_DN_KEY, this._clusterName);
    }

    protected String getInstanceBeanName(String instanceName) {
        return String.format("%s,%s=%s", this.clusterBeanName(), INSTANCE_DN_KEY, instanceName);
    }

    protected String getResourceBeanName(String resourceName) {
        return String.format("%s,%s=%s", this.clusterBeanName(), RESOURCE_DN_KEY, resourceName);
    }

    protected String getPerInstanceResourceBeanName(String instanceName, String resourceName) {
        return new PerInstanceResourceMonitor.BeanName(this._clusterName, instanceName, resourceName).toString();
    }

    protected String getJobBeanName(String jobType) {
        return String.format("%s, %s=%s", this.clusterBeanName(), JOB_TYPE_DN_KEY, jobType);
    }

    @Override
    public String getSensorName() {
        return MonitorDomainNames.ClusterStatus.name() + "." + this._clusterName;
    }

    @Override
    public long getEnabled() {
        return this._enabled ? 1L : 0L;
    }

    @Override
    public long getMaintenance() {
        return this._inMaintenance ? 1L : 0L;
    }

    public void setMaintenance(boolean inMaintenance) {
        this._inMaintenance = inMaintenance;
    }

    @Override
    public long getPaused() {
        return this._paused ? 1L : 0L;
    }

    public void setPaused(boolean paused) {
        this._paused = paused;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public void reportRebalanceFailure() {
        this._rebalanceFailureCount.incrementAndGet();
    }

    public void reportContinuousResourceRebalanceFailureCount(long newValue) {
        this._continuousResourceRebalanceFailureCount.set(newValue);
    }

    public void reportContinuousTaskRebalanceFailureCount(long newValue) {
        this._continuousTaskRebalanceFailureCount.set(newValue);
    }

    @Override
    public long getRebalanceFailureCounter() {
        return this._rebalanceFailureCount.get();
    }

    @Override
    public long getContinuousResourceRebalanceFailureCount() {
        return this._continuousResourceRebalanceFailureCount.get();
    }

    @Override
    public long getContinuousTaskRebalanceFailureCount() {
        return this._continuousTaskRebalanceFailureCount.get();
    }

    @Override
    public long getTotalResourceGauge() {
        return this._resourceMonitorMap.size();
    }

    @Override
    public long getTotalPartitionGauge() {
        long total = 0L;
        for (Map.Entry<String, ResourceMonitor> entry : this._resourceMonitorMap.entrySet()) {
            total += entry.getValue().getPartitionGauge();
        }
        return total;
    }

    @Override
    public long getErrorPartitionGauge() {
        long total = 0L;
        for (Map.Entry<String, ResourceMonitor> entry : this._resourceMonitorMap.entrySet()) {
            total += entry.getValue().getErrorPartitionGauge();
        }
        return total;
    }

    @Override
    public long getMissingTopStatePartitionGauge() {
        long total = 0L;
        for (Map.Entry<String, ResourceMonitor> entry : this._resourceMonitorMap.entrySet()) {
            total += entry.getValue().getMissingTopStatePartitionGauge();
        }
        return total;
    }

    @Override
    public long getMissingMinActiveReplicaPartitionGauge() {
        long total = 0L;
        for (Map.Entry<String, ResourceMonitor> entry : this._resourceMonitorMap.entrySet()) {
            total += entry.getValue().getMissingMinActiveReplicaPartitionGauge();
        }
        return total;
    }

    @Override
    public long getMissingReplicaPartitionGauge() {
        long total = 0L;
        for (Map.Entry<String, ResourceMonitor> entry : this._resourceMonitorMap.entrySet()) {
            total += entry.getValue().getMissingReplicaPartitionGauge();
        }
        return total;
    }

    @Override
    public long getDifferenceWithIdealStateGauge() {
        long total = 0L;
        for (Map.Entry<String, ResourceMonitor> entry : this._resourceMonitorMap.entrySet()) {
            total += entry.getValue().getDifferenceWithIdealStateGauge();
        }
        return total;
    }

    @Override
    public long getStateTransitionCounter() {
        long total = 0L;
        for (Map.Entry<String, ResourceMonitor> entry : this._resourceMonitorMap.entrySet()) {
            total += entry.getValue().getTotalMessageReceived();
        }
        return total;
    }

    @Override
    public long getPendingStateTransitionGuage() {
        long total = 0L;
        for (Map.Entry<String, ResourceMonitor> entry : this._resourceMonitorMap.entrySet()) {
            total += entry.getValue().getNumPendingStateTransitionGauge();
        }
        return total;
    }

    @Override
    public long getNumOfResourcesRebalanceThrottledGauge() {
        long total = 0L;
        for (Map.Entry<String, ResourceMonitor> entry : this._resourceMonitorMap.entrySet()) {
            total += entry.getValue().getRebalanceThrottledByErrorPartitionGauge();
        }
        return total;
    }
}

