/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.view.dataprovider;

import java.util.List;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.api.config.ViewClusterSourceConfig;
import org.apache.helix.api.listeners.ExternalViewChangeListener;
import org.apache.helix.api.listeners.InstanceConfigChangeListener;
import org.apache.helix.api.listeners.LiveInstanceChangeListener;
import org.apache.helix.api.listeners.PreFetch;
import org.apache.helix.common.DedupEventProcessor;
import org.apache.helix.common.caches.BasicClusterDataCache;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.view.common.ClusterViewEvent;
import org.apache.helix.zookeeper.zkclient.exception.ZkInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceClusterDataProvider
extends BasicClusterDataCache
implements InstanceConfigChangeListener,
LiveInstanceChangeListener,
ExternalViewChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(SourceClusterDataProvider.class);
    private final HelixManager _helixManager;
    private final DedupEventProcessor<ClusterViewEvent.Type, ClusterViewEvent> _eventProcessor;
    protected ViewClusterSourceConfig _sourceClusterConfig;
    private HelixDataAccessor _dataAccessor;
    private PropertyKey.Builder _propertyKeyBuilder;

    public SourceClusterDataProvider(ViewClusterSourceConfig config, DedupEventProcessor<ClusterViewEvent.Type, ClusterViewEvent> eventProcessor) {
        super(config.getName());
        this._eventProcessor = eventProcessor;
        this._sourceClusterConfig = config;
        this._helixManager = HelixManagerFactory.getZKHelixManager((String)config.getName(), (String)SourceClusterDataProvider.generateHelixManagerInstanceName(config.getName()), (InstanceType)InstanceType.SPECTATOR, (String)config.getZkAddress());
    }

    public String getName() {
        return this._helixManager.getInstanceName();
    }

    public void setup() throws Exception {
        if (this._helixManager != null && this._helixManager.isConnected()) {
            LOG.info(String.format("Data provider %s is already setup", this._helixManager.getInstanceName()));
            return;
        }
        try {
            this._helixManager.connect();
            block7: for (PropertyType property : this._sourceClusterConfig.getProperties()) {
                HelixConstants.ChangeType changeType;
                switch (property) {
                    case INSTANCES: {
                        this._helixManager.addInstanceConfigChangeListener((InstanceConfigChangeListener)this);
                        changeType = HelixConstants.ChangeType.INSTANCE_CONFIG;
                        break;
                    }
                    case LIVEINSTANCES: {
                        this._helixManager.addLiveInstanceChangeListener((LiveInstanceChangeListener)this);
                        changeType = HelixConstants.ChangeType.LIVE_INSTANCE;
                        break;
                    }
                    case EXTERNALVIEW: {
                        this._helixManager.addExternalViewChangeListener((ExternalViewChangeListener)this);
                        changeType = HelixConstants.ChangeType.EXTERNAL_VIEW;
                        break;
                    }
                    default: {
                        LOG.warn(String.format("Unsupported property type: %s. Skip adding listener", property.name()));
                        continue block7;
                    }
                }
                this.notifyDataChange(changeType);
            }
            this._dataAccessor = this._helixManager.getHelixDataAccessor();
            this._propertyKeyBuilder = this._dataAccessor.keyBuilder();
            LOG.info(String.format("Data provider %s (%s) started. Source cluster detail: %s", this._helixManager.getInstanceName(), ((Object)((Object)this)).hashCode(), this._sourceClusterConfig.toString()));
        }
        catch (Exception e) {
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() {
        for (HelixConstants.ChangeType changeType : HelixConstants.ChangeType.values()) {
            this.clearCache(changeType);
        }
        if (this._helixManager != null && this._helixManager.isConnected()) {
            try {
                this._helixManager.disconnect();
                LOG.info(String.format("Data provider %s (%s) shutdown cleanly.", this._helixManager.getInstanceName(), ((Object)((Object)this)).hashCode()));
            }
            catch (ZkInterruptedException zkInterruptedException) {
                // empty catch block
            }
        }
    }

    public void refreshCache() {
        this.refresh(this._dataAccessor);
    }

    public List<String> getInstanceConfigNames() {
        return this._dataAccessor.getChildNames(this._propertyKeyBuilder.instanceConfigs());
    }

    public List<String> getLiveInstanceNames() {
        return this._dataAccessor.getChildNames(this._propertyKeyBuilder.liveInstances());
    }

    public List<String> getExternalViewNames() {
        return this._dataAccessor.getChildNames(this._propertyKeyBuilder.externalViews());
    }

    public List<PropertyType> getPropertiesToAggregate() {
        return this._sourceClusterConfig.getProperties();
    }

    @PreFetch(enabled=false)
    public void onInstanceConfigChange(List<InstanceConfig> instanceConfigs, NotificationContext context) {
        this.queueEvent(context, ClusterViewEvent.Type.InstanceConfigChange, HelixConstants.ChangeType.INSTANCE_CONFIG);
    }

    @PreFetch(enabled=false)
    public void onLiveInstanceChange(List<LiveInstance> liveInstances, NotificationContext changeContext) {
        this.queueEvent(changeContext, ClusterViewEvent.Type.LiveInstanceChange, HelixConstants.ChangeType.LIVE_INSTANCE);
    }

    @PreFetch(enabled=false)
    public void onExternalViewChange(List<ExternalView> externalViewList, NotificationContext changeContext) {
        this.queueEvent(changeContext, ClusterViewEvent.Type.ExternalViewChange, HelixConstants.ChangeType.EXTERNAL_VIEW);
    }

    private void queueEvent(NotificationContext context, ClusterViewEvent.Type changeType, HelixConstants.ChangeType cacheChangeType) throws IllegalStateException {
        if (context != null && context.getType() != NotificationContext.Type.FINALIZE) {
            this.notifyDataChange(cacheChangeType);
            this._eventProcessor.queueEvent((Object)changeType, (Object)new ClusterViewEvent(this._clusterName, changeType));
        } else {
            LOG.info("Skip queuing event from source cluster {}. ChangeType: {}, ContextType: {}", new Object[]{this._clusterName, cacheChangeType.name(), context == null ? "NoContext" : context.getType().name()});
        }
    }

    private static String generateHelixManagerInstanceName(String clusterName) {
        return String.format("SourceClusterSpectatorHelixManager-%s", clusterName);
    }

    public String toString() {
        return String.format("%s::%s", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode());
    }
}

