/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.helix.model.Message;
import org.apache.helix.monitoring.StateTransitionContext;
import org.apache.helix.monitoring.StateTransitionDataPoint;
import org.apache.helix.monitoring.mbeans.MessageLatencyMonitor;
import org.apache.helix.monitoring.mbeans.MonitorDomainNames;
import org.apache.helix.monitoring.mbeans.ParticipantMessageMonitor;
import org.apache.helix.monitoring.mbeans.StateTransitionStatMonitor;
import org.apache.helix.monitoring.mbeans.ThreadPoolExecutorMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticipantStatusMonitor {
    public static final String PARTICIPANT_KEY = "ParticipantName";
    private final ConcurrentHashMap<StateTransitionContext, StateTransitionStatMonitor> _monitorMap = new ConcurrentHashMap();
    private static final Logger LOG = LoggerFactory.getLogger(ParticipantStatusMonitor.class);
    private final String _instanceName;
    private MBeanServer _beanServer;
    private ParticipantMessageMonitor _messageMonitor;
    private MessageLatencyMonitor _messageLatencyMonitor;
    private Map<String, ThreadPoolExecutorMonitor> _executorMonitors;

    public ParticipantStatusMonitor(boolean isParticipant, String instanceName) {
        this._instanceName = instanceName;
        try {
            this._beanServer = ManagementFactory.getPlatformMBeanServer();
            if (isParticipant) {
                this._messageMonitor = new ParticipantMessageMonitor(MonitorDomainNames.CLMParticipantReport.name(), this._instanceName);
                this._messageMonitor.register();
                this._messageLatencyMonitor = new MessageLatencyMonitor(MonitorDomainNames.CLMParticipantReport.name(), this._instanceName);
                this._messageLatencyMonitor.register();
                this._executorMonitors = new ConcurrentHashMap<String, ThreadPoolExecutorMonitor>();
            }
        }
        catch (Exception e) {
            LOG.warn(e.toString());
            e.printStackTrace();
            this._beanServer = null;
        }
    }

    public synchronized void reportReceivedMessage(Message message) {
        if (this._messageMonitor != null) {
            this._messageMonitor.incrementReceivedMessages(1L);
            this._messageMonitor.incrementPendingMessages(1);
            this._messageLatencyMonitor.updateLatency(message);
        }
    }

    public synchronized void reportProcessedMessage(Message message, ParticipantMessageMonitor.ProcessedMessageState processedMessageState) {
        if (this._messageMonitor != null) {
            switch (processedMessageState) {
                case DISCARDED: {
                    this._messageMonitor.incrementDiscardedMessages(1);
                    this._messageMonitor.decrementPendingMessages(1);
                    break;
                }
                case FAILED: {
                    this._messageMonitor.incrementFailedMessages(1);
                    this._messageMonitor.decrementPendingMessages(1);
                    break;
                }
                case COMPLETED: {
                    this._messageMonitor.incrementCompletedMessages(1);
                    this._messageMonitor.decrementPendingMessages(1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportTransitionStat(StateTransitionContext cxt, StateTransitionDataPoint data) {
        if (this._beanServer == null) {
            LOG.warn("bean server is null, skip reporting");
            return;
        }
        try {
            if (!this._monitorMap.containsKey(cxt)) {
                ParticipantStatusMonitor participantStatusMonitor = this;
                synchronized (participantStatusMonitor) {
                    if (!this._monitorMap.containsKey(cxt)) {
                        StateTransitionStatMonitor bean = new StateTransitionStatMonitor(cxt, this.getObjectName(cxt.toString()));
                        this._monitorMap.put(cxt, bean);
                        bean.register();
                    }
                }
            }
            this._monitorMap.get(cxt).addDataPoint(data);
        }
        catch (Exception e) {
            LOG.warn(e.toString());
            e.printStackTrace();
        }
    }

    private ObjectName getObjectName(String name) throws MalformedObjectNameException {
        return new ObjectName(String.format("%s:%s", MonitorDomainNames.CLMParticipantReport.name(), name));
    }

    protected String getParticipantBeanName(String participantName) {
        return String.format("%s=%s", PARTICIPANT_KEY, participantName);
    }

    public void shutDown() {
        if (this._messageLatencyMonitor != null) {
            this._messageLatencyMonitor.unregister();
        }
        if (this._messageMonitor != null) {
            this._messageMonitor.unregister();
        }
        for (StateTransitionContext cxt : this._monitorMap.keySet()) {
            try {
                ObjectName name = this.getObjectName(cxt.toString());
                if (!this._beanServer.isRegistered(name)) continue;
                this._beanServer.unregisterMBean(name);
            }
            catch (Exception e) {
                LOG.warn("fail to unregister " + cxt.toString(), (Throwable)e);
            }
        }
        this._monitorMap.clear();
    }

    public void createExecutorMonitor(String type, ExecutorService executor) {
        if (this._executorMonitors == null) {
            return;
        }
        if (!(executor instanceof ThreadPoolExecutor)) {
            return;
        }
        try {
            this._executorMonitors.put(type, new ThreadPoolExecutorMonitor(type, (ThreadPoolExecutor)executor));
        }
        catch (JMException e) {
            LOG.warn(String.format("Error in creating ThreadPoolExecutorMonitor for type=%s", type), (Throwable)e);
        }
    }

    public void removeExecutorMonitor(String type) {
        ThreadPoolExecutorMonitor monitor;
        if (this._executorMonitors != null && (monitor = this._executorMonitors.remove(type)) != null) {
            monitor.unregister();
        }
    }
}

