@REM ----------------------------------------------------------------------------
@REM Copyright 2001-2004 The Apache Software Foundation.
@REM
@REM Licensed under the Apache License, Version 2.0 (the "License");
@REM you may not use this file except in compliance with the License.
@REM You may obtain a copy of the License at
@REM
@REM      http://www.apache.org/licenses/LICENSE-2.0
@REM
@REM Unless required by applicable law or agreed to in writing, software
@REM distributed under the License is distributed on an "AS IS" BASIS,
@REM WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM See the License for the specific language governing permissions and
@REM limitations under the License.
@REM ----------------------------------------------------------------------------
@REM

@echo off

set ERROR_CODE=0

:init
@REM Decide how to startup depending on the version of windows

@REM -- Win98ME
if NOT "%OS%"=="Windows_NT" goto Win9xArg

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM -- 4NT shell
if "%eval[2+2]" == "4" goto 4NTArgs

@REM -- Regular WinNT shell
set CMD_LINE_ARGS=%*
goto WinNTGetScriptDir

@REM The 4NT Shell from jp software
:4NTArgs
set CMD_LINE_ARGS=%$
goto WinNTGetScriptDir

:Win9xArg
@REM Slurp the command line arguments.  This loop allows for an unlimited number
@REM of arguments (up to the command line limit, anyway).
set CMD_LINE_ARGS=
:Win9xApp
if %1a==a goto Win9xGetScriptDir
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto Win9xApp

:Win9xGetScriptDir
set SAVEDIR=%CD%
%0\
cd %0\..\.. 
set BASEDIR=%CD%
cd %SAVEDIR%
set SAVE_DIR=
goto repoSetup

:WinNTGetScriptDir
set BASEDIR=%~dp0\..

:repoSetup


if "%JAVACMD%"=="" set JAVACMD=java

if "%REPO%"=="" set REPO=%BASEDIR%\repo

set CLASSPATH="%BASEDIR%"\conf;"%REPO%"\org\apache\helix\helix-common\1.3.2\helix-common-1.3.2.jar;"%REPO%"\org\apache\helix\metrics-common\1.3.2\metrics-common-1.3.2.jar;"%REPO%"\org\apache\helix\zookeeper-api\1.3.2\zookeeper-api-1.3.2.jar;"%REPO%"\org\apache\helix\metadata-store-directory-common\1.3.2\metadata-store-directory-common-1.3.2.jar;"%REPO%"\org\apache\commons\commons-lang3\3.8.1\commons-lang3-3.8.1.jar;"%REPO%"\org\apache\zookeeper\zookeeper\3.6.3\zookeeper-3.6.3.jar;"%REPO%"\org\apache\zookeeper\zookeeper-jute\3.6.3\zookeeper-jute-3.6.3.jar;"%REPO%"\org\apache\yetus\audience-annotations\0.5.0\audience-annotations-0.5.0.jar;"%REPO%"\io\netty\netty-handler\4.1.63.Final\netty-handler-4.1.63.Final.jar;"%REPO%"\io\netty\netty-common\4.1.63.Final\netty-common-4.1.63.Final.jar;"%REPO%"\io\netty\netty-resolver\4.1.63.Final\netty-resolver-4.1.63.Final.jar;"%REPO%"\io\netty\netty-buffer\4.1.63.Final\netty-buffer-4.1.63.Final.jar;"%REPO%"\io\netty\netty-transport\4.1.63.Final\netty-transport-4.1.63.Final.jar;"%REPO%"\io\netty\netty-codec\4.1.63.Final\netty-codec-4.1.63.Final.jar;"%REPO%"\io\netty\netty-transport-native-epoll\4.1.63.Final\netty-transport-native-epoll-4.1.63.Final.jar;"%REPO%"\io\netty\netty-transport-native-unix-common\4.1.63.Final\netty-transport-native-unix-common-4.1.63.Final.jar;"%REPO%"\javax\annotation\javax.annotation-api\1.3.2\javax.annotation-api-1.3.2.jar;"%REPO%"\org\slf4j\slf4j-api\1.7.32\slf4j-api-1.7.32.jar;"%REPO%"\org\apache\logging\log4j\log4j-slf4j-impl\2.17.1\log4j-slf4j-impl-2.17.1.jar;"%REPO%"\org\apache\logging\log4j\log4j-api\2.17.1\log4j-api-2.17.1.jar;"%REPO%"\org\apache\logging\log4j\log4j-core\2.17.1\log4j-core-2.17.1.jar;"%REPO%"\com\fasterxml\jackson\core\jackson-databind\2.12.6.1\jackson-databind-2.12.6.1.jar;"%REPO%"\com\fasterxml\jackson\core\jackson-annotations\2.12.6\jackson-annotations-2.12.6.jar;"%REPO%"\com\fasterxml\jackson\core\jackson-core\2.12.6\jackson-core-2.12.6.jar;"%REPO%"\commons-io\commons-io\2.11.0\commons-io-2.11.0.jar;"%REPO%"\commons-cli\commons-cli\1.2\commons-cli-1.2.jar;"%REPO%"\org\apache\commons\commons-math\2.1\commons-math-2.1.jar;"%REPO%"\org\apache\commons\commons-math3\3.6.1\commons-math3-3.6.1.jar;"%REPO%"\commons-codec\commons-codec\1.6\commons-codec-1.6.jar;"%REPO%"\com\google\guava\guava\31.1-jre\guava-31.1-jre.jar;"%REPO%"\com\google\guava\failureaccess\1.0.1\failureaccess-1.0.1.jar;"%REPO%"\com\google\guava\listenablefuture\9999.0-empty-to-avoid-conflict-with-guava\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;"%REPO%"\com\google\code\findbugs\jsr305\3.0.2\jsr305-3.0.2.jar;"%REPO%"\org\checkerframework\checker-qual\3.12.0\checker-qual-3.12.0.jar;"%REPO%"\com\google\errorprone\error_prone_annotations\2.11.0\error_prone_annotations-2.11.0.jar;"%REPO%"\com\google\j2objc\j2objc-annotations\1.3\j2objc-annotations-1.3.jar;"%REPO%"\org\yaml\snakeyaml\2.0\snakeyaml-2.0.jar;"%REPO%"\io\dropwizard\metrics\metrics-core\4.1.14\metrics-core-4.1.14.jar;"%REPO%"\org\apache\httpcomponents\httpclient\4.5.14\httpclient-4.5.14.jar;"%REPO%"\org\apache\httpcomponents\httpcore\4.4.16\httpcore-4.4.16.jar;"%REPO%"\commons-logging\commons-logging\1.2\commons-logging-1.2.jar;"%REPO%"\javax\xml\bind\jaxb-api\2.1\jaxb-api-2.1.jar;"%REPO%"\javax\xml\stream\stax-api\1.0-2\stax-api-1.0-2.jar;"%REPO%"\javax\activation\activation\1.1\activation-1.1.jar;"%REPO%"\org\xerial\snappy\snappy-java\1.1.7\snappy-java-1.1.7.jar;"%REPO%"\org\apache\helix\helix-core\1.3.2\helix-core-1.3.2.jar
set EXTRA_JVM_ARGUMENTS=-Dlog4j2.formatMsgNoLookups=true -Dlog4j2.configurationFile=file://"$BASEDIR"/conf/log4j2.properties
goto endInit

@REM Reaching here means variables are defined and arguments have been captured
:endInit

%JAVACMD% %JAVA_OPTS% %EXTRA_JVM_ARGUMENTS% -classpath %CLASSPATH_PREFIX%;%CLASSPATH% -Dapp.name="start-participants" -Dapp.repo="%REPO%" -Dbasedir="%BASEDIR%" org.apache.helix.tools.commandtools.ExampleParticipant %CMD_LINE_ARGS%
if ERRORLEVEL 1 goto error
goto end

:error
if "%OS%"=="Windows_NT" @endlocal
set ERROR_CODE=1

:end
@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" goto endNT

@REM For old DOS remove the set variables from ENV - we assume they were not set
@REM before we started - at least we don't leave any baggage around
set CMD_LINE_ARGS=
goto postExec

:endNT
@endlocal

:postExec

if "%FORCE_EXIT_ON_ERROR%" == "on" (
  if %ERROR_CODE% NEQ 0 exit %ERROR_CODE%
)

exit /B %ERROR_CODE%
