/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixRebalanceException;
import org.apache.helix.controller.rebalancer.waged.AssignmentMetadataStore;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.monitoring.metrics.model.LatencyMetric;

class AssignmentManager {
    private final LatencyMetric _stateReadLatency;

    public AssignmentManager(LatencyMetric stateReadLatency) {
        this._stateReadLatency = stateReadLatency;
    }

    public Map<String, ResourceAssignment> getBaselineAssignment(AssignmentMetadataStore assignmentMetadataStore, CurrentStateOutput currentStateOutput, Set<String> resources) throws HelixRebalanceException {
        HashMap<Object, Object> currentBaseline = new HashMap();
        if (assignmentMetadataStore != null) {
            try {
                this._stateReadLatency.startMeasuringLatency();
                currentBaseline = new HashMap<String, ResourceAssignment>(assignmentMetadataStore.getBaseline());
                this._stateReadLatency.endMeasuringLatency();
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to get the current baseline assignment because of unexpected error.", HelixRebalanceException.Type.INVALID_REBALANCER_STATUS, ex);
            }
        }
        currentBaseline.keySet().retainAll(resources);
        HashSet<String> missingResources = new HashSet<String>(resources);
        missingResources.removeAll(currentBaseline.keySet());
        currentBaseline.putAll(currentStateOutput.getAssignment(missingResources));
        return currentBaseline;
    }

    public Map<String, ResourceAssignment> getBestPossibleAssignment(AssignmentMetadataStore assignmentMetadataStore, CurrentStateOutput currentStateOutput, Set<String> resources) throws HelixRebalanceException {
        HashMap<Object, Object> currentBestAssignment = new HashMap();
        if (assignmentMetadataStore != null) {
            try {
                this._stateReadLatency.startMeasuringLatency();
                currentBestAssignment = new HashMap<String, ResourceAssignment>(assignmentMetadataStore.getBestPossibleAssignment());
                this._stateReadLatency.endMeasuringLatency();
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to get the current best possible assignment because of unexpected error.", HelixRebalanceException.Type.INVALID_REBALANCER_STATUS, ex);
            }
        }
        currentBestAssignment.keySet().retainAll(resources);
        HashSet<String> missingResources = new HashSet<String>(resources);
        missingResources.removeAll(currentBestAssignment.keySet());
        currentBestAssignment.putAll(currentStateOutput.getAssignment(missingResources));
        return currentBestAssignment;
    }
}

