/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.routing;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.helix.zookeeper.exception.MultiZkException;
import org.apache.helix.zookeeper.routing.RoutingDataReader;
import org.apache.http.HttpEntity;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultBackoffStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpRoutingDataReader
implements RoutingDataReader {
    private static final int DEFAULT_HTTP_TIMEOUT_IN_MS = 5000;

    @Override
    public Map<String, List<String>> getRawRoutingData(String endpoint) {
        try {
            String routingDataJson = this.getAllRoutingData(endpoint);
            return this.parseRoutingData(routingDataJson);
        }
        catch (IOException e) {
            throw new MultiZkException(e);
        }
    }

    private String getAllRoutingData(String msdsEndpoint) throws IOException {
        HttpGet requestAllData = new HttpGet(msdsEndpoint + "/routing-data");
        RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        try (CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(config).setConnectionBackoffStrategy((ConnectionBackoffStrategy)new DefaultBackoffStrategy()).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler()).build();){
            HttpEntity entity = httpClient.execute((HttpUriRequest)requestAllData).getEntity();
            if (entity == null) {
                throw new IOException("Response's entity is null!");
            }
            String string = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return string;
        }
    }

    private Map<String, List<String>> parseRoutingData(String routingDataJson) throws IOException {
        if (routingDataJson != null) {
            Map resultMap = (Map)new ObjectMapper().readValue(routingDataJson, Map.class);
            List routingDataList = (List)resultMap.get("routingData");
            Map<String, List<String>> routingData = routingDataList.stream().collect(Collectors.toMap(realmKeyPair -> (String)realmKeyPair.get("realm"), mapEntry -> (List)mapEntry.get("shardingKeys")));
            return routingData;
        }
        return Collections.emptyMap();
    }
}

