/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.datamodel.serializer;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.introspect.CodehausJacksonIntrospector;
import org.apache.helix.zookeeper.zkclient.exception.ZkMarshallingError;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;

public class ZNRecordJacksonSerializer
implements ZkSerializer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setAnnotationIntrospector((AnnotationIntrospector)new CodehausJacksonIntrospector());

    @Override
    public byte[] serialize(Object record) throws ZkMarshallingError {
        if (!(record instanceof ZNRecord)) {
            throw new ZkMarshallingError("Input object is not of type ZNRecord (was " + record + ")");
        }
        ZNRecord znRecord = (ZNRecord)record;
        try {
            return OBJECT_MAPPER.writeValueAsBytes((Object)znRecord);
        }
        catch (IOException e) {
            throw new ZkMarshallingError(String.format("Exception during serialization. ZNRecord id: %s", znRecord.getId()), e);
        }
    }

    @Override
    public Object deserialize(byte[] bytes) throws ZkMarshallingError {
        ZNRecord record;
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            record = (ZNRecord)OBJECT_MAPPER.readValue(bytes, ZNRecord.class);
        }
        catch (IOException e) {
            throw new ZkMarshallingError("Exception during deserialization!", e);
        }
        return record;
    }
}

