/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.Transition;
import org.apache.helix.model.builder.StateTransitionTableBuilder;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public final class ScheduledTaskSMD
extends StateModelDefinition {
    public static final String name = "SchedulerTaskQueue";

    public ScheduledTaskSMD() {
        super(ScheduledTaskSMD.generateConfigForScheduledTaskQueue());
    }

    public static StateModelDefinition build() {
        StateModelDefinition.Builder builder = new StateModelDefinition.Builder(name);
        builder.initialState(States.OFFLINE.name());
        builder.addState(States.COMPLETED.name(), 0);
        builder.addState(States.OFFLINE.name(), 1);
        for (HelixDefinedState state : HelixDefinedState.values()) {
            builder.addState(state.name());
        }
        builder.addTransition(States.COMPLETED.name(), States.OFFLINE.name(), 0);
        builder.addTransition(States.OFFLINE.name(), States.COMPLETED.name(), 1);
        builder.addTransition(States.OFFLINE.name(), HelixDefinedState.DROPPED.name());
        builder.dynamicUpperBound(States.COMPLETED.name(), "1");
        return builder.build();
    }

    @Deprecated
    public static ZNRecord generateConfigForScheduledTaskQueue() {
        ZNRecord record = new ZNRecord(name);
        record.setSimpleField(StateModelDefinition.StateModelDefinitionProperty.INITIAL_STATE.toString(), "OFFLINE");
        ArrayList<String> statePriorityList = new ArrayList<String>();
        statePriorityList.add("COMPLETED");
        statePriorityList.add("OFFLINE");
        statePriorityList.add("DROPPED");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_PRIORITY_LIST.toString(), statePriorityList);
        for (String state : statePriorityList) {
            String key = state + ".meta";
            HashMap<String, String> metadata = new HashMap<String, String>();
            if (state.equals("COMPLETED")) {
                metadata.put("count", "1");
                record.setMapField(key, metadata);
            }
            if (state.equals("OFFLINE")) {
                metadata.put("count", "-1");
                record.setMapField(key, metadata);
            }
            if (!state.equals("DROPPED")) continue;
            metadata.put("count", "-1");
            record.setMapField(key, metadata);
        }
        ArrayList<String> states = new ArrayList<String>();
        states.add("COMPLETED");
        states.add("DROPPED");
        states.add("OFFLINE");
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        transitions.add(new Transition("OFFLINE", "COMPLETED"));
        transitions.add(new Transition("OFFLINE", "DROPPED"));
        transitions.add(new Transition("COMPLETED", "DROPPED"));
        StateTransitionTableBuilder builder = new StateTransitionTableBuilder();
        Map<String, Map<String, String>> next = builder.buildTransitionTable(states, transitions);
        for (String state : statePriorityList) {
            String key = state + ".next";
            record.setMapField(key, next.get(state));
        }
        ArrayList<String> stateTransitionPriorityList = new ArrayList<String>();
        stateTransitionPriorityList.add("OFFLINE-COMPLETED");
        stateTransitionPriorityList.add("OFFLINE-DROPPED");
        stateTransitionPriorityList.add("COMPLETED-DROPPED");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_TRANSITION_PRIORITYLIST.toString(), stateTransitionPriorityList);
        return record;
    }

    public static enum States {
        COMPLETED,
        OFFLINE;

    }
}

