/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server.filters;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
public class CORSFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public void filter(ContainerRequestContext request) throws IOException {
        if (request.getMethod().equalsIgnoreCase("OPTIONS")) {
            String allowHeaders;
            Response.ResponseBuilder builder = Response.ok();
            String requestMethods = request.getHeaderString("Access-Control-Request-Method");
            if (requestMethods != null) {
                builder.header("Access-Control-Allow-Methods", (Object)requestMethods);
            }
            if ((allowHeaders = request.getHeaderString("Access-Control-Request-Headers")) != null) {
                builder.header("Access-Control-Allow-Headers", (Object)allowHeaders);
            }
            request.abortWith(builder.build());
        }
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) throws IOException {
        response.getHeaders().putSingle((Object)"Access-Control-Allow-Origin", (Object)"*");
        response.getHeaders().putSingle((Object)"Access-Control-Allow-Credentials", (Object)"true");
    }
}

