/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.config;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.joda.time.DateTime;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.xmlsec.config.impl.DefaultSecurityConfigurationBootstrap;
import org.opensaml.xmlsec.impl.BasicSignatureSigningConfiguration;
import org.pac4j.core.client.config.BaseClientConfiguration;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.logout.handler.DefaultLogoutHandler;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.metadata.SAML2MetadataContactPerson;
import org.pac4j.saml.metadata.SAML2MetadataUIInfo;
import org.pac4j.saml.metadata.SAML2ServiceProvicerRequestedAttribute;
import org.pac4j.saml.store.EmptyStoreFactory;
import org.pac4j.saml.store.SAMLMessageStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.WritableResource;

public class SAML2Configuration
extends BaseClientConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAML2Configuration.class);
    protected static final String RESOURCE_PREFIX = "resource:";
    protected static final String CLASSPATH_PREFIX = "classpath:";
    protected static final String FILE_PREFIX = "file:";
    protected static final String DEFAULT_PROVIDER_NAME = "pac4j-saml";
    protected static final String CERTIFICATES_PREFIX = "saml-signing-cert";
    private Resource keystoreResource;
    private String keystorePassword;
    private String privateKeyPassword;
    private String certificateNameToAppend;
    private Resource identityProviderMetadataResource;
    private String identityProviderEntityId;
    private String serviceProviderEntityId;
    private int maximumAuthenticationLifetime = 3600;
    private int acceptedSkew = 300;
    private boolean forceAuth = false;
    private boolean passive = false;
    private String comparisonType = null;
    private String authnRequestBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String responseBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String spLogoutRequestBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String spLogoutResponseBindingType = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private List<String> authnContextClassRefs = null;
    private String nameIdPolicyFormat = null;
    private boolean useNameQualifier = false;
    private boolean signMetadata;
    private WritableResource serviceProviderMetadataResource;
    private boolean forceServiceProviderMetadataGeneration;
    private boolean forceKeystoreGeneration;
    private SAMLMessageStoreFactory samlMessageStoreFactory = new EmptyStoreFactory();
    private boolean authnRequestSigned;
    private boolean spLogoutRequestSigned;
    private final List<SAML2ServiceProvicerRequestedAttribute> requestedServiceProviderAttributes = new ArrayList<SAML2ServiceProvicerRequestedAttribute>();
    private Collection<String> blackListedSignatureSigningAlgorithms;
    private List<String> signatureAlgorithms;
    private List<String> signatureReferenceDigestMethods;
    private String signatureCanonicalizationAlgorithm;
    private boolean wantsAssertionsSigned = false;
    private boolean wantsResponsesSigned = false;
    private boolean allSignatureValidationDisabled = false;
    private String keyStoreAlias;
    private String keyStoreType;
    private int assertionConsumerServiceIndex = -1;
    private int attributeConsumingServiceIndex = -1;
    private String providerName;
    private Supplier<List<XSAny>> authnRequestExtensions;
    private String attributeAsId;
    private Map<String, String> mappedAttributes = new LinkedHashMap<String, String>();
    private LogoutHandler logoutHandler;
    private String postLogoutURL;
    private Period certificateExpirationPeriod = Period.ofYears(20);
    private String certificateSignatureAlg = "SHA1WithRSA";
    private int privateKeySize = 2048;
    private List<SAML2MetadataContactPerson> contactPersons = new ArrayList<SAML2MetadataContactPerson>();
    private List<SAML2MetadataUIInfo> metadataUIInfos = new ArrayList<SAML2MetadataUIInfo>();
    private String issuerFormat = "urn:oasis:names:tc:SAML:2.0:nameid-format:entity";
    private Boolean nameIdPolicyAllowCreate = Boolean.TRUE;
    private List<String> supportedProtocols = new ArrayList<String>(Arrays.asList("urn:oasis:names:tc:SAML:2.0:protocol"));
    private String normalizedCertificateName;

    public SAML2Configuration() {
    }

    public SAML2Configuration(String keystorePath, String keystorePassword, String privateKeyPassword, String identityProviderMetadataPath) {
        this(null, null, SAML2Configuration.mapPathToResource(keystorePath), keystorePassword, privateKeyPassword, SAML2Configuration.mapPathToResource(identityProviderMetadataPath), null, null, DEFAULT_PROVIDER_NAME, null, null);
    }

    public SAML2Configuration(Resource keystoreResource, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource) {
        this(null, null, keystoreResource, keystorePassword, privateKeyPassword, identityProviderMetadataResource, null, null, DEFAULT_PROVIDER_NAME, null, null);
    }

    public SAML2Configuration(Resource keystoreResource, String keyStoreAlias, String keyStoreType, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource) {
        this(keyStoreAlias, keyStoreType, keystoreResource, keystorePassword, privateKeyPassword, identityProviderMetadataResource, null, null, DEFAULT_PROVIDER_NAME, null, null);
    }

    protected SAML2Configuration(String keyStoreAlias, String keyStoreType, Resource keystoreResource, String keystorePassword, String privateKeyPassword, Resource identityProviderMetadataResource, String identityProviderEntityId, String serviceProviderEntityId, String providerName, Supplier<List<XSAny>> authnRequestExtensions, String attributeAsId) {
        this.keyStoreAlias = keyStoreAlias;
        this.keyStoreType = keyStoreType;
        this.keystoreResource = keystoreResource;
        this.keystorePassword = keystorePassword;
        this.privateKeyPassword = privateKeyPassword;
        this.identityProviderMetadataResource = identityProviderMetadataResource;
        this.identityProviderEntityId = identityProviderEntityId;
        this.serviceProviderEntityId = serviceProviderEntityId;
        this.providerName = providerName;
        this.authnRequestExtensions = authnRequestExtensions;
        this.attributeAsId = attributeAsId;
    }

    protected void internalInit() {
        CommonHelper.assertNotNull((String)"keystoreResource", (Object)this.keystoreResource);
        CommonHelper.assertNotBlank((String)"keystorePassword", (String)this.keystorePassword);
        CommonHelper.assertNotBlank((String)"privateKeyPassword", (String)this.privateKeyPassword);
        CommonHelper.assertNotNull((String)"identityProviderMetadataResource", (Object)this.identityProviderMetadataResource);
        if (!this.keystoreResource.exists() || this.forceKeystoreGeneration) {
            if (this.keystoreResource instanceof WritableResource) {
                LOGGER.warn("Provided keystoreResource does not exist or keystore generation is forced. Creating one for: {}", (Object)this.keystoreResource);
                this.createKeystore();
            } else {
                throw new TechnicalException("Provided keystoreResource does not exist and cannot be created");
            }
        }
        if (this.logoutHandler == null) {
            this.logoutHandler = new DefaultLogoutHandler();
        }
        this.initSignatureSigningConfiguration();
    }

    public Boolean isNameIdPolicyAllowCreate() {
        return this.nameIdPolicyAllowCreate;
    }

    public void setNameIdPolicyAllowCreate(Boolean nameIdPolicyAllowCreate) {
        this.nameIdPolicyAllowCreate = nameIdPolicyAllowCreate;
    }

    public List<SAML2MetadataContactPerson> getContactPersons() {
        return this.contactPersons;
    }

    public void setContactPersons(List<SAML2MetadataContactPerson> contactPersons) {
        this.contactPersons = contactPersons;
    }

    public List<SAML2MetadataUIInfo> getMetadataUIInfos() {
        return this.metadataUIInfos;
    }

    public void setMetadataUIInfos(List<SAML2MetadataUIInfo> metadataUIInfos) {
        this.metadataUIInfos = metadataUIInfos;
    }

    public List<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    public void setSupportedProtocols(List<String> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    public String getCertificateSignatureAlg() {
        return this.certificateSignatureAlg;
    }

    public void setCertificateSignatureAlg(String certificateSignatureAlg) {
        this.certificateSignatureAlg = certificateSignatureAlg;
    }

    public Period getCertificateExpirationPeriod() {
        return this.certificateExpirationPeriod;
    }

    public void setCertificateExpirationPeriod(Period certificateExpirationPeriod) {
        this.certificateExpirationPeriod = certificateExpirationPeriod;
    }

    public int getPrivateKeySize() {
        return this.privateKeySize;
    }

    public void setPrivateKeySize(int privateKeySize) {
        this.privateKeySize = privateKeySize;
    }

    public List<SAML2ServiceProvicerRequestedAttribute> getRequestedServiceProviderAttributes() {
        return this.requestedServiceProviderAttributes;
    }

    public void setIdentityProviderMetadataResource(Resource identityProviderMetadataResource) {
        this.identityProviderMetadataResource = identityProviderMetadataResource;
    }

    public void setIdentityProviderMetadataResourceFilepath(String path) {
        this.identityProviderMetadataResource = new FileSystemResource(path);
    }

    public void setIdentityProviderMetadataResourceClasspath(String path) {
        this.identityProviderMetadataResource = new ClassPathResource(path);
    }

    public void setIdentityProviderMetadataResourceUrl(String url) {
        this.identityProviderMetadataResource = SAML2Configuration.newUrlResource(url);
    }

    public void setIdentityProviderMetadataPath(String path) {
        this.identityProviderMetadataResource = SAML2Configuration.mapPathToResource(path);
    }

    public int getAssertionConsumerServiceIndex() {
        return this.assertionConsumerServiceIndex;
    }

    public void setAssertionConsumerServiceIndex(int assertionConsumerServiceIndex) {
        this.assertionConsumerServiceIndex = assertionConsumerServiceIndex;
    }

    public boolean isForceKeystoreGeneration() {
        return this.forceKeystoreGeneration;
    }

    public void setForceKeystoreGeneration(boolean forceKeystoreGeneration) {
        this.forceKeystoreGeneration = forceKeystoreGeneration;
    }

    protected static UrlResource newUrlResource(String url) {
        try {
            return new UrlResource(url);
        }
        catch (MalformedURLException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected static Resource mapPathToResource(String path) {
        CommonHelper.assertNotBlank((String)"path", (String)path);
        if (path.startsWith(RESOURCE_PREFIX)) {
            return new ClassPathResource(path.substring(RESOURCE_PREFIX.length()));
        }
        if (path.startsWith(CLASSPATH_PREFIX)) {
            return new ClassPathResource(path.substring(CLASSPATH_PREFIX.length()));
        }
        if (path.startsWith("http") || path.startsWith("https")) {
            return SAML2Configuration.newUrlResource(path);
        }
        if (path.startsWith(FILE_PREFIX)) {
            return new FileSystemResource(path.substring(FILE_PREFIX.length()));
        }
        return new FileSystemResource(path);
    }

    public int getAcceptedSkew() {
        return this.acceptedSkew;
    }

    public void setAcceptedSkew(int acceptedSkew) {
        this.acceptedSkew = acceptedSkew;
    }

    public Resource getIdentityProviderMetadataResource() {
        return this.identityProviderMetadataResource;
    }

    public void setIdentityProviderEntityId(String identityProviderEntityId) {
        this.identityProviderEntityId = identityProviderEntityId;
    }

    public String getIdentityProviderEntityId() {
        return this.identityProviderEntityId;
    }

    public void setKeystoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
    }

    public void setKeystoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setKeystoreResource(Resource keystoreResource) {
        this.keystoreResource = keystoreResource;
    }

    public void setKeystoreResourceFilepath(String path) {
        this.keystoreResource = new FileSystemResource(path);
    }

    public void setKeystoreResourceClasspath(String path) {
        this.keystoreResource = new ClassPathResource(path);
    }

    public void setKeystoreResourceUrl(String url) {
        this.keystoreResource = SAML2Configuration.newUrlResource(url);
    }

    public void setKeystorePath(String path) {
        this.keystoreResource = SAML2Configuration.mapPathToResource(path);
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public Resource getKeystoreResource() {
        return this.keystoreResource;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public String getCertificateNameToAppend() {
        return this.certificateNameToAppend;
    }

    public void setCertificateNameToAppend(String certificateNameToAppend) {
        this.certificateNameToAppend = certificateNameToAppend;
    }

    public void setServiceProviderMetadataResource(WritableResource serviceProviderMetadataResource) {
        this.serviceProviderMetadataResource = serviceProviderMetadataResource;
    }

    public void setServiceProviderMetadataResourceFilepath(String path) {
        this.serviceProviderMetadataResource = new FileSystemResource(path);
    }

    public void setServiceProviderMetadataPath(String path) {
        Resource resource = SAML2Configuration.mapPathToResource(path);
        if (!(resource instanceof WritableResource)) {
            throw new TechnicalException(path + " must be a writable resource");
        }
        this.serviceProviderMetadataResource = (WritableResource)resource;
    }

    public void setForceServiceProviderMetadataGeneration(boolean forceServiceProviderMetadataGeneration) {
        this.forceServiceProviderMetadataGeneration = forceServiceProviderMetadataGeneration;
    }

    public WritableResource getServiceProviderMetadataResource() {
        return this.serviceProviderMetadataResource;
    }

    public void setServiceProviderEntityId(String serviceProviderEntityId) {
        this.serviceProviderEntityId = serviceProviderEntityId;
    }

    public String getServiceProviderEntityId() {
        return this.serviceProviderEntityId;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setPassive(boolean passive) {
        this.passive = passive;
    }

    public boolean isForceAuth() {
        return this.forceAuth;
    }

    public void setForceAuth(boolean forceAuth) {
        this.forceAuth = forceAuth;
    }

    public String getComparisonType() {
        return this.comparisonType;
    }

    public void setComparisonType(String comparisonType) {
        this.comparisonType = comparisonType;
    }

    public String getAuthnRequestBindingType() {
        return this.authnRequestBindingType;
    }

    public void setAuthnRequestBindingType(String authnRequestBindingType) {
        this.authnRequestBindingType = authnRequestBindingType;
    }

    public String getResponseBindingType() {
        return this.responseBindingType;
    }

    public void setResponseBindingType(String responseBindingType) {
        this.responseBindingType = responseBindingType;
    }

    public String getSpLogoutRequestBindingType() {
        return this.spLogoutRequestBindingType;
    }

    public void setSpLogoutRequestBindingType(String spLogoutRequestBindingType) {
        this.spLogoutRequestBindingType = spLogoutRequestBindingType;
    }

    public String getSpLogoutResponseBindingType() {
        return this.spLogoutResponseBindingType;
    }

    public void setSpLogoutResponseBindingType(String spLogoutResponseBindingType) {
        this.spLogoutResponseBindingType = spLogoutResponseBindingType;
    }

    public List<String> getAuthnContextClassRefs() {
        return this.authnContextClassRefs;
    }

    public void setAuthnContextClassRefs(List<String> authnContextClassRefs) {
        this.authnContextClassRefs = authnContextClassRefs;
    }

    public String getNameIdPolicyFormat() {
        return this.nameIdPolicyFormat;
    }

    public void setNameIdPolicyFormat(String nameIdPolicyFormat) {
        this.nameIdPolicyFormat = nameIdPolicyFormat;
    }

    public int getMaximumAuthenticationLifetime() {
        return this.maximumAuthenticationLifetime;
    }

    public void setMaximumAuthenticationLifetime(int maximumAuthenticationLifetime) {
        this.maximumAuthenticationLifetime = maximumAuthenticationLifetime;
    }

    public boolean isForceServiceProviderMetadataGeneration() {
        return this.forceServiceProviderMetadataGeneration;
    }

    public SAMLMessageStoreFactory getSamlMessageStoreFactory() {
        return this.samlMessageStoreFactory;
    }

    public void setSamlMessageStoreFactory(SAMLMessageStoreFactory samlMessageStoreFactory) {
        this.samlMessageStoreFactory = samlMessageStoreFactory;
    }

    public Collection<String> getBlackListedSignatureSigningAlgorithms() {
        return this.blackListedSignatureSigningAlgorithms;
    }

    public void setBlackListedSignatureSigningAlgorithms(Collection<String> blackListedSignatureSigningAlgorithms) {
        this.blackListedSignatureSigningAlgorithms = blackListedSignatureSigningAlgorithms;
    }

    public List<String> getSignatureAlgorithms() {
        return this.signatureAlgorithms;
    }

    public void setSignatureAlgorithms(List<String> signatureAlgorithms) {
        this.signatureAlgorithms = signatureAlgorithms;
    }

    public List<String> getSignatureReferenceDigestMethods() {
        return this.signatureReferenceDigestMethods;
    }

    public void setSignatureReferenceDigestMethods(List<String> signatureReferenceDigestMethods) {
        this.signatureReferenceDigestMethods = signatureReferenceDigestMethods;
    }

    public String getSignatureCanonicalizationAlgorithm() {
        return this.signatureCanonicalizationAlgorithm;
    }

    public void setSignatureCanonicalizationAlgorithm(String signatureCanonicalizationAlgorithm) {
        this.signatureCanonicalizationAlgorithm = signatureCanonicalizationAlgorithm;
    }

    public boolean isWantsAssertionsSigned() {
        return this.wantsAssertionsSigned;
    }

    public void setWantsAssertionsSigned(boolean wantsAssertionsSigned) {
        this.wantsAssertionsSigned = wantsAssertionsSigned;
    }

    public boolean isWantsResponsesSigned() {
        return this.wantsResponsesSigned;
    }

    public void setWantsResponsesSigned(boolean wantsResponsesSigned) {
        this.wantsResponsesSigned = wantsResponsesSigned;
    }

    public boolean isAuthnRequestSigned() {
        return this.authnRequestSigned;
    }

    public void setAuthnRequestSigned(boolean authnRequestSigned) {
        this.authnRequestSigned = authnRequestSigned;
    }

    public boolean isSpLogoutRequestSigned() {
        return this.spLogoutRequestSigned;
    }

    public void setSpLogoutRequestSigned(boolean spLogoutRequestSigned) {
        this.spLogoutRequestSigned = spLogoutRequestSigned;
    }

    public boolean isAllSignatureValidationDisabled() {
        return this.allSignatureValidationDisabled;
    }

    public void setAllSignatureValidationDisabled(boolean allSignatureValidationDisabled) {
        this.allSignatureValidationDisabled = allSignatureValidationDisabled;
    }

    public int getAttributeConsumingServiceIndex() {
        return this.attributeConsumingServiceIndex;
    }

    public void setAttributeConsumingServiceIndex(int attributeConsumingServiceIndex) {
        this.attributeConsumingServiceIndex = attributeConsumingServiceIndex;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public Supplier<List<XSAny>> getAuthnRequestExtensions() {
        return this.authnRequestExtensions;
    }

    public void setAuthnRequestExtensions(Supplier<List<XSAny>> authnRequestExtensions) {
        this.authnRequestExtensions = authnRequestExtensions;
    }

    public String getAttributeAsId() {
        return this.attributeAsId;
    }

    public void setAttributeAsId(String attributeAsId) {
        this.attributeAsId = attributeAsId;
    }

    public boolean isUseNameQualifier() {
        return this.useNameQualifier;
    }

    public void setUseNameQualifier(boolean useNameQualifier) {
        this.useNameQualifier = useNameQualifier;
    }

    public boolean isSignMetadata() {
        return this.signMetadata;
    }

    public void setSignMetadata(boolean signMetadata) {
        this.signMetadata = signMetadata;
    }

    public Map<String, String> getMappedAttributes() {
        return this.mappedAttributes;
    }

    public void setMappedAttributes(Map<String, String> mappedAttributes) {
        this.mappedAttributes = mappedAttributes;
    }

    public LogoutHandler getLogoutHandler() {
        return this.logoutHandler;
    }

    public void setLogoutHandler(LogoutHandler logoutHandler) {
        this.logoutHandler = logoutHandler;
    }

    public String getPostLogoutURL() {
        return this.postLogoutURL;
    }

    public void setPostLogoutURL(String postLogoutURL) {
        this.postLogoutURL = postLogoutURL;
    }

    public LogoutHandler findLogoutHandler() {
        this.init();
        return this.logoutHandler;
    }

    public void init(String clientName) {
        this.init();
    }

    private X509Certificate createSelfSignedCert(X500Name dn, String sigName, AlgorithmIdentifier sigAlgID, KeyPair keyPair) throws Exception {
        V3TBSCertificateGenerator certGen = new V3TBSCertificateGenerator();
        certGen.setSerialNumber(new ASN1Integer(BigInteger.valueOf(1L)));
        certGen.setIssuer(dn);
        certGen.setSubject(dn);
        certGen.setStartDate(new Time(new Date(System.currentTimeMillis() - 1000L)));
        Date expiration = DateTime.now().plusDays(365 * this.certificateExpirationPeriod.getYears() + 31 * this.certificateExpirationPeriod.getMonths() + this.certificateExpirationPeriod.getDays()).toDate();
        certGen.setEndDate(new Time(expiration));
        certGen.setSignature(sigAlgID);
        certGen.setSubjectPublicKeyInfo(SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()));
        Signature sig = Signature.getInstance(sigName);
        sig.initSign(keyPair.getPrivate());
        sig.update(certGen.generateTBSCertificate().getEncoded("DER"));
        TBSCertificate tbsCert = certGen.generateTBSCertificate();
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)tbsCert);
        v.add((ASN1Encodable)sigAlgID);
        v.add((ASN1Encodable)new DERBitString(sig.sign()));
        X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(new DERSequence(v).getEncoded("DER")));
        cert.verify(keyPair.getPublic());
        return cert;
    }

    private void createKeystore() {
        try {
            if (CommonHelper.isBlank((String)this.keyStoreAlias)) {
                this.keyStoreAlias = ((Object)((Object)this)).getClass().getSimpleName();
                LOGGER.warn("Using keystore alias {}", (Object)this.keyStoreAlias);
            }
            if (CommonHelper.isBlank((String)this.keyStoreType)) {
                this.keyStoreType = KeyStore.getDefaultType();
                LOGGER.warn("Using keystore type {}", (Object)this.keyStoreType);
            }
            KeyStore ks = KeyStore.getInstance(this.keyStoreType);
            char[] password = this.keystorePassword.toCharArray();
            ks.load(null, password);
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(this.privateKeySize);
            KeyPair kp = kpg.genKeyPair();
            AlgorithmIdentifier sigAlgID = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE);
            String dn = InetAddress.getLocalHost().getHostName();
            PrivateKey signingKey = kp.getPrivate();
            X509Certificate certificate = this.createSelfSignedCert(new X500Name("CN=" + dn), this.certificateSignatureAlg, sigAlgID, kp);
            char[] keyPassword = this.privateKeyPassword.toCharArray();
            ks.setKeyEntry(this.keyStoreAlias, signingKey, keyPassword, new Certificate[]{certificate});
            File keystoreFile = this.keystoreResource.getFile();
            try (FileOutputStream fos = new FileOutputStream(keystoreFile.getCanonicalPath());){
                ks.store(fos, password);
                fos.flush();
            }
            File signingCertEncoded = this.getSigningBase64CertificatePath();
            SAML2Configuration.writeEncodedCertificateToFile(signingCertEncoded, certificate.getEncoded());
            File signingCertBinary = this.getSigningBinaryCertificatePath();
            SAML2Configuration.writeBinaryCertificateToFile(signingCertBinary, certificate.getEncoded());
            File signingKeyEncoded = this.getSigningKeyFile();
            SAML2Configuration.writeEncodedCertificateToFile(signingKeyEncoded, signingKey.getEncoded());
            LOGGER.info("Created keystore {} with key alias {} ", (Object)this.keystoreResource.getFile().getCanonicalPath(), (Object)ks.aliases().nextElement());
        }
        catch (Exception e) {
            throw new SAMLException("Could not create keystore", e);
        }
    }

    public File getSigningBinaryCertificatePath() throws IOException {
        return new File(this.keystoreResource.getFile().getParentFile(), this.getNormalizedCertificateName() + ".crt");
    }

    public File getSigningBase64CertificatePath() throws IOException {
        return new File(this.keystoreResource.getFile().getParentFile(), this.getNormalizedCertificateName() + ".pem");
    }

    public File getSigningKeyFile() throws IOException {
        return new File(this.keystoreResource.getFile().getParentFile(), this.getNormalizedCertificateName() + ".key");
    }

    private String getNormalizedCertificateName() {
        if (this.normalizedCertificateName == null) {
            StringBuilder certName = new StringBuilder(CERTIFICATES_PREFIX);
            if (CommonHelper.isNotBlank((String)this.certificateNameToAppend)) {
                certName.append('-');
                certName.append(this.certificateNameToAppend.replaceAll("[^a-zA-Z0-9-_\\.]", ""));
            }
            this.normalizedCertificateName = certName.toString();
        }
        return this.normalizedCertificateName;
    }

    private static void writeBinaryCertificateToFile(File file, byte[] certificate) {
        if (file.exists()) {
            boolean res = file.delete();
            LOGGER.debug("Deleted file [{}]:{}", (Object)file, (Object)res);
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(certificate);
            fos.flush();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void writeEncodedCertificateToFile(File file, byte[] certificate) {
        if (file.exists()) {
            boolean res = file.delete();
            LOGGER.debug("Deleted file [{}]:{}", (Object)file, (Object)res);
        }
        try (PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            PemObject pemObject = new PemObject(file.getName(), certificate);
            pemWriter.writeObject((PemObjectGenerator)pemObject);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void initSignatureSigningConfiguration() {
        BasicSignatureSigningConfiguration config = DefaultSecurityConfigurationBootstrap.buildDefaultSignatureSigningConfiguration();
        if (this.blackListedSignatureSigningAlgorithms == null) {
            this.blackListedSignatureSigningAlgorithms = new ArrayList<String>(config.getBlacklistedAlgorithms());
            LOGGER.info("Bootstrapped Blacklisted Algorithms");
        }
        if (this.signatureAlgorithms == null) {
            this.signatureAlgorithms = new ArrayList<String>(config.getSignatureAlgorithms());
            LOGGER.info("Bootstrapped Signature Algorithms");
        }
        if (this.signatureReferenceDigestMethods == null) {
            this.signatureReferenceDigestMethods = new ArrayList<String>(config.getSignatureReferenceDigestMethods());
            this.signatureReferenceDigestMethods.remove("http://www.w3.org/2001/04/xmlenc#sha512");
            LOGGER.info("Bootstrapped Signature Reference Digest Methods");
        }
        if (this.signatureCanonicalizationAlgorithm == null) {
            this.signatureCanonicalizationAlgorithm = config.getSignatureCanonicalizationAlgorithm();
            LOGGER.info("Bootstrapped Canonicalization Algorithm");
        }
    }

    public String getIssuerFormat() {
        return this.issuerFormat;
    }

    public void setIssuerFormat(String issuerFormat) {
        this.issuerFormat = issuerFormat;
    }
}

