/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.util.ByteBufferUtil;

public class ArrayByteSequence
extends ByteSequence
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected byte[] data;
    protected int offset;
    protected int length;

    public ArrayByteSequence(byte[] data) {
        this.data = data;
        this.offset = 0;
        this.length = data.length;
    }

    public ArrayByteSequence(byte[] data, int offset, int length) {
        if (offset < 0 || offset > data.length || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(" Bad offset and/or length data.length = " + data.length + " offset = " + offset + " length = " + length);
        }
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public ArrayByteSequence(String s) {
        this(s.getBytes(StandardCharsets.UTF_8));
    }

    public ArrayByteSequence(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            this.data = buffer.array();
            this.offset = buffer.position() + buffer.arrayOffset();
            this.length = buffer.remaining();
        } else {
            this.offset = 0;
            this.data = ByteBufferUtil.toBytes(buffer);
            this.length = this.data.length;
        }
    }

    @Override
    public byte byteAt(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("i < 0, " + i);
        }
        if (i >= this.length) {
            throw new IllegalArgumentException("i >= length, " + i + " >= " + this.length);
        }
        return this.data[this.offset + i];
    }

    @Override
    public byte[] getBackingArray() {
        return this.data;
    }

    @Override
    public boolean isBackedByArray() {
        return true;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public ByteSequence subSequence(int start, int end) {
        if (start > end || start < 0 || end > this.length) {
            throw new IllegalArgumentException("Bad start and/end start = " + start + " end=" + end + " offset=" + this.offset + " length=" + this.length);
        }
        return new ArrayByteSequence(this.data, this.offset + start, end - start);
    }

    @Override
    public byte[] toArray() {
        if (this.offset == 0 && this.length == this.data.length) {
            return this.data;
        }
        byte[] copy = new byte[this.length];
        System.arraycopy(this.data, this.offset, copy, 0, this.length);
        return copy;
    }

    public String toString() {
        return new String(this.data, this.offset, this.length, StandardCharsets.UTF_8);
    }
}

