/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.ndv.hll;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.common.ndv.hll.HLLRegister;

public class HLLSparseRegister
implements HLLRegister {
    private Map<Integer, Byte> sparseMap;
    private final int p;
    private final int pPrime;
    private final int qPrime;
    private final int mask;
    private final int pPrimeMask;
    private final int qPrimeMask;

    public HLLSparseRegister(int p, int pp, int qp) {
        this.p = p;
        this.sparseMap = new HashMap<Integer, Byte>();
        this.pPrime = pp;
        this.qPrime = qp;
        this.mask = (1 << this.pPrime) - 1 ^ (1 << p) - 1;
        this.pPrimeMask = (1 << this.pPrime) - 1;
        this.qPrimeMask = (1 << this.qPrime) - 1;
    }

    @Override
    public boolean add(long hashcode) {
        boolean updated = false;
        int encodedHash = this.encodeHash(hashcode);
        int key = encodedHash & this.pPrimeMask;
        byte value = (byte)(encodedHash >>> this.pPrime);
        byte nr = 0;
        nr = encodedHash < 0 ? (byte)(value & this.qPrimeMask) : (byte)(Integer.numberOfTrailingZeros(encodedHash >>> this.p) + 1);
        updated = this.set(key, nr);
        return updated;
    }

    public int encodeHash(long hashcode) {
        int x = (int)(hashcode & (long)this.mask);
        if (x == 0) {
            int ntr = Long.numberOfTrailingZeros(hashcode >> this.p) + 1;
            long newHashCode = hashcode & (long)this.pPrimeMask;
            newHashCode |= (long)(ntr << this.pPrime);
            return (int)(newHashCode |= Integer.MIN_VALUE);
        }
        return (int)(hashcode & Integer.MAX_VALUE);
    }

    public boolean isSizeGreaterThan(int s) {
        return this.sparseMap.size() > s;
    }

    @Override
    public void merge(HLLRegister hllRegister) {
        if (hllRegister instanceof HLLSparseRegister) {
            HLLSparseRegister hsr = (HLLSparseRegister)hllRegister;
            for (Map.Entry<Integer, Byte> entry : hsr.getSparseMap().entrySet()) {
                int key = entry.getKey();
                byte value = entry.getValue();
                this.set(key, value);
            }
        } else {
            throw new IllegalArgumentException("Specified register not instance of HLLSparseRegister");
        }
    }

    @Override
    public boolean set(int key, byte value) {
        Byte containedValue = this.sparseMap.get(key);
        if (containedValue == null || value > containedValue) {
            this.sparseMap.put(key, value);
            return true;
        }
        return false;
    }

    public Map<Integer, Byte> getSparseMap() {
        return this.sparseMap;
    }

    public void extractLowBitsTo(HLLRegister dest) {
        for (Map.Entry<Integer, Byte> entry : this.getSparseMap().entrySet()) {
            int idx = entry.getKey();
            byte lr = entry.getValue();
            if (lr == 0) continue;
            dest.add(1L << this.p + lr - 1 | (long)idx);
        }
    }

    public int getP() {
        return this.p;
    }

    public int getPPrime() {
        return this.pPrime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HLLSparseRegister - ");
        sb.append("p: ");
        sb.append(this.p);
        sb.append(" pPrime: ");
        sb.append(this.pPrime);
        sb.append(" qPrime: ");
        sb.append(this.qPrime);
        return sb.toString();
    }

    public String toExtendedString() {
        return this.toString() + " register: " + this.sparseMap.toString();
    }

    public boolean equals(Object obj) {
        boolean result;
        if (!(obj instanceof HLLSparseRegister)) {
            return false;
        }
        HLLSparseRegister other = (HLLSparseRegister)obj;
        boolean bl = result = this.p == other.p && this.pPrime == other.pPrime && this.qPrime == other.qPrime;
        if (result) {
            result = result && this.sparseMap.equals(other.sparseMap);
        }
        return result;
    }

    public int hashCode() {
        int hashcode = 0;
        hashcode += 31 * this.p;
        hashcode += 31 * this.pPrime;
        hashcode += 31 * this.qPrime;
        return hashcode += this.sparseMap.hashCode();
    }
}

