/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.event.filters;

import java.util.regex.Pattern;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.event.filters.BasicFilter;

public class DatabaseAndTableFilter
extends BasicFilter {
    private final String tableName;
    private final Pattern dbPattern;

    public DatabaseAndTableFilter(String databaseNameOrPattern, String tableName) {
        this.dbPattern = databaseNameOrPattern == null || databaseNameOrPattern.equals("*") ? null : Pattern.compile(databaseNameOrPattern, 2);
        this.tableName = tableName;
    }

    @Override
    boolean shouldAccept(NotificationEvent event) {
        if (this.dbPattern == null || this.isTxnRelatedEvent(event)) {
            return true;
        }
        return this.dbPattern.matcher(event.getDbName()).matches() && (this.tableName == null || this.tableName.equalsIgnoreCase(event.getTableName()));
    }
}

