/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.InClauseBatchCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class MarkCleanedFunction
implements TransactionalFunction<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(MarkCleanedFunction.class);
    private final CompactionInfo info;

    public MarkCleanedFunction(CompactionInfo info) {
        this.info = info;
    }

    @Override
    public Void execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        MapSqlParameterSource param;
        NamedParameterJdbcTemplate jdbcTemplate = jdbcResource.getJdbcTemplate();
        if (!this.info.isAbortedTxnCleanup()) {
            param = new MapSqlParameterSource().addValue("id", (Object)this.info.id).addValue("succeeded", (Object)Character.toString('s'), 1);
            jdbcTemplate.update("INSERT INTO \"COMPLETED_COMPACTIONS\"(\n  \"CC_ID\", \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\",\n  \"CC_STATE\", \"CC_TYPE\", \"CC_TBLPROPERTIES\", \"CC_WORKER_ID\",\n  \"CC_START\", \"CC_END\", \"CC_RUN_AS\", \"CC_HIGHEST_WRITE_ID\", \"CC_META_INFO\",\n  \"CC_HADOOP_JOB_ID\", \"CC_ERROR_MESSAGE\", \"CC_ENQUEUE_TIME\",\n  \"CC_WORKER_VERSION\", \"CC_INITIATOR_ID\", \"CC_INITIATOR_VERSION\",\n  \"CC_NEXT_TXN_ID\", \"CC_TXN_ID\", \"CC_COMMIT_TIME\", \"CC_POOL_NAME\", \"CC_NUMBER_OF_BUCKETS\",\n  \"CC_ORDER_BY\")\nSELECT\n  \"CQ_ID\", \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\",\n  :succeeded, \"CQ_TYPE\", \"CQ_TBLPROPERTIES\", \"CQ_WORKER_ID\",\n  \"CQ_START\", %s, \"CQ_RUN_AS\", \"CQ_HIGHEST_WRITE_ID\", \"CQ_META_INFO\",\n  \"CQ_HADOOP_JOB_ID\", \"CQ_ERROR_MESSAGE\", \"CQ_ENQUEUE_TIME\",\n  \"CQ_WORKER_VERSION\", \"CQ_INITIATOR_ID\", \"CQ_INITIATOR_VERSION\",\n  \"CQ_NEXT_TXN_ID\", \"CQ_TXN_ID\", \"CQ_COMMIT_TIME\", \"CQ_POOL_NAME\", \"CQ_NUMBER_OF_BUCKETS\",\n  \"CQ_ORDER_BY\"\nFROM \"COMPACTION_QUEUE\"\nWHERE \"CQ_ID\" = :id".formatted(TxnUtils.getEpochFn(jdbcResource.getDatabaseProduct())), (SqlParameterSource)param);
        }
        this.removeCompactionAndAbortRetryEntries(this.info, jdbcTemplate);
        if (!this.info.isAbortedTxnCleanup()) {
            Object deleteQuery = "DELETE FROM \"COMPLETED_TXN_COMPONENTS\" WHERE \"CTC_DATABASE\" = :db AND \"CTC_TABLE\" = :table\n";
            if (this.info.partName != null) {
                deleteQuery = (String)deleteQuery + "AND \"CTC_PARTITION\" = :partition\n";
            }
            if (this.info.highestWriteId != 0L) {
                deleteQuery = (String)deleteQuery + "AND \"CTC_WRITEID\" <= :writeId\n";
            }
            param = new MapSqlParameterSource().addValue("db", (Object)this.info.dbname).addValue("table", (Object)this.info.tableName).addValue("writeId", (Object)this.info.highestWriteId);
            if (this.info.partName != null) {
                param.addValue("partition", (Object)this.info.partName);
            }
            LOG.debug("Going to execute update <{}>", deleteQuery);
            int updCount = jdbcTemplate.update((String)deleteQuery, (SqlParameterSource)param);
            if (updCount < 1) {
                LOG.warn("Expected to remove at least one row from completed_txn_components when marking compaction entry as clean!");
            }
            LOG.debug("Removed {} records from completed_txn_components", (Object)updCount);
        }
        this.removeTxnComponents(this.info, jdbcResource);
        return null;
    }

    private void removeTxnComponents(CompactionInfo info, MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("state", (Object)TxnStatus.ABORTED.getSqlConst(), 1).addValue("db", (Object)info.dbname).addValue("table", (Object)info.tableName).addValue("partition", (Object)info.partName, 12);
        String deleteQuery = "DELETE FROM \"TXN_COMPONENTS\"\nWHERE \"TC_TXNID\" IN (\n    SELECT \"TXN_ID\" FROM \"TXNS\" WHERE \"TXN_STATE\" = :state\n  )\n  AND \"TC_DATABASE\" = :db AND \"TC_TABLE\" = :table\n  AND (:partition is NULL OR \"TC_PARTITION\" = :partition)\n  AND \"TC_WRITEID\" %s\n";
        int totalCount = 0;
        if (!info.hasUncompactedAborts && info.highestWriteId != 0L) {
            totalCount = jdbcResource.getJdbcTemplate().update(deleteQuery.formatted("<= :id"), (SqlParameterSource)params.addValue("id", (Object)info.highestWriteId));
        } else if (CollectionUtils.isNotEmpty(info.writeIds)) {
            totalCount = jdbcResource.execute(new InClauseBatchCommand(deleteQuery.formatted("IN (:ids)"), (SqlParameterSource)params.addValue("ids", new ArrayList<Long>(info.writeIds)), "ids", Long::compareTo));
        }
        LOG.debug("Removed {} records from txn_components", (Object)totalCount);
    }

    private void removeCompactionAndAbortRetryEntries(CompactionInfo info, NamedParameterJdbcTemplate jdbcTemplate) {
        if (info.id == 0L) {
            return;
        }
        MapSqlParameterSource params = new MapSqlParameterSource("id", (Object)info.id);
        Object deleteQuery = "DELETE FROM \"COMPACTION_QUEUE\" WHERE \"CQ_ID\" = :id\n";
        if (!info.isAbortedTxnCleanup()) {
            deleteQuery = (String)deleteQuery + "OR (\"CQ_DATABASE\" = :db AND \"CQ_TABLE\" = :table\n  AND (:partition is NULL OR \"CQ_PARTITION\" = :partition)\n  AND \"CQ_TYPE\" = :type)\n";
            params.addValue("db", (Object)info.dbname).addValue("table", (Object)info.tableName).addValue("partition", (Object)info.partName, 12).addValue("type", (Object)Character.toString('c'), 1);
        }
        LOG.debug("Going to execute update <{}>", deleteQuery);
        int rc = jdbcTemplate.update((String)deleteQuery, (SqlParameterSource)params);
        LOG.debug("Removed {} records in COMPACTION_QUEUE", (Object)rc);
    }
}

