/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.mr;

import java.util.HashMap;
import java.util.Map;

public class AccumuloIndexDefinition {
    private final String baseTable;
    private final String indexTable;
    private final Map<String, String> colMap = new HashMap<String, String>();

    public AccumuloIndexDefinition(String baseTable, String indexTable) {
        this.baseTable = baseTable;
        this.indexTable = indexTable;
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public String getIndexTable() {
        return this.indexTable;
    }

    public void addIndexCol(String cf, String cq, String colType) {
        this.colMap.put(this.encode(cf, cq), colType);
    }

    public Map<String, String> getColumnMap() {
        return this.colMap;
    }

    public void setColumnTuples(String columns) {
        String cols;
        if (columns != null && !(cols = columns.trim()).isEmpty() && !"*".equals(cols)) {
            for (String col : cols.split(",")) {
                String[] cfcqtp = col.trim().split(":");
                this.addIndexCol(cfcqtp[0], cfcqtp[1], cfcqtp[2]);
            }
        }
    }

    public boolean contains(String cf, String cq) {
        return this.colMap.containsKey(this.encode(cf, cq));
    }

    public String getColType(String cf, String cq) {
        return this.colMap.get(this.encode(cf, cq));
    }

    private String encode(String cf, String cq) {
        return cq + ":" + cq;
    }
}

