/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli.status;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.hadoop.hive.llap.cli.status.AmInfo;
import org.apache.hadoop.hive.llap.cli.status.LlapInstance;
import org.apache.hadoop.hive.llap.cli.status.State;

class AppStatusBuilder {
    private AmInfo amInfo;
    private State state = State.UNKNOWN;
    private String diagnostics;
    private String originalConfigurationPath;
    private String generatedConfigurationPath;
    private Long appStartTime;
    private Long appFinishTime;
    private boolean runningThresholdAchieved = false;
    private Integer desiredInstances = null;
    private Integer liveInstances = null;
    private Integer launchingInstances = null;
    private final List<LlapInstance> runningInstances = new LinkedList<LlapInstance>();
    private final List<LlapInstance> completedInstances = new LinkedList<LlapInstance>();
    private final transient Map<String, LlapInstance> containerToRunningInstanceMap = new HashMap<String, LlapInstance>();
    private final transient Map<String, LlapInstance> containerToCompletedInstanceMap = new HashMap<String, LlapInstance>();

    AppStatusBuilder() {
    }

    void setAmInfo(AmInfo amInfo) {
        this.amInfo = amInfo;
    }

    AppStatusBuilder setState(State state) {
        this.state = state;
        return this;
    }

    AppStatusBuilder setDiagnostics(String diagnostics) {
        this.diagnostics = diagnostics;
        return this;
    }

    AppStatusBuilder setOriginalConfigurationPath(String originalConfigurationPath) {
        this.originalConfigurationPath = originalConfigurationPath;
        return this;
    }

    AppStatusBuilder setGeneratedConfigurationPath(String generatedConfigurationPath) {
        this.generatedConfigurationPath = generatedConfigurationPath;
        return this;
    }

    AppStatusBuilder setAppStartTime(long appStartTime) {
        this.appStartTime = appStartTime;
        return this;
    }

    AppStatusBuilder setAppFinishTime(long finishTime) {
        this.appFinishTime = finishTime;
        return this;
    }

    void setRunningThresholdAchieved(boolean runningThresholdAchieved) {
        this.runningThresholdAchieved = runningThresholdAchieved;
    }

    AppStatusBuilder setDesiredInstances(int desiredInstances) {
        this.desiredInstances = desiredInstances;
        return this;
    }

    AppStatusBuilder setLiveInstances(int liveInstances) {
        this.liveInstances = liveInstances;
        return this;
    }

    AppStatusBuilder setLaunchingInstances(int launchingInstances) {
        this.launchingInstances = launchingInstances;
        return this;
    }

    AppStatusBuilder addNewRunningLlapInstance(LlapInstance llapInstance) {
        this.runningInstances.add(llapInstance);
        this.containerToRunningInstanceMap.put(llapInstance.getContainerId(), llapInstance);
        return this;
    }

    LlapInstance removeAndGetRunningLlapInstanceForContainer(String containerIdString) {
        return this.containerToRunningInstanceMap.remove(containerIdString);
    }

    void clearRunningLlapInstances() {
        this.runningInstances.clear();
        this.containerToRunningInstanceMap.clear();
    }

    AppStatusBuilder clearAndAddPreviouslyKnownRunningInstances(List<LlapInstance> llapInstances) {
        this.clearRunningLlapInstances();
        for (LlapInstance llapInstance : llapInstances) {
            this.addNewRunningLlapInstance(llapInstance);
        }
        return this;
    }

    @JsonIgnore
    List<LlapInstance> allRunningInstances() {
        return this.runningInstances;
    }

    AppStatusBuilder addNewCompleteLlapInstance(LlapInstance llapInstance) {
        this.completedInstances.add(llapInstance);
        this.containerToCompletedInstanceMap.put(llapInstance.getContainerId(), llapInstance);
        return this;
    }

    LlapInstance removeAndGetCompletedLlapInstanceForContainer(String containerIdString) {
        return this.containerToCompletedInstanceMap.remove(containerIdString);
    }

    void clearCompletedLlapInstances() {
        this.completedInstances.clear();
        this.containerToCompletedInstanceMap.clear();
    }

    AppStatusBuilder clearAndAddPreviouslyKnownCompletedInstances(List<LlapInstance> llapInstances) {
        this.clearCompletedLlapInstances();
        for (LlapInstance llapInstance : llapInstances) {
            this.addNewCompleteLlapInstance(llapInstance);
        }
        return this;
    }

    @JsonIgnore
    List<LlapInstance> allCompletedInstances() {
        return this.completedInstances;
    }

    AmInfo getAmInfo() {
        return this.amInfo;
    }

    State getState() {
        return this.state;
    }

    String getDiagnostics() {
        return this.diagnostics;
    }

    String getOriginalConfigurationPath() {
        return this.originalConfigurationPath;
    }

    String getGeneratedConfigurationPath() {
        return this.generatedConfigurationPath;
    }

    Long getAppStartTime() {
        return this.appStartTime;
    }

    Long getAppFinishTime() {
        return this.appFinishTime;
    }

    boolean isRunningThresholdAchieved() {
        return this.runningThresholdAchieved;
    }

    Integer getDesiredInstances() {
        return this.desiredInstances;
    }

    Integer getLiveInstances() {
        return this.liveInstances;
    }

    Integer getLaunchingInstances() {
        return this.launchingInstances;
    }

    List<LlapInstance> getRunningInstances() {
        return this.runningInstances;
    }

    List<LlapInstance> getCompletedInstances() {
        return this.completedInstances;
    }

    @JsonIgnore
    AmInfo maybeCreateAndGetAmInfo() {
        if (this.amInfo == null) {
            this.amInfo = new AmInfo();
        }
        return this.amInfo;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

