/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.ObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.util.Localiser;

public class NullIfFunction
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (expr == null) {
            Class exprType = null;
            Class cls = Integer.class;
            int clsLevel = 0;
            for (int i = 0; i < args.size(); ++i) {
                SQLExpression argExpr = args.get(i);
                if (exprType == null) {
                    if (argExpr instanceof NumericExpression) {
                        exprType = NumericExpression.class;
                        cls = Integer.class;
                    } else if (argExpr instanceof StringExpression) {
                        exprType = StringExpression.class;
                        cls = String.class;
                    } else if (argExpr instanceof TemporalExpression) {
                        exprType = TemporalExpression.class;
                        cls = argExpr.getJavaTypeMapping().getJavaType();
                    } else {
                        exprType = argExpr.getClass();
                        cls = argExpr.getJavaTypeMapping().getJavaType();
                    }
                } else if (!exprType.isAssignableFrom(argExpr.getClass())) {
                    throw new NucleusUserException("NULLIF invocation first argument of type " + exprType.getName() + " yet subsequent argument of type " + argExpr.getClass().getName());
                }
                if (exprType != NumericExpression.class) continue;
                Class argType = argExpr.getJavaTypeMapping().getJavaType();
                if (clsLevel < 5 && (argType == Double.TYPE || argType == Double.class)) {
                    cls = Double.class;
                    clsLevel = 5;
                    continue;
                }
                if (clsLevel < 4 && (argType == Float.TYPE || argType == Float.class)) {
                    cls = Float.class;
                    clsLevel = 4;
                    continue;
                }
                if (clsLevel < 3 && argType == BigDecimal.class) {
                    cls = BigDecimal.class;
                    clsLevel = 3;
                    continue;
                }
                if (clsLevel < 2 && argType == BigInteger.class) {
                    cls = BigInteger.class;
                    clsLevel = 2;
                    continue;
                }
                if (clsLevel >= 1 || argType != Long.TYPE && argType != Long.class) continue;
                cls = Long.class;
                clsLevel = 1;
            }
            if (exprType == NumericExpression.class) {
                return new NumericExpression(stmt, stmt.getSQLExpressionFactory().getMappingForType(cls, true), "NULLIF", args);
            }
            if (exprType == StringExpression.class) {
                return new StringExpression(stmt, stmt.getSQLExpressionFactory().getMappingForType(cls, true), "NULLIF", args);
            }
            if (exprType == TemporalExpression.class) {
                return new TemporalExpression(stmt, stmt.getSQLExpressionFactory().getMappingForType(cls, true), "NULLIF", args);
            }
            return new ObjectExpression(stmt, stmt.getSQLExpressionFactory().getMappingForType(cls, true), "NULLIF", args);
        }
        throw new NucleusException(Localiser.msg((String)"060002", (Object[])new Object[]{"NULLIF", expr}));
    }
}

