/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.datanucleus.cache.CacheUniqueKey;
import org.datanucleus.cache.Level1Cache;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.util.ConcurrentReferenceHashMap;

public class SoftRefCache
implements Level1Cache {
    public static final String NAME = "soft";
    private Map<Object, DNStateManager> softCache = new ConcurrentReferenceHashMap<Object, DNStateManager>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    private Map<CacheUniqueKey, DNStateManager> softCacheUnique = new ConcurrentReferenceHashMap<CacheUniqueKey, DNStateManager>(1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    @Override
    public DNStateManager put(Object id, DNStateManager sm) {
        return this.softCache.put(id, sm);
    }

    @Override
    public DNStateManager get(Object id) {
        return this.softCache.get(id);
    }

    @Override
    public boolean containsKey(Object id) {
        return this.softCache.containsKey(id);
    }

    @Override
    public DNStateManager remove(Object id) {
        DNStateManager sm = this.softCache.remove(id);
        if (this.softCacheUnique.containsValue(sm)) {
            Iterator<Map.Entry<CacheUniqueKey, DNStateManager>> entrySetIter = this.softCacheUnique.entrySet().iterator();
            while (entrySetIter.hasNext()) {
                Map.Entry<CacheUniqueKey, DNStateManager> entry = entrySetIter.next();
                if (entry.getValue() != sm) continue;
                entrySetIter.remove();
            }
        }
        return sm;
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        this.softCache.clear();
        this.softCacheUnique.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.softCache.containsValue(value);
    }

    @Override
    public Set entrySet() {
        return this.softCache.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.softCache.isEmpty();
    }

    @Override
    public Set keySet() {
        return this.softCache.keySet();
    }

    @Override
    public void putAll(Map t) {
        this.softCache.putAll(t);
    }

    @Override
    public int size() {
        return this.softCache.size();
    }

    @Override
    public Collection values() {
        return this.softCache.values();
    }

    @Override
    public DNStateManager getUnique(CacheUniqueKey key) {
        return this.softCacheUnique.get(key);
    }

    @Override
    public Object putUnique(CacheUniqueKey key, DNStateManager sm) {
        return this.softCacheUnique.put(key, sm);
    }
}

