/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.ReadOnlyException;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableHandle;
import org.apache.datasketches.memory.WritableMapHandle;
import org.apache.datasketches.memory.internal.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.internal.Prim;
import org.apache.datasketches.memory.internal.UnsafeUtil;
import org.apache.datasketches.memory.internal.Util;

public interface WritableMemory
extends Memory {
    public static WritableMemory writableWrap(ByteBuffer byteBuffer) {
        return WritableMemory.writableWrap(byteBuffer, byteBuffer.order(), defaultMemReqSvr);
    }

    public static WritableMemory writableWrap(ByteBuffer byteBuffer, ByteOrder byteOrder) {
        return WritableMemory.writableWrap(byteBuffer, byteOrder, defaultMemReqSvr);
    }

    public static WritableMemory writableWrap(ByteBuffer byteBuffer, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(byteBuffer, "byteBuffer must be non-null");
        Objects.requireNonNull(byteOrder, "byteOrder must be non-null");
        Util.negativeCheck(byteBuffer.capacity(), "byteBuffer");
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyException("byteBuffer must be writable.");
        }
        return BaseWritableMemoryImpl.wrapByteBuffer(byteBuffer, false, byteOrder, memReqSvr);
    }

    public static WritableMapHandle writableMap(File file) {
        return WritableMemory.writableMap(file, 0L, file.length(), ByteOrder.nativeOrder());
    }

    public static WritableMapHandle writableMap(File file, long fileOffsetBytes, long capacityBytes, ByteOrder byteOrder) {
        Objects.requireNonNull(file, "file must be non-null.");
        Objects.requireNonNull(byteOrder, "byteOrder must be non-null.");
        if (!file.canWrite()) {
            throw new ReadOnlyException("file must be writable.");
        }
        Util.negativeCheck(file.length(), "file.length()");
        Util.negativeCheck(fileOffsetBytes, "fileOffsetBytes");
        Util.negativeCheck(capacityBytes, "capacityBytes");
        return BaseWritableMemoryImpl.wrapMap(file, fileOffsetBytes, capacityBytes, false, byteOrder);
    }

    public static WritableHandle allocateDirect(long capacityBytes) {
        return WritableMemory.allocateDirect(capacityBytes, ByteOrder.nativeOrder(), defaultMemReqSvr);
    }

    public static WritableHandle allocateDirect(long capacityBytes, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(byteOrder, "byteOrder must be non-null");
        Util.negativeCheck(capacityBytes, "capacityBytes");
        return BaseWritableMemoryImpl.wrapDirect(capacityBytes, byteOrder, memReqSvr);
    }

    default public WritableMemory writableRegion(long offsetBytes, long capacityBytes) {
        return this.writableRegion(offsetBytes, capacityBytes, this.getTypeByteOrder());
    }

    public WritableMemory writableRegion(long var1, long var3, ByteOrder var5);

    default public WritableBuffer asWritableBuffer() {
        return this.asWritableBuffer(this.getTypeByteOrder());
    }

    public WritableBuffer asWritableBuffer(ByteOrder var1);

    public static WritableMemory allocate(int capacityBytes) {
        return WritableMemory.allocate(capacityBytes, ByteOrder.nativeOrder(), defaultMemReqSvr);
    }

    public static WritableMemory allocate(int capacityBytes, ByteOrder byteOrder) {
        return WritableMemory.allocate(capacityBytes, byteOrder, defaultMemReqSvr);
    }

    public static WritableMemory allocate(int capacityBytes, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        byte[] arr = new byte[capacityBytes];
        Util.negativeCheck(capacityBytes, "capacityBytes");
        return WritableMemory.writableWrap(arr, 0, capacityBytes, byteOrder, memReqSvr);
    }

    public static WritableMemory writableWrap(byte[] array) {
        return WritableMemory.writableWrap(array, 0, array.length, ByteOrder.nativeOrder(), defaultMemReqSvr);
    }

    public static WritableMemory writableWrap(byte[] array, ByteOrder byteOrder) {
        return WritableMemory.writableWrap(array, 0, array.length, byteOrder, defaultMemReqSvr);
    }

    public static WritableMemory writableWrap(byte[] array, int offsetBytes, int lengthBytes, ByteOrder byteOrder) {
        return WritableMemory.writableWrap(array, offsetBytes, lengthBytes, byteOrder, defaultMemReqSvr);
    }

    public static WritableMemory writableWrap(byte[] array, int offsetBytes, int lengthBytes, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(array, "array must be non-null");
        Objects.requireNonNull(byteOrder, "byteOrder must be non-null");
        Util.negativeCheck(offsetBytes, "offsetBytes");
        Util.negativeCheck(lengthBytes, "lengthBytes");
        UnsafeUtil.checkBounds(offsetBytes, lengthBytes, array.length);
        return BaseWritableMemoryImpl.wrapHeapArray(array, offsetBytes, lengthBytes, false, byteOrder, memReqSvr);
    }

    public static WritableMemory writableWrap(boolean[] array) {
        Objects.requireNonNull(array, "array must be non-null");
        long lengthBytes = array.length << (int)Prim.BOOLEAN.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, false, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(char[] array) {
        Objects.requireNonNull(array, "array must be non-null");
        long lengthBytes = array.length << (int)Prim.CHAR.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, false, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(short[] array) {
        Objects.requireNonNull(array, "arr must be non-null");
        long lengthBytes = array.length << (int)Prim.SHORT.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, false, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(int[] array) {
        Objects.requireNonNull(array, "arr must be non-null");
        long lengthBytes = array.length << (int)Prim.INT.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, false, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(long[] array) {
        Objects.requireNonNull(array, "arr must be non-null");
        long lengthBytes = array.length << (int)Prim.LONG.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, false, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(float[] array) {
        Objects.requireNonNull(array, "arr must be non-null");
        long lengthBytes = array.length << (int)Prim.FLOAT.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, false, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(double[] array) {
        Objects.requireNonNull(array, "arr must be non-null");
        long lengthBytes = array.length << (int)Prim.DOUBLE.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, false, ByteOrder.nativeOrder(), null);
    }

    public void putBoolean(long var1, boolean var3);

    public void putBooleanArray(long var1, boolean[] var3, int var4, int var5);

    public void putByte(long var1, byte var3);

    public void putByteArray(long var1, byte[] var3, int var4, int var5);

    public void putChar(long var1, char var3);

    public void putCharArray(long var1, char[] var3, int var4, int var5);

    public long putCharsToUtf8(long var1, CharSequence var3);

    public void putDouble(long var1, double var3);

    public void putDoubleArray(long var1, double[] var3, int var4, int var5);

    public void putFloat(long var1, float var3);

    public void putFloatArray(long var1, float[] var3, int var4, int var5);

    public void putInt(long var1, int var3);

    public void putIntArray(long var1, int[] var3, int var4, int var5);

    public void putLong(long var1, long var3);

    public void putLongArray(long var1, long[] var3, int var4, int var5);

    public void putShort(long var1, short var3);

    public void putShortArray(long var1, short[] var3, int var4, int var5);

    public long getAndAddLong(long var1, long var3);

    public boolean compareAndSwapLong(long var1, long var3, long var5);

    public long getAndSetLong(long var1, long var3);

    public Object getArray();

    public void clear();

    public void clear(long var1, long var3);

    public void clearBits(long var1, byte var3);

    public void fill(byte var1);

    public void fill(long var1, long var3, byte var5);

    public void setBits(long var1, byte var3);

    public MemoryRequestServer getMemoryRequestServer();
}

