/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.ddl.table.partition.add.AlterTableAddPartitionDesc;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.BootstrapEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.TableEvent;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

public class FSTableEvent
implements TableEvent {
    private final Path fromPathMetadata;
    private final Path fromPathData;
    private final MetaData metadata;
    private final HiveConf hiveConf;

    FSTableEvent(HiveConf hiveConf, String metadataDir, String dataDir) {
        try {
            URI fromURI = EximUtil.getValidatedURI(hiveConf, PlanUtils.stripQuotes(metadataDir));
            this.fromPathMetadata = new Path(fromURI.getScheme(), fromURI.getAuthority(), fromURI.getPath());
            URI fromURIData = EximUtil.getValidatedURI(hiveConf, PlanUtils.stripQuotes(dataDir));
            this.fromPathData = new Path(fromURIData.getScheme(), fromURIData.getAuthority(), fromURIData.getPath());
            FileSystem fs = FileSystem.get((URI)fromURI, (Configuration)hiveConf);
            this.metadata = EximUtil.readMetaData(fs, new Path(this.fromPathMetadata, "_metadata"));
            this.hiveConf = hiveConf;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getDbName() {
        return this.metadata.getTable().getDbName();
    }

    public String getTableName() {
        return this.metadata.getTable().getTableName();
    }

    @Override
    public boolean shouldNotReplicate() {
        ReplicationSpec spec = this.replicationSpec();
        return spec.isNoop() || !spec.isInReplicationScope();
    }

    @Override
    public Path metadataPath() {
        return this.fromPathMetadata;
    }

    @Override
    public Path dataPath() {
        return this.fromPathData;
    }

    public MetaData getMetaData() {
        return this.metadata;
    }

    @Override
    public ImportTableDesc tableDesc(String dbName) throws SemanticException {
        try {
            Table table = new Table(this.metadata.getTable());
            ImportTableDesc tableDesc = new ImportTableDesc(StringUtils.isBlank((CharSequence)dbName) ? table.getDbName() : dbName, table);
            if (TableType.EXTERNAL_TABLE.equals((Object)table.getTableType())) {
                tableDesc.setLocation(table.getDataLocation() == null ? null : table.getDataLocation().toString());
                tableDesc.setExternal(true);
            }
            tableDesc.setReplicationSpec(this.replicationSpec());
            if (table.getOwner() != null) {
                tableDesc.setOwnerName(table.getOwner());
            }
            return tableDesc;
        }
        catch (Exception e) {
            throw new SemanticException((Throwable)e);
        }
    }

    @Override
    public List<AlterTableAddPartitionDesc> partitionDescriptions(ImportTableDesc tblDesc) throws SemanticException {
        ArrayList<AlterTableAddPartitionDesc> descs = new ArrayList<AlterTableAddPartitionDesc>();
        for (Partition partition : this.metadata.getPartitions()) {
            AlterTableAddPartitionDesc partsDesc = this.addPartitionDesc(this.fromPathMetadata, tblDesc, partition);
            descs.add(partsDesc);
        }
        return descs;
    }

    @Override
    public List<String> partitions(ImportTableDesc tblDesc) throws SemanticException {
        ArrayList<String> partitions = new ArrayList<String>();
        try {
            for (Partition partition : this.metadata.getPartitions()) {
                String partName = Warehouse.makePartName(tblDesc.getPartCols(), (List)partition.getValues());
                partitions.add(partName);
            }
        }
        catch (MetaException e) {
            throw new SemanticException((Throwable)e);
        }
        return partitions;
    }

    private AlterTableAddPartitionDesc addPartitionDesc(Path fromPath, ImportTableDesc tblDesc, Partition partition) throws SemanticException {
        try {
            Map<String, String> partitionSpec = EximUtil.makePartSpec(tblDesc.getPartCols(), partition.getValues());
            StorageDescriptor sd = partition.getSd();
            String location = sd.getLocation();
            if (!tblDesc.isExternal()) {
                location = new Path(fromPath, Warehouse.makePartName(tblDesc.getPartCols(), (List)partition.getValues())).toString();
            }
            ColumnStatistics columnStatistics = null;
            long writeId = -1L;
            if (partition.isSetColStats()) {
                ColumnStatistics colStats = partition.getColStats();
                ColumnStatisticsDesc colStatsDesc = new ColumnStatisticsDesc(colStats.getStatsDesc());
                colStatsDesc.setTableName(tblDesc.getTableName());
                colStatsDesc.setDbName(tblDesc.getDatabaseName());
                columnStatistics = new ColumnStatistics(colStatsDesc, colStats.getStatsObj());
                columnStatistics.setEngine(colStats.getEngine());
                writeId = partition.getWriteId();
            }
            AlterTableAddPartitionDesc.PartitionDesc partitionDesc = new AlterTableAddPartitionDesc.PartitionDesc(partitionSpec, location, partition.getParameters(), sd.getInputFormat(), sd.getOutputFormat(), sd.getNumBuckets(), sd.getCols(), sd.getSerdeInfo().getSerializationLib(), sd.getSerdeInfo().getParameters(), sd.getBucketCols(), sd.getSortCols(), columnStatistics, writeId);
            AlterTableAddPartitionDesc addPartitionDesc = new AlterTableAddPartitionDesc(tblDesc.getDatabaseName(), tblDesc.getTableName(), true, (List<AlterTableAddPartitionDesc.PartitionDesc>)ImmutableList.of((Object)partitionDesc));
            addPartitionDesc.setReplicationSpec(this.replicationSpec());
            return addPartitionDesc;
        }
        catch (Exception e) {
            throw new SemanticException((Throwable)e);
        }
    }

    @Override
    public ReplicationSpec replicationSpec() {
        return this.metadata.getReplicationSpec();
    }

    @Override
    public BootstrapEvent.EventType eventType() {
        return BootstrapEvent.EventType.Table;
    }
}

