/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates;

import org.apache.hadoop.hive.common.histogram.KllHistogramEstimator;
import org.apache.hadoop.hive.common.histogram.KllHistogramEstimatorFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.util.JavaDataModel;

@Description(name="ds_kll_sketch", value="_FUNC_(x) Returns a KllFloatsSketch in a serialized form as a binary blob. Values must be of type float.")
public class VectorUDAFComputeDsKllSketchDouble
extends VectorAggregateExpression {
    private transient int k;

    public VectorUDAFComputeDsKllSketchDouble() {
    }

    public VectorUDAFComputeDsKllSketchDouble(VectorAggregationDesc vecAggrDesc) {
        this(vecAggrDesc, 200);
    }

    public VectorUDAFComputeDsKllSketchDouble(VectorAggregationDesc vecAggrDesc, int k) {
        super(vecAggrDesc);
        this.k = k;
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        block14: {
            Aggregation myagg;
            int batchSize;
            DoubleColumnVector inputColumn;
            block15: {
                block13: {
                    this.inputExpression.evaluate(batch);
                    inputColumn = (DoubleColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
                    batchSize = batch.size;
                    if (batchSize == 0) {
                        return;
                    }
                    myagg = (Aggregation)agg;
                    myagg.prepare(this.k);
                    if (!inputColumn.noNulls) break block13;
                    if (inputColumn.isRepeating) {
                        for (int i = 0; i < batchSize; ++i) {
                            myagg.estimator.addToEstimator(inputColumn.vector[0]);
                        }
                    } else if (batch.selectedInUse) {
                        for (int s = 0; s < batchSize; ++s) {
                            int i = batch.selected[s];
                            myagg.estimator.addToEstimator(inputColumn.vector[i]);
                        }
                    } else {
                        for (int i = 0; i < batchSize; ++i) {
                            myagg.estimator.addToEstimator(inputColumn.vector[i]);
                        }
                    }
                    break block14;
                }
                if (!inputColumn.isRepeating) break block15;
                if (inputColumn.isNull[0]) break block14;
                for (int i = 0; i < batchSize; ++i) {
                    myagg.estimator.addToEstimator(inputColumn.vector[0]);
                }
                break block14;
            }
            if (batch.selectedInUse) {
                for (int j = 0; j < batchSize; ++j) {
                    int i = batch.selected[j];
                    if (inputColumn.isNull[i]) continue;
                    myagg.estimator.addToEstimator(inputColumn.vector[i]);
                }
            } else {
                for (int i = 0; i < batchSize; ++i) {
                    if (inputColumn.isNull[i]) continue;
                    myagg.estimator.addToEstimator(inputColumn.vector[i]);
                }
            }
        }
    }

    private Aggregation getAggregation(VectorAggregationBufferRow[] sets, int rowid, int bufferIndex) {
        VectorAggregationBufferRow bufferRow = sets[rowid];
        Aggregation myagg = (Aggregation)bufferRow.getAggregationBuffer(bufferIndex);
        myagg.prepare(this.k);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, VectorizedRowBatch batch) throws HiveException {
        block14: {
            int batchSize;
            DoubleColumnVector inputColumn;
            block15: {
                block13: {
                    this.inputExpression.evaluate(batch);
                    inputColumn = (DoubleColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
                    batchSize = batch.size;
                    if (batchSize == 0) {
                        return;
                    }
                    if (!inputColumn.noNulls) break block13;
                    if (inputColumn.isRepeating) {
                        for (int i = 0; i < batchSize; ++i) {
                            Aggregation myagg = this.getAggregation(aggregationBufferSets, i, aggregateIndex);
                            myagg.estimator.addToEstimator(inputColumn.vector[0]);
                        }
                    } else if (batch.selectedInUse) {
                        for (int s = 0; s < batchSize; ++s) {
                            int i = batch.selected[s];
                            Aggregation myagg = this.getAggregation(aggregationBufferSets, s, aggregateIndex);
                            myagg.estimator.addToEstimator(inputColumn.vector[i]);
                        }
                    } else {
                        for (int i = 0; i < batchSize; ++i) {
                            Aggregation myagg = this.getAggregation(aggregationBufferSets, i, aggregateIndex);
                            myagg.estimator.addToEstimator(inputColumn.vector[i]);
                        }
                    }
                    break block14;
                }
                if (!inputColumn.isRepeating) break block15;
                if (inputColumn.isNull[0]) break block14;
                for (int i = 0; i < batchSize; ++i) {
                    Aggregation myagg = this.getAggregation(aggregationBufferSets, i, aggregateIndex);
                    myagg.estimator.addToEstimator(inputColumn.vector[0]);
                }
                break block14;
            }
            if (batch.selectedInUse) {
                for (int s = 0; s < batchSize; ++s) {
                    int i = batch.selected[s];
                    if (inputColumn.isNull[i]) continue;
                    Aggregation myagg = this.getAggregation(aggregationBufferSets, s, aggregateIndex);
                    myagg.estimator.addToEstimator(inputColumn.vector[i]);
                }
            } else {
                for (int i = 0; i < batchSize; ++i) {
                    if (inputColumn.isNull[i]) continue;
                    Aggregation myagg = this.getAggregation(aggregationBufferSets, i, aggregateIndex);
                    myagg.estimator.addToEstimator(inputColumn.vector[i]);
                }
            }
        }
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        agg.reset();
    }

    @Override
    public long getAggregationBufferFixedSize() {
        return 0L;
    }

    @Override
    public boolean matches(String name, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColVectorType, GenericUDAFEvaluator.Mode mode) {
        return name.equals("ds_kll_sketch") && outputColVectorType == ColumnVector.Type.BYTES && inputColVectorType == ColumnVector.Type.DOUBLE && (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE);
    }

    @Override
    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int columnNum, VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myagg = (Aggregation)agg;
        BytesColumnVector outputCol = (BytesColumnVector)batch.cols[columnNum];
        if (myagg.estimator == null) {
            outputCol.isNull[batchIndex] = true;
            outputCol.noNulls = false;
        } else {
            outputCol.isNull[batchIndex] = false;
            outputCol.isRepeating = false;
            byte[] outputbuf = myagg.estimator.serialize();
            outputCol.setRef(batchIndex, outputbuf, 0, outputbuf.length);
        }
    }

    static class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        KllHistogramEstimator estimator;

        Aggregation() {
        }

        @Override
        public int getVariableSize() {
            return this.estimator.lengthFor(JavaDataModel.get());
        }

        @Override
        public void reset() {
            this.estimator = null;
        }

        public void prepare(int k) {
            if (this.estimator == null) {
                this.estimator = KllHistogramEstimatorFactory.getEmptyHistogramEstimator((int)k);
            }
        }
    }
}

