/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hop.pipeline.transforms.rest.fields;

import org.apache.hop.metadata.api.HopMetadataProperty;

public class ParameterField {

  @HopMetadataProperty(key = "field", injectionKey = "PARAMETER_FIELD")
  private String headerField;

  @HopMetadataProperty(key = "name", injectionKey = "PARAMETER_NAME")
  private String name;

  public ParameterField() {}

  public ParameterField(String headerField, String name) {
    this.headerField = headerField;
    this.name = name;
  }

  public String getHeaderField() {
    return headerField;
  }

  public void setHeaderField(String headerField) {
    this.headerField = headerField;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }
}
