/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster;

import java.io.Serializable;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.configuration.distributed.DistributePropertyListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedProperty;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.jetbrains.annotations.NotNull;

public final class DistributedConfigurationUtils {
    private DistributedConfigurationUtils() {
    }

    public static <T extends Serializable> IgniteInternalFuture<Void> setDefaultValue(DistributedProperty<T> prop, T val, IgniteLogger log) {
        if (prop.get() == null) {
            try {
                GridFutureAdapter<Void> fut = prop.propagateAsync(null, val);
                fut.listen(future -> {
                    if (future.error() != null) {
                        log.error("Cannot set default value of '" + prop.getName() + "'", future.error());
                    }
                });
                return fut;
            }
            catch (IgniteCheckedException e) {
                String errMsg = "Cannot initiate setting default value of '" + prop.getName() + "'";
                log.error(errMsg, e);
                return new GridFinishedFuture<Void>(new IgniteCheckedException(errMsg, e));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Skip set default value for distributed property [name=" + prop.getName() + ", clusterValue=" + prop.get() + ", defaultValue=" + val + "]");
        }
        return new GridFinishedFuture<Void>();
    }

    @NotNull
    public static <T> DistributePropertyListener<T> makeUpdateListener(String propUpdMsg, IgniteLogger log) {
        return (name, oldVal, newVal) -> {
            if (!Objects.equals(oldVal, newVal) && log.isInfoEnabled()) {
                log.info(String.format(propUpdMsg, name, oldVal, newVal));
            }
        };
    }
}

