/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.repl.executor;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.ignite3.internal.cli.config.StateFolderProvider;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandlers;
import org.apache.ignite3.internal.cli.core.exception.handler.PicocliExecutionExceptionHandler;
import org.apache.ignite3.internal.cli.core.exception.handler.ReplExceptionHandlers;
import org.apache.ignite3.internal.cli.core.repl.Repl;
import org.apache.ignite3.internal.cli.core.repl.completer.DynamicCompleterActivationPoint;
import org.apache.ignite3.internal.cli.core.repl.completer.DynamicCompleterRegistry;
import org.apache.ignite3.internal.cli.core.repl.completer.filter.CompleterFilter;
import org.apache.ignite3.internal.cli.core.repl.completer.filter.DeployUnitsOptionsFilter;
import org.apache.ignite3.internal.cli.core.repl.completer.filter.DynamicCompleterFilter;
import org.apache.ignite3.internal.cli.core.repl.completer.filter.NonRepeatableOptionsFilter;
import org.apache.ignite3.internal.cli.core.repl.completer.filter.ShortOptionsFilter;
import org.apache.ignite3.internal.cli.core.repl.context.CommandLineContextProvider;
import org.apache.ignite3.internal.cli.core.repl.executor.IgnitePicocliCommands;
import org.apache.ignite3.internal.cli.core.repl.executor.RegistryCommandExecutor;
import org.apache.ignite3.internal.cli.core.repl.executor.ReplExecutor;
import org.apache.ignite3.internal.cli.core.repl.expander.NoopExpander;
import org.jline.console.CommandRegistry;
import org.jline.console.impl.SystemRegistryImpl;
import org.jline.reader.Completer;
import org.jline.reader.Expander;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.MaskingCallback;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultHighlighter;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Terminal;
import org.jline.widget.AutosuggestionWidgets;
import org.jline.widget.TailTipWidgets;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliCommands;

public class ReplExecutorImpl
implements ReplExecutor {
    private Parser parser = new DefaultParser().escapeChars(null);
    private final Supplier<Path> workDirProvider = () -> Paths.get(System.getProperty("user.dir"), new String[0]);
    private final AtomicBoolean interrupted = new AtomicBoolean();
    private final ExceptionHandlers exceptionHandlers = new ReplExceptionHandlers(this.interrupted::set);
    private final PicocliCommands.PicocliCommandsFactory factory;
    private final Terminal terminal;

    public ReplExecutorImpl(PicocliCommands.PicocliCommandsFactory commandsFactory, Terminal terminal) {
        this.factory = commandsFactory;
        this.terminal = terminal;
    }

    private static void createTailTipWidgets(SystemRegistryImpl registry, LineReader reader) {
        TailTipWidgets widgets = new TailTipWidgets(reader, arg_0 -> ((SystemRegistryImpl)registry).commandDescription(arg_0), 5, TailTipWidgets.TipType.COMPLETER);
        widgets.enable();
        CommandLineContextProvider.setPrintWrapper(printer -> {
            widgets.disable();
            printer.run();
            widgets.enable();
        });
        registry.setScriptDescription(cmdLine -> null);
    }

    @Override
    public void execute(Repl repl) {
        try {
            repl.customizeTerminal(this.terminal);
            IgnitePicocliCommands picocliCommands = this.createPicocliCommands(repl);
            SystemRegistryImpl registry = new SystemRegistryImpl(repl.getParser() == null ? this.parser : repl.getParser(), this.terminal, this.workDirProvider, null);
            registry.setCommandRegistries(new CommandRegistry[]{picocliCommands});
            LineReader reader = this.createReader(repl.getCompleter() != null ? repl.getCompleter() : registry.completer(), (Highlighter)(repl.getHighlighter() != null ? repl.getHighlighter() : new DefaultHighlighter()), repl.getParser() != null ? repl.getParser() : this.parser);
            if (repl.getHistoryFileName() != null) {
                reader.variable("history-file", (Object)StateFolderProvider.getStateFile(repl.getHistoryFileName()));
            }
            RegistryCommandExecutor executor = new RegistryCommandExecutor(this.parser, picocliCommands.getCmd());
            ReplExecutorImpl.setupWidgets(repl, registry, reader);
            repl.onStart();
            while (!this.interrupted.get()) {
                try {
                    executor.cleanUp();
                    String prompt = repl.getPromptProvider().getPrompt();
                    String line = reader.readLine(prompt, null, (MaskingCallback)null, null);
                    if (line.isEmpty()) continue;
                    repl.getPipeline(executor, this.exceptionHandlers, line).runPipeline();
                }
                catch (Throwable t) {
                    this.exceptionHandlers.handleException(System.err::println, t);
                }
            }
            reader.getHistory().save();
        }
        catch (Throwable t) {
            this.exceptionHandlers.handleException(System.err::println, t);
        }
    }

    private static void setupWidgets(Repl repl, SystemRegistryImpl registry, LineReader reader) {
        if (repl.isTailTipWidgetsEnabled()) {
            ReplExecutorImpl.createTailTipWidgets(registry, reader);
        } else if (repl.isAutosuggestionsWidgetsEnabled()) {
            AutosuggestionWidgets widgets = new AutosuggestionWidgets(reader);
            widgets.enable();
        }
    }

    private LineReader createReader(Completer completer, Highlighter highlighter, Parser parser) {
        LineReader result = LineReaderBuilder.builder().terminal(this.terminal).completer(completer).highlighter(highlighter).parser(parser).expander((Expander)new NoopExpander()).variable("list-max", (Object)50).build();
        result.setAutosuggestion(LineReader.SuggestionType.COMPLETER);
        return result;
    }

    private IgnitePicocliCommands createPicocliCommands(Repl repl) throws Exception {
        CommandLine cmd = new CommandLine(repl.commandClass(), (CommandLine.IFactory)this.factory);
        CommandLine.IDefaultValueProvider defaultValueProvider = repl.defaultValueProvider();
        if (defaultValueProvider != null) {
            cmd.setDefaultValueProvider(defaultValueProvider);
        }
        CommandLineContextProvider.setCmd(cmd);
        cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new PicocliExecutionExceptionHandler(this.exceptionHandlers));
        cmd.setTrimQuotes(true);
        cmd.setCaseInsensitiveEnumValuesAllowed(true);
        DynamicCompleterRegistry completerRegistry = (DynamicCompleterRegistry)this.factory.create(DynamicCompleterRegistry.class);
        DynamicCompleterActivationPoint activationPoint = (DynamicCompleterActivationPoint)this.factory.create(DynamicCompleterActivationPoint.class);
        activationPoint.activateDynamicCompleter(completerRegistry);
        DynamicCompleterFilter dynamicCompleterFilter = (DynamicCompleterFilter)this.factory.create(DynamicCompleterFilter.class);
        List<CompleterFilter> filters = List.of(dynamicCompleterFilter, new ShortOptionsFilter(), new NonRepeatableOptionsFilter(cmd.getCommandSpec()), new DeployUnitsOptionsFilter());
        return new IgnitePicocliCommands(cmd, completerRegistry, filters);
    }
}

