/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db.table;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.table.ColumnConstraints;
import mil.nga.geopackage.db.table.Constraint;
import mil.nga.geopackage.db.table.ConstraintType;
import mil.nga.geopackage.db.table.RawConstraint;
import mil.nga.geopackage.db.table.TableConstraints;

public class ConstraintParser {
    private static final String REGEX_PREFIX = "(?i)(?s)^";
    private static final String CONSTRAINT_NAME_REGEX_SUFFIX = "CONSTRAINT\\s+(\".+\"|\\S+)\\s";
    private static final String CONSTRAINT_NAME_REGEX = "(?i)(?s)^CONSTRAINT\\s+(\".+\"|\\S+)\\s";
    private static final String CONSTRAINT_REGEX = "(?i)(?s)^(CONSTRAINT\\s+(\".+\"|\\S+)\\s)?(.*)";
    private static final Pattern NAME_PATTERN = Pattern.compile("(?i)(?s)^CONSTRAINT\\s+(\".+\"|\\S+)\\s");
    private static final int NAME_PATTERN_NAME_GROUP = 1;
    private static final Pattern CONSTRAINT_PATTERN = Pattern.compile("(?i)(?s)^(CONSTRAINT\\s+(\".+\"|\\S+)\\s)?(.*)");
    private static final int CONSTRAINT_PATTERN_NAME_GROUP = 2;
    private static final int CONSTRAINT_PATTERN_DEFINITION_GROUP = 3;

    public static TableConstraints getConstraints(String tableSql) {
        TableConstraints constraints = new TableConstraints();
        int start = -1;
        int end = -1;
        if (tableSql != null) {
            start = tableSql.indexOf("(");
            end = tableSql.lastIndexOf(")");
        }
        if (start >= 0 && end >= 0) {
            String definitions = tableSql.substring(start + 1, end).trim();
            int openParentheses = 0;
            int sqlStart = 0;
            for (int i = 0; i < definitions.length(); ++i) {
                char character = definitions.charAt(i);
                if (character == '(') {
                    ++openParentheses;
                    continue;
                }
                if (character == ')') {
                    --openParentheses;
                    continue;
                }
                if (character != ',' || openParentheses != 0) continue;
                String constraintSql = definitions.substring(sqlStart, i);
                ConstraintParser.addConstraints(constraints, constraintSql);
                sqlStart = i + 1;
            }
            if (sqlStart < definitions.length()) {
                String constraintSql = definitions.substring(sqlStart, definitions.length());
                ConstraintParser.addConstraints(constraints, constraintSql);
            }
        }
        return constraints;
    }

    private static void addConstraints(TableConstraints constraints, String constraintSql) {
        Constraint constraint = ConstraintParser.getTableConstraint(constraintSql);
        if (constraint != null) {
            constraints.addTableConstraint(constraint);
        } else {
            ColumnConstraints columnConstraints = ConstraintParser.getColumnConstraints(constraintSql);
            if (columnConstraints.hasConstraints()) {
                constraints.addColumnConstraints(columnConstraints);
            }
        }
    }

    public static ColumnConstraints getColumnConstraints(String constraintSql) {
        String[] parts = constraintSql.trim().split("\\s+");
        String columnName = CoreSQLUtils.quoteUnwrap(parts[0]);
        ColumnConstraints constraints = new ColumnConstraints(columnName);
        int constraintIndex = -1;
        ConstraintType constraintType = null;
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i];
            if ("CONSTRAINT".equalsIgnoreCase(part)) {
                if (constraintType != null) {
                    constraints.addConstraint(ConstraintParser.createConstraint(parts, constraintIndex, i, constraintType));
                    constraintType = null;
                }
                constraintIndex = i;
                continue;
            }
            ConstraintType type = ConstraintType.getColumnType(part);
            if (type == null) continue;
            if (constraintType != null) {
                constraints.addConstraint(ConstraintParser.createConstraint(parts, constraintIndex, i, constraintType));
                constraintIndex = -1;
            }
            if (constraintIndex < 0) {
                constraintIndex = i;
            }
            constraintType = type;
        }
        if (constraintType != null) {
            constraints.addConstraint(ConstraintParser.createConstraint(parts, constraintIndex, parts.length, constraintType));
        }
        return constraints;
    }

    private static Constraint createConstraint(String[] parts, int startIndex, int endIndex, ConstraintType type) {
        StringBuilder constraintSql = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            if (constraintSql.length() > 0) {
                constraintSql.append(" ");
            }
            constraintSql.append(parts[i]);
        }
        String sql = constraintSql.toString();
        String name = ConstraintParser.getName(sql);
        return new RawConstraint(type, name, sql);
    }

    private static Constraint getConstraint(String constraintSql, boolean table) {
        RawConstraint constraint = null;
        String[] nameAndDefinition = ConstraintParser.getNameAndDefinition(constraintSql);
        String definition = nameAndDefinition[1];
        if (definition != null) {
            String prefix = definition.split("\\s+")[0];
            ConstraintType type = null;
            type = table ? ConstraintType.getTableType(prefix) : ConstraintType.getColumnType(prefix);
            if (type != null) {
                constraint = new RawConstraint(type, nameAndDefinition[0], constraintSql.trim());
            }
        }
        return constraint;
    }

    public static Constraint getTableConstraint(String constraintSql) {
        return ConstraintParser.getConstraint(constraintSql, true);
    }

    public static boolean isTableConstraint(String constraintSql) {
        return ConstraintParser.getTableConstraint(constraintSql) != null;
    }

    public static ConstraintType getTableType(String constraintSql) {
        ConstraintType type = null;
        Constraint constraint = ConstraintParser.getTableConstraint(constraintSql);
        if (constraint != null) {
            type = constraint.getType();
        }
        return type;
    }

    public static boolean isTableType(ConstraintType type, String constraintSql) {
        boolean isType = false;
        ConstraintType constraintType = ConstraintParser.getTableType(constraintSql);
        if (constraintType != null) {
            isType = type == constraintType;
        }
        return isType;
    }

    public static Constraint getColumnConstraint(String constraintSql) {
        return ConstraintParser.getConstraint(constraintSql, false);
    }

    public static boolean isColumnConstraint(String constraintSql) {
        return ConstraintParser.getColumnConstraint(constraintSql) != null;
    }

    public static ConstraintType getColumnType(String constraintSql) {
        ConstraintType type = null;
        Constraint constraint = ConstraintParser.getColumnConstraint(constraintSql);
        if (constraint != null) {
            type = constraint.getType();
        }
        return type;
    }

    public static boolean isColumnType(ConstraintType type, String constraintSql) {
        boolean isType = false;
        ConstraintType constraintType = ConstraintParser.getColumnType(constraintSql);
        if (constraintType != null) {
            isType = type == constraintType;
        }
        return isType;
    }

    public static Constraint getConstraint(String constraintSql) {
        Constraint constraint = ConstraintParser.getTableConstraint(constraintSql);
        if (constraint == null) {
            constraint = ConstraintParser.getColumnConstraint(constraintSql);
        }
        return constraint;
    }

    public static boolean isConstraint(String constraintSql) {
        return ConstraintParser.getConstraint(constraintSql) != null;
    }

    public static ConstraintType getType(String constraintSql) {
        ConstraintType type = null;
        Constraint constraint = ConstraintParser.getConstraint(constraintSql);
        if (constraint != null) {
            type = constraint.getType();
        }
        return type;
    }

    public static boolean isType(ConstraintType type, String constraintSql) {
        boolean isType = false;
        ConstraintType constraintType = ConstraintParser.getType(constraintSql);
        if (constraintType != null) {
            isType = type == constraintType;
        }
        return isType;
    }

    public static String getName(String constraintSql) {
        String name = null;
        Matcher matcher = NAME_PATTERN.matcher(constraintSql);
        if (matcher.find()) {
            name = CoreSQLUtils.quoteUnwrap(matcher.group(1));
        }
        return name;
    }

    public static String[] getNameAndDefinition(String constraintSql) {
        String[] parts = null;
        Matcher matcher = CONSTRAINT_PATTERN.matcher(constraintSql.trim());
        if (matcher.find()) {
            String definition;
            String name = CoreSQLUtils.quoteUnwrap(matcher.group(2));
            if (name != null) {
                name = name.trim();
            }
            if ((definition = matcher.group(3)) != null) {
                definition = definition.trim();
            }
            parts = new String[]{name, definition};
        }
        return parts;
    }
}

