/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.related.media;

import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.extension.related.RelationType;
import mil.nga.geopackage.extension.related.UserRelatedTable;
import mil.nga.geopackage.extension.related.media.MediaTableMetadata;
import mil.nga.geopackage.user.UserTable;
import mil.nga.geopackage.user.custom.UserCustomColumn;
import mil.nga.geopackage.user.custom.UserCustomTable;

public class MediaTable
extends UserRelatedTable {
    public static final RelationType RELATION_TYPE = RelationType.MEDIA;
    public static final String COLUMN_DATA = "data";
    public static final String COLUMN_CONTENT_TYPE = "content_type";

    public static MediaTable create(MediaTableMetadata metadata) {
        List<UserCustomColumn> columns = metadata.buildColumns();
        return new MediaTable(metadata.getTableName(), columns, metadata.getIdColumnName());
    }

    public static List<UserCustomColumn> createRequiredColumns() {
        return MediaTable.createRequiredColumns(UserTable.DEFAULT_AUTOINCREMENT);
    }

    public static List<UserCustomColumn> createRequiredColumns(boolean autoincrement) {
        return MediaTable.createRequiredColumns(null, autoincrement);
    }

    public static List<UserCustomColumn> createRequiredColumns(String idColumnName) {
        return MediaTable.createRequiredColumns(idColumnName, UserTable.DEFAULT_AUTOINCREMENT);
    }

    public static List<UserCustomColumn> createRequiredColumns(String idColumnName, boolean autoincrement) {
        if (idColumnName == null) {
            idColumnName = "id";
        }
        ArrayList<UserCustomColumn> columns = new ArrayList<UserCustomColumn>();
        columns.add(MediaTable.createIdColumn(idColumnName, autoincrement));
        columns.add(MediaTable.createDataColumn());
        columns.add(MediaTable.createContentTypeColumn());
        return columns;
    }

    public static List<UserCustomColumn> createRequiredColumns(int startingIndex) {
        return MediaTable.createRequiredColumns(startingIndex, UserTable.DEFAULT_AUTOINCREMENT);
    }

    public static List<UserCustomColumn> createRequiredColumns(int startingIndex, boolean autoincrement) {
        return MediaTable.createRequiredColumns(startingIndex, null, autoincrement);
    }

    public static List<UserCustomColumn> createRequiredColumns(int startingIndex, String idColumnName) {
        return MediaTable.createRequiredColumns(startingIndex, idColumnName, UserTable.DEFAULT_AUTOINCREMENT);
    }

    public static List<UserCustomColumn> createRequiredColumns(int startingIndex, String idColumnName, boolean autoincrement) {
        if (idColumnName == null) {
            idColumnName = "id";
        }
        ArrayList<UserCustomColumn> columns = new ArrayList<UserCustomColumn>();
        columns.add(MediaTable.createIdColumn(startingIndex++, idColumnName, autoincrement));
        columns.add(MediaTable.createDataColumn(startingIndex++));
        columns.add(MediaTable.createContentTypeColumn(startingIndex++));
        return columns;
    }

    public static UserCustomColumn createIdColumn(String idColumnName) {
        return UserCustomColumn.createPrimaryKeyColumn(idColumnName);
    }

    public static UserCustomColumn createIdColumn(String idColumnName, boolean autoincrement) {
        return UserCustomColumn.createPrimaryKeyColumn(idColumnName, autoincrement);
    }

    public static UserCustomColumn createIdColumn(int index, String idColumnName) {
        return UserCustomColumn.createPrimaryKeyColumn(index, idColumnName);
    }

    public static UserCustomColumn createIdColumn(int index, String idColumnName, boolean autoincrement) {
        return UserCustomColumn.createPrimaryKeyColumn(index, idColumnName, autoincrement);
    }

    public static UserCustomColumn createDataColumn() {
        return MediaTable.createDataColumn(-1);
    }

    public static UserCustomColumn createDataColumn(int index) {
        return UserCustomColumn.createColumn(index, COLUMN_DATA, GeoPackageDataType.BLOB, true);
    }

    public static UserCustomColumn createContentTypeColumn() {
        return MediaTable.createContentTypeColumn(-1);
    }

    public static UserCustomColumn createContentTypeColumn(int index) {
        return UserCustomColumn.createColumn(index, COLUMN_CONTENT_TYPE, GeoPackageDataType.TEXT, true);
    }

    public static int numRequiredColumns() {
        return MediaTable.requiredColumns().size();
    }

    public static List<String> requiredColumns() {
        return MediaTable.requiredColumns(null);
    }

    public static List<String> requiredColumns(String idColumnName) {
        if (idColumnName == null) {
            idColumnName = "id";
        }
        ArrayList<String> requiredColumns = new ArrayList<String>();
        requiredColumns.add(idColumnName);
        requiredColumns.add(COLUMN_DATA);
        requiredColumns.add(COLUMN_CONTENT_TYPE);
        return requiredColumns;
    }

    public MediaTable(String tableName, List<UserCustomColumn> columns) {
        this(tableName, columns, (String)null);
    }

    public MediaTable(String tableName, List<UserCustomColumn> columns, String idColumnName) {
        super(tableName, RELATION_TYPE.getName(), RELATION_TYPE.getDataType(), columns, MediaTable.requiredColumns(idColumnName));
    }

    public MediaTable(UserCustomTable table) {
        super(RELATION_TYPE.getName(), RELATION_TYPE.getDataType(), table);
    }

    public int getIdColumnIndex() {
        return this.getPkColumnIndex();
    }

    public UserCustomColumn getIdColumn() {
        return (UserCustomColumn)this.getPkColumn();
    }

    public int getDataColumnIndex() {
        return this.getColumnIndex(COLUMN_DATA);
    }

    public UserCustomColumn getDataColumn() {
        return (UserCustomColumn)this.getColumn(COLUMN_DATA);
    }

    public int getContentTypeColumnIndex() {
        return this.getColumnIndex(COLUMN_CONTENT_TYPE);
    }

    public UserCustomColumn getContentTypeColumn() {
        return (UserCustomColumn)this.getColumn(COLUMN_CONTENT_TYPE);
    }
}

