/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.flatgeobuf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.baremaps.flatgeobuf.FlatGeoBuf;
import org.apache.baremaps.flatgeobuf.FlatGeoBufReader;
import org.apache.baremaps.flatgeobuf.FlatGeoBufTypeConversion;
import org.apache.baremaps.flatgeobuf.FlatGeoBufWriter;
import org.apache.baremaps.flatgeobuf.PackedRTree;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataSchema;
import org.apache.baremaps.store.DataStoreException;
import org.apache.baremaps.store.DataTable;

public class FlatGeoBufDataTable
implements DataTable {
    private final Path file;
    private final DataSchema schema;

    public FlatGeoBufDataTable(Path file) {
        this(file, FlatGeoBufDataTable.readSchema(file));
    }

    public FlatGeoBufDataTable(Path file, DataSchema schema) {
        this.file = file;
        this.schema = schema;
    }

    private static DataSchema readSchema(Path file) {
        DataSchema dataSchema;
        FlatGeoBufReader reader = new FlatGeoBufReader(FileChannel.open(file, StandardOpenOption.READ));
        try {
            FlatGeoBuf.Header header = reader.readHeader();
            dataSchema = FlatGeoBufTypeConversion.asSchema(header);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        reader.close();
        return dataSchema;
    }

    public DataSchema schema() {
        return this.schema;
    }

    public Iterator<DataRow> iterator() {
        try {
            FlatGeoBufReader reader = new FlatGeoBufReader(FileChannel.open(this.file, StandardOpenOption.READ));
            FlatGeoBuf.Header header = reader.readHeader();
            reader.skipIndex();
            return new RowIterator(reader, header, this.schema);
        }
        catch (IOException e) {
            throw new DataStoreException((Throwable)e);
        }
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public long size() {
        long l;
        FlatGeoBufReader reader = new FlatGeoBufReader(FileChannel.open(this.file, StandardOpenOption.READ));
        try {
            FlatGeoBuf.Header header = reader.readHeader();
            l = header.featuresCount();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DataStoreException((Throwable)e);
            }
        }
        reader.close();
        return l;
    }

    public void write(DataTable table) throws IOException {
        try (FlatGeoBufWriter writer = new FlatGeoBufWriter(FileChannel.open(this.file, StandardOpenOption.CREATE, StandardOpenOption.WRITE));){
            this.schema.columns().stream().filter(c -> c.cardinality() == DataColumn.Cardinality.REQUIRED).forEach(c -> {
                if (Objects.requireNonNull(c.type()) == DataColumn.Type.BINARY) {
                    throw new UnsupportedOperationException();
                }
            });
            FlatGeoBuf.Header header = new FlatGeoBuf.Header(this.schema.name(), null, FlatGeoBuf.GeometryType.UNKNOWN, false, false, false, false, FlatGeoBufTypeConversion.asColumns(this.schema.columns()), table.size(), 2, null, null, null, null);
            writer.writeHeader(header);
            int indexSize = (int)PackedRTree.calcSize((int)header.featuresCount(), header.indexNodeSize());
            writer.writeIndexBuffer(ByteBuffer.allocate(indexSize).order(ByteOrder.LITTLE_ENDIAN));
            for (DataRow row : table) {
                FlatGeoBuf.Feature feature = FlatGeoBufTypeConversion.asFeature(row);
                writer.writeFeature(feature);
            }
        }
    }

    public static class RowIterator
    implements Iterator<DataRow> {
        private final FlatGeoBuf.Header header;
        private final DataSchema schema;
        private final FlatGeoBufReader reader;
        private long cursor = 0L;

        public RowIterator(FlatGeoBufReader reader, FlatGeoBuf.Header header, DataSchema schema) {
            this.reader = reader;
            this.header = header;
            this.schema = schema;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.header.featuresCount();
        }

        @Override
        public DataRow next() {
            try {
                FlatGeoBuf.Feature feature = this.reader.readFeature();
                ++this.cursor;
                return FlatGeoBufTypeConversion.asRow(this.schema, feature);
            }
            catch (IOException e) {
                throw new NoSuchElementException(e);
            }
        }
    }
}

