/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tasks;

import java.net.URI;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import javax.sql.DataSource;
import org.apache.baremaps.geoparquet.GeoParquetDataStore;
import org.apache.baremaps.geoparquet.GeoParquetDataTable;
import org.apache.baremaps.openstreetmap.function.ProjectionTransformer;
import org.apache.baremaps.postgres.store.PostgresDataStore;
import org.apache.baremaps.store.DataTable;
import org.apache.baremaps.store.DataTableGeometryMapper;
import org.apache.baremaps.store.DataTableMapper;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportGeoParquet
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(ImportGeoParquet.class);
    private URI uri;
    private String tableName;
    private Object database;
    private Integer databaseSrid;

    public ImportGeoParquet() {
    }

    public ImportGeoParquet(URI uri, String tableName, Object database, Integer databaseSrid) {
        this.uri = uri;
        this.tableName = tableName;
        this.database = database;
        this.databaseSrid = databaseSrid;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        GeoParquetDataStore geoParquetDataStore = new GeoParquetDataStore(this.uri);
        DataSource dataSource = context.getDataSource(this.database);
        PostgresDataStore postgresDataStore = new PostgresDataStore(dataSource);
        for (String name : geoParquetDataStore.list()) {
            GeoParquetDataTable geoParquetTable = (GeoParquetDataTable)geoParquetDataStore.get(name);
            ProjectionTransformer projectionTransformer = new ProjectionTransformer(geoParquetTable.srid("geometry"), this.databaseSrid.intValue());
            DataTableGeometryMapper rowTransformer = new DataTableGeometryMapper((DataTable)geoParquetTable, (GeometryTransformer)projectionTransformer);
            DataTableMapper transformedDataTable = new DataTableMapper(geoParquetDataStore.get(name), (UnaryOperator)rowTransformer);
            postgresDataStore.add(this.tableName, (DataTable)transformedDataTable);
        }
    }

    public String toString() {
        return new StringJoiner(", ", ImportGeoParquet.class.getSimpleName() + "[", "]").add("uri=" + this.uri).add("database=" + this.database).add("databaseSrid=" + this.databaseSrid).toString();
    }
}

