/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.raster;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.baremaps.dem.ContourTracer;
import org.apache.baremaps.maplibre.binary.VectorTile;
import org.apache.baremaps.maplibre.vectortile.Feature;
import org.apache.baremaps.maplibre.vectortile.Layer;
import org.apache.baremaps.maplibre.vectortile.Tile;
import org.apache.baremaps.maplibre.vectortile.VectorTileEncoder;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;
import org.apache.baremaps.tilestore.raster.GeoTiffReader;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.AffineTransformation;

public class VectorContourTileStore
implements TileStore<ByteBuffer> {
    private final GeoTiffReader geoTiffReader;

    public VectorContourTileStore(GeoTiffReader geoTiffReader) {
        this.geoTiffReader = geoTiffReader;
    }

    @Override
    public ByteBuffer read(TileCoord tileCoord) throws TileStoreException {
        ByteBuffer byteBuffer;
        double[] grid = this.geoTiffReader.read(tileCoord, 256, 4);
        int increment = switch (tileCoord.z()) {
            case 1 -> 2000;
            case 2 -> 2000;
            case 3 -> 1000;
            case 4 -> 1000;
            case 5 -> 1000;
            case 6 -> 1000;
            case 7 -> 1000;
            case 8 -> 500;
            case 9 -> 500;
            case 10 -> 250;
            case 11 -> 250;
            case 12 -> 100;
            case 13 -> 100;
            case 14 -> 50;
            default -> 10;
        };
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int level = -10000; level < 10000; level += increment) {
            List contours = new ContourTracer(grid, 264, 264, false, true).traceContours((double)level);
            for (Geometry contour : contours) {
                contour = AffineTransformation.translationInstance((double)-4.0, (double)-4.0).scale(16.0, 16.0).transform(contour);
                features.add(new Feature((long)level, Map.of("level", String.valueOf(level)), contour));
            }
        }
        Layer layer = new Layer("contour", 4096, features);
        Tile tile = new Tile(List.of(layer));
        VectorTile.Tile vectorTile = new VectorTileEncoder().encodeTile(tile);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(baos);
            vectorTile.writeTo((OutputStream)gzip);
            gzip.close();
            byteBuffer = ByteBuffer.wrap(baos.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new TileStoreException(e);
            }
        }
        baos.close();
        return byteBuffer;
    }

    @Override
    public void write(TileCoord tileCoord, ByteBuffer blob) throws TileStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(TileCoord tileCoord) throws TileStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
        this.geoTiffReader.close();
    }
}

