/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.FeatureOperationException;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.LinkOperation;
import org.apache.sis.feature.OperationResult;
import org.apache.sis.feature.Property;
import org.apache.sis.feature.internal.AttributeConvention;
import org.apache.sis.feature.internal.FeatureUtilities;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

final class EnvelopeOperation
extends AbstractOperation {
    private static final long serialVersionUID = 8034615858550405350L;
    private static final ParameterDescriptorGroup EMPTY_PARAMS = FeatureUtilities.parameters("Envelope", new ParameterDescriptor[0]);
    private final String[] attributeNames;
    final CoordinateReferenceSystem targetCRS;
    private final CoordinateOperation[] attributeToCRS;
    private transient Set<String> dependencies;
    private final DefaultAttributeType<Envelope> resultType;

    EnvelopeOperation(Map<String, ?> identification, CoordinateReferenceSystem targetCRS, AbstractIdentifiedType[] geometryAttributes) throws FactoryException {
        super(identification);
        String defaultGeometry = null;
        boolean characterizedByCRS = false;
        LinkedHashMap<String, CoordinateReferenceSystem> names = new LinkedHashMap<String, CoordinateReferenceSystem>(4);
        for (AbstractIdentifiedType property : geometryAttributes) {
            Optional<DefaultAttributeType<?>> at = Features.toAttribute(property);
            if (!at.isPresent() || !Geometries.isKnownType(at.get().getValueClass())) continue;
            GenericName name = property.getName();
            String attributeName = property instanceof LinkOperation ? ((LinkOperation)property).referentName : name.toString();
            boolean isDefault = AttributeConvention.GEOMETRY_PROPERTY.equals(name);
            if (isDefault) {
                defaultGeometry = attributeName;
            }
            CoordinateReferenceSystem attributeCRS = null;
            DefaultAttributeType<?> ct = at.get().characteristics().get("sis:crs");
            if (ct != null && CoordinateReferenceSystem.class.isAssignableFrom(ct.getValueClass())) {
                attributeCRS = (CoordinateReferenceSystem)ct.getDefaultValue();
                if (targetCRS == null && isDefault) {
                    targetCRS = attributeCRS;
                }
                characterizedByCRS = true;
            }
            names.putIfAbsent(attributeName, attributeCRS);
        }
        names.remove(null);
        this.attributeNames = new String[names.size()];
        this.attributeToCRS = characterizedByCRS ? new CoordinateOperation[this.attributeNames.length] : null;
        int n = defaultGeometry == null ? 0 : 1;
        for (Map.Entry entry : names.entrySet()) {
            CoordinateReferenceSystem value;
            int i;
            String name = (String)entry.getKey();
            if (name.equals(defaultGeometry)) {
                defaultGeometry = null;
                i = 0;
            } else {
                i = n++;
            }
            this.attributeNames[i] = name;
            if (!characterizedByCRS || (value = (CoordinateReferenceSystem)entry.getValue()) == null) continue;
            if (targetCRS == null) {
                targetCRS = value;
            }
            this.attributeToCRS[i] = CRS.findOperation((CoordinateReferenceSystem)value, (CoordinateReferenceSystem)targetCRS, null);
        }
        this.resultType = (DefaultAttributeType)FeatureOperations.POOL.unique(new DefaultAttributeType<Object>(this.resultIdentification(identification), Envelope.class, 1, 1, null, new DefaultAttributeType[0]));
        this.targetCRS = targetCRS;
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return EMPTY_PARAMS;
    }

    @Override
    public AbstractIdentifiedType getResult() {
        return this.resultType;
    }

    @Override
    public synchronized Set<String> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = CollectionsExt.immutableSet((boolean)true, (Object[])this.attributeNames);
        }
        return this.dependencies;
    }

    @Override
    public Property apply(AbstractFeature feature, ParameterValueGroup parameters) {
        return new Result(feature);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.attributeNames) + Arrays.hashCode(this.attributeToCRS);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            EnvelopeOperation that = (EnvelopeOperation)obj;
            return Arrays.equals(this.attributeNames, that.attributeNames) && Arrays.equals(this.attributeToCRS, that.attributeToCRS) && Objects.equals(this.targetCRS, that.targetCRS);
        }
        return false;
    }

    private final class Result
    extends OperationResult<Envelope> {
        private static final long serialVersionUID = 4900962888075807964L;

        Result(AbstractFeature feature) {
            super(EnvelopeOperation.this.resultType, feature);
        }

        @Override
        public Envelope getValue() throws FeatureOperationException {
            String[] attributeNames = EnvelopeOperation.this.attributeNames;
            GeneralEnvelope envelope = null;
            GeneralEnvelope[] deferred = null;
            boolean hasUnknownCRS = false;
            for (int i = 0; i < attributeNames.length; ++i) {
                GeneralEnvelope genv = Geometries.wrap(this.feature.getPropertyValue(attributeNames[i])).map(GeometryWrapper::getEnvelope).orElse(null);
                if (genv == null) continue;
                CoordinateReferenceSystem sourceCRS = genv.getCoordinateReferenceSystem();
                CoordinateOperation op = null;
                if (EnvelopeOperation.this.attributeToCRS != null) {
                    op = EnvelopeOperation.this.attributeToCRS[i];
                    if (sourceCRS == null) {
                        Object geomCRS;
                        AbstractAttribute<?> at = ((AbstractAttribute)this.feature.getProperty(attributeNames[i])).characteristics().get("sis:crs");
                        if (at != null && (geomCRS = at.getValue()) != null) {
                            if (!(geomCRS instanceof CoordinateReferenceSystem)) {
                                throw new FeatureOperationException(Resources.formatInternational((short)25, AttributeConvention.CRS_CHARACTERISTIC, CoordinateReferenceSystem.class, geomCRS.getClass()));
                            }
                            sourceCRS = (CoordinateReferenceSystem)geomCRS;
                        } else if (op != null) {
                            sourceCRS = op.getSourceCRS();
                        }
                        genv.setCoordinateReferenceSystem(sourceCRS);
                    }
                }
                if (sourceCRS != null && EnvelopeOperation.this.targetCRS != null) {
                    try {
                        if (op == null) {
                            op = CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)EnvelopeOperation.this.targetCRS, null);
                        }
                        if (!op.getMathTransform().isIdentity()) {
                            genv = Envelopes.transform((CoordinateOperation)op, (Envelope)genv);
                        }
                    }
                    catch (TransformException | FactoryException e) {
                        throw new FeatureOperationException(Errors.formatInternational((short)16), (Exception)e);
                    }
                }
                hasUnknownCRS |= sourceCRS == null;
                if (envelope == null) {
                    envelope = genv;
                    continue;
                }
                if (hasUnknownCRS) {
                    throw new FeatureOperationException(Errors.formatInternational((short)157));
                }
                if (EnvelopeOperation.this.targetCRS != null) {
                    envelope.add((Envelope)genv);
                    continue;
                }
                if (deferred == null) {
                    deferred = new GeneralEnvelope[attributeNames.length];
                    deferred[0] = envelope;
                }
                deferred[i] = genv;
            }
            if (deferred == null) {
                return envelope;
            }
            try {
                return Envelopes.union(deferred);
            }
            catch (TransformException e) {
                throw new FeatureOperationException(Errors.formatInternational((short)16), (Exception)((Object)e));
            }
        }
    }
}

