/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.internal;

import java.sql.SQLException;
import java.text.Format;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.sis.metadata.internal.Identifiers;
import org.apache.sis.metadata.internal.ReferencingServices;
import org.apache.sis.metadata.internal.Resources;
import org.apache.sis.metadata.sql.util.Initializer;
import org.apache.sis.system.SystemListener;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.internal.MetadataServices;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.Context;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.CodeList;

public final class ServicesForUtility
extends MetadataServices {
    public boolean isUnmarshalling() {
        Context context = Context.current();
        return context != null && !Context.isFlagSet(context, 1);
    }

    public String getCodeTitle(CodeList<?> code, Locale locale) {
        return Types.getCodeTitle(code).toString(locale);
    }

    public String getUnicodeIdentifier(Citation citation) {
        return Identifiers.getIdentifier(citation, true);
    }

    public String getInformation(String key, Locale locale) {
        switch (key) {
            case "DataSource": {
                Object server = null;
                Object database = null;
                try {
                    DataSource ds = Initializer.getDataSource();
                    if (ds != null) {
                        Class<?> type = ds.getClass();
                        database = type.getMethod("getDatabaseName", null).invoke((Object)ds, (Object[])null);
                        server = type.getMethod("getServerName", null).invoke((Object)ds, (Object[])null);
                    }
                }
                catch (NoSuchMethodException e) {
                    Logging.recoverableException((Logger)SystemListener.LOGGER, MetadataServices.class, (String)"getInformation", (Throwable)e);
                }
                catch (Exception e) {
                    Object message = Exceptions.getLocalizedMessage((Throwable)e, (Locale)locale);
                    if (message == null || ((String)message).indexOf(32) < 0) {
                        message = Classes.getShortClassName((Object)e) + ": " + (String)message;
                    }
                    return message;
                }
                if (database != null) {
                    if (server != null) {
                        database = "//" + server + "/" + database;
                    }
                    return database.toString();
                }
                return null;
            }
        }
        return ReferencingServices.getInstance().getInformation(key, locale);
    }

    public Format createCoordinateFormat(Locale locale, TimeZone timezone) {
        return ReferencingServices.getInstance().createCoordinateFormat(locale, timezone);
    }

    public DataSource getDataSource() throws SQLException {
        try {
            return Initializer.getDataSource();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(Errors.format((short)6, (Object)"SpatialMetadata"), e);
        }
    }

    public void setDataSource(Supplier<DataSource> ds) {
        if (!Initializer.setDefault(ds)) {
            throw new IllegalStateException(Resources.format((short)6, "SpatialMetadata"));
        }
    }
}

