/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.internal;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class CopyOnWriteNavigableSet<E>
extends TreeSet<E> {
    private static final long serialVersionUID = 1L;
    private volatile NavigableSet<E> set;
    private final Comparator<? super E> comparator;

    public CopyOnWriteNavigableSet(Comparator<? super E> comparator) {
        this.set = new TreeSet<E>(comparator);
        this.comparator = comparator;
    }

    private CopyOnWriteNavigableSet(CopyOnWriteNavigableSet<E> copyOnWriteSet) {
        this.set = new TreeSet<E>(copyOnWriteSet.set);
        this.comparator = copyOnWriteSet.comparator;
    }

    @Override
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.set.descendingIterator();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return this.set.descendingSet();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean add(E e) {
        TreeSet<E> newSet = new TreeSet<E>(this.set);
        boolean result = newSet.add(e);
        if (result) {
            this.set = newSet;
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        TreeSet<E> newSet = new TreeSet<E>(this.set);
        boolean result = newSet.remove(o);
        if (result) {
            this.set = newSet;
        }
        return result;
    }

    @Override
    public void clear() {
        TreeSet<E> newSet = new TreeSet<E>(this.set);
        newSet.clear();
        this.set = newSet;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        TreeSet<? extends E> newSet = new TreeSet<E>(this.set);
        boolean result = newSet.addAll(c);
        if (result) {
            this.set = newSet;
        }
        return result;
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return this.set.subSet(fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return this.set.headSet(toElement, inclusive);
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return this.set.tailSet(fromElement, inclusive);
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.set.subSet(fromElement, toElement);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.set.headSet(toElement);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.set.tailSet(fromElement);
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public E first() {
        return this.set.first();
    }

    @Override
    public E last() {
        return this.set.last();
    }

    @Override
    public E lower(E e) {
        return this.set.lower(e);
    }

    @Override
    public E floor(E e) {
        return this.set.floor(e);
    }

    @Override
    public E ceiling(E e) {
        return this.set.ceiling(e);
    }

    @Override
    public E higher(E e) {
        return this.set.higher(e);
    }

    @Override
    public E pollFirst() {
        return this.set.pollFirst();
    }

    @Override
    public E pollLast() {
        return this.set.pollLast();
    }

    @Override
    public Object clone() {
        return new CopyOnWriteNavigableSet<E>(this);
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.set.spliterator();
    }

    @Override
    public boolean equals(Object o) {
        return this.set.equals(o);
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.removeAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public String toString() {
        return this.set.toString();
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.set.toArray(generator);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        TreeSet<? super E> newSet = new TreeSet<E>(this.set);
        boolean result = newSet.removeIf(filter);
        if (result) {
            this.set = newSet;
        }
        return result;
    }

    @Override
    public Stream<E> stream() {
        return this.set.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.set.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.set.forEach(action);
    }
}

