/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.geojson.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import mil.nga.sf.geojson.Position;

public class CoordinatesDeserializer
extends JsonDeserializer<Position> {
    public Position deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.isExpectedStartArrayToken()) {
            return this.deserializeArray(jp, ctxt);
        }
        ctxt.reportWrongTokenException((JsonDeserializer)this, JsonToken.START_ARRAY, "Unexpected token when binding data into Position", new Object[0]);
        return null;
    }

    protected Position deserializeArray(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Double x = this.extractDouble(jp, ctxt, false);
        Double y = this.extractDouble(jp, ctxt, false);
        Double z = this.extractDouble(jp, ctxt, true);
        ArrayList<Double> additionalElements = new ArrayList<Double>();
        while (jp.hasCurrentToken() && jp.getCurrentToken() != JsonToken.END_ARRAY) {
            Double element = this.extractDouble(jp, ctxt, true);
            if (element == null) continue;
            additionalElements.add(element);
        }
        Double[] aeArray = new Double[additionalElements.size()];
        return new Position(x, y, z, additionalElements.toArray(aeArray));
    }

    private Double extractDouble(JsonParser jp, DeserializationContext ctxt, boolean optional) throws JsonParseException, IOException {
        JsonToken token = jp.nextToken();
        if (token == null) {
            if (!optional) {
                ctxt.reportWrongTokenException((JsonDeserializer)this, JsonToken.VALUE_NUMBER_FLOAT, "Unexpected end-of-input when binding data into Coordinates", new Object[0]);
            }
            return null;
        }
        switch (token) {
            case END_ARRAY: {
                if (!optional) {
                    ctxt.reportWrongTokenException((JsonDeserializer)this, JsonToken.VALUE_NUMBER_FLOAT, "Unexpected end-of-input when binding data into Coordinates", new Object[0]);
                }
                return null;
            }
            case VALUE_NUMBER_FLOAT: {
                return jp.getDoubleValue();
            }
            case VALUE_NUMBER_INT: {
                return jp.getLongValue();
            }
            case VALUE_STRING: {
                return jp.getValueAsDouble();
            }
        }
        ctxt.reportWrongTokenException((JsonDeserializer)this, JsonToken.VALUE_NUMBER_FLOAT, "Unexpected token (%s) when binding data into LngLatAlt", new Object[]{token.name()});
        return null;
    }
}

