/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.shapefile;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.baremaps.shapefile.ShapefileInputStream;
import org.apache.baremaps.shapefile.ShapefileReader;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataSchema;
import org.apache.baremaps.store.DataStoreException;
import org.apache.baremaps.store.DataTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapefileDataTable
implements DataTable {
    private static final Logger logger = LoggerFactory.getLogger(ShapefileDataTable.class);
    private final ShapefileReader shapeFile;

    public ShapefileDataTable(Path file) {
        this.shapeFile = new ShapefileReader(file.toString());
    }

    public DataSchema schema() throws DataStoreException {
        DataSchema dataSchema;
        block8: {
            ShapefileInputStream input = this.shapeFile.read();
            try {
                dataSchema = input.schema();
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DataStoreException((Throwable)e);
                }
            }
            input.close();
        }
        return dataSchema;
    }

    public long size() {
        return 0L;
    }

    public Iterator<DataRow> iterator() {
        try {
            return new ShapefileIterator(this.shapeFile.read());
        }
        catch (IOException e) {
            throw new DataStoreException((Throwable)e);
        }
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public static class ShapefileIterator
    implements Iterator<DataRow> {
        private final ShapefileInputStream shapefileInputStream;
        private DataRow next;

        public ShapefileIterator(ShapefileInputStream shapefileInputStream) {
            this.shapefileInputStream = shapefileInputStream;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.next == null) {
                    this.next = this.shapefileInputStream.readRow();
                }
                return this.next != null;
            }
            catch (IOException e) {
                logger.error("Malformed shapefile", (Throwable)e);
                try {
                    this.shapefileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
        }

        @Override
        public DataRow next() {
            try {
                if (this.next == null) {
                    this.next = this.shapefileInputStream.readRow();
                }
                DataRow current = this.next;
                this.next = null;
                return current;
            }
            catch (Exception e) {
                try {
                    this.shapefileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new NoSuchElementException();
            }
        }
    }
}

