/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.model;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.StringJoiner;

public final class Info {
    protected final int version;
    protected final LocalDateTime timestamp;
    protected final long changeset;
    protected final int uid;

    public Info(int version, LocalDateTime timestamp, long changeset, int uid) {
        this.version = version;
        this.timestamp = timestamp;
        this.changeset = changeset;
        this.uid = uid;
    }

    public int getVersion() {
        return this.version;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public long getChangeset() {
        return this.changeset;
    }

    public int getUid() {
        return this.uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Info)) {
            return false;
        }
        Info info = (Info)o;
        return this.version == info.version && this.changeset == info.changeset && this.uid == info.uid && Objects.equals(this.timestamp, info.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.timestamp, this.changeset, this.uid);
    }

    public String toString() {
        return new StringJoiner(", ", Info.class.getSimpleName() + "[", "]").add("version=" + this.version).add("timestamp=" + this.timestamp).add("changeset=" + this.changeset).add("uid=" + this.uid).toString();
    }
}

