/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.postgres.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.Resources;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.baremaps.postgres.utils.Database;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostgresUtils {
    private static final Logger logger = LoggerFactory.getLogger(PostgresUtils.class);

    private PostgresUtils() {
    }

    public static DataSource createDataSourceFromObject(Object database) {
        if (database instanceof String) {
            String url = (String)database;
            return PostgresUtils.createDataSource(url);
        }
        Database json = (Database)new ObjectMapper().convertValue(database, Database.class);
        return PostgresUtils.createDataSource(json);
    }

    public static DataSource createDataSource(String host, Integer port, String database, String username, String password) {
        return PostgresUtils.createDataSource(String.format("jdbc:postgresql://%s:%s/%s?&user=%s&password=%s", host, port, database, username, password));
    }

    public static DataSource createDataSource(String database) {
        return PostgresUtils.createDataSource(database, Runtime.getRuntime().availableProcessors() * 2);
    }

    public static DataSource createDataSource(String jdbcUrl, int poolSize) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("PoolSize cannot be inferior to 1");
        }
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(jdbcUrl);
        config.setMaximumPoolSize(poolSize);
        config.addDataSourceProperty("allowMultiQueries", (Object)true);
        config.addDataSourceProperty("prepareThreshold", (Object)100);
        return new HikariDataSource(config);
    }

    public static DataSource createDataSource(Database datasource) {
        HikariConfig config = new HikariConfig();
        if (datasource.getDataSourceClassName() != null) {
            config.setDataSourceClassName(datasource.getDataSourceClassName());
        }
        if (datasource.getJdbcUrl() != null) {
            config.setJdbcUrl(datasource.getJdbcUrl());
        }
        if (datasource.getUsername() != null) {
            config.setUsername(datasource.getUsername());
        }
        if (datasource.getPassword() != null) {
            config.setPassword(datasource.getPassword());
        }
        if (datasource.getAutoCommit() != null) {
            config.setAutoCommit(datasource.getAutoCommit().booleanValue());
        }
        if (datasource.getConnectionTimeout() != null) {
            config.setConnectionTimeout((long)datasource.getConnectionTimeout().intValue());
        }
        if (datasource.getIdleTimeout() != null) {
            config.setInitializationFailTimeout((long)datasource.getIdleTimeout().intValue());
        }
        if (datasource.getKeepAliveTime() != null) {
            config.setKeepaliveTime((long)datasource.getKeepAliveTime().intValue());
        }
        if (datasource.getMaxLifetime() != null) {
            config.setMaxLifetime((long)datasource.getMaxLifetime().intValue());
        }
        if (datasource.getMinimumIdle() != null) {
            config.setMinimumIdle(datasource.getMinimumIdle().intValue());
        }
        if (datasource.getMaximumPoolSize() != null) {
            config.setMaximumPoolSize(datasource.getMaximumPoolSize().intValue());
        }
        if (datasource.getPoolName() != null) {
            config.setPoolName(datasource.getPoolName());
        }
        if (datasource.getReadOnly() != null) {
            config.setReadOnly(datasource.getReadOnly().booleanValue());
        }
        config.addDataSourceProperty("allowMultiQueries", (Object)true);
        config.addDataSourceProperty("prepareThreshold", (Object)100);
        return new HikariDataSource(config);
    }

    public static void executeResource(Connection connection, String resource) throws IOException, SQLException {
        URL resourceURL = Resources.getResource((String)resource);
        String queries = Resources.toString((URL)resourceURL, (Charset)StandardCharsets.UTF_8);
        try (Statement statement = connection.createStatement();){
            statement.execute(queries);
        }
    }
}

