/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geoparquet;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.baremaps.geoparquet.GeoParquetException;
import org.apache.baremaps.geoparquet.GeoParquetGroup;
import org.apache.baremaps.geoparquet.GeoParquetGroupRecordMaterializer;
import org.apache.baremaps.geoparquet.GeoParquetMetadata;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.locationtech.jts.geom.Envelope;

class GeoParquetSpliterator
implements Spliterator<GeoParquetGroup> {
    private final List<FileStatus> files;
    private final Configuration configuration;
    private final Envelope envelope;
    private ParquetFileReader fileReader;
    private int fileStartIndex;
    private int fileEndIndex;
    private MessageType schema;
    private GeoParquetMetadata metadata;
    private MessageColumnIO columnIO;
    private RecordReader<GeoParquetGroup> recordReader;
    private int currentRowGroup;
    private long rowsReadInGroup;
    private long rowsInCurrentGroup;

    GeoParquetSpliterator(List<FileStatus> files, Envelope envelope, Configuration configuration, int fileStartIndex, int fileEndIndex) {
        this.files = files;
        this.configuration = configuration;
        this.envelope = envelope;
        this.fileStartIndex = fileStartIndex;
        this.fileEndIndex = fileEndIndex;
        this.setupReaderForNextFile();
    }

    private void setupReaderForNextFile() {
        this.closeCurrentReader();
        while (this.fileStartIndex < this.fileEndIndex) {
            FileStatus fileStatus = this.files.get(this.fileStartIndex++);
            try {
                Envelope fileEnvelope;
                List<Double> fileBBox;
                HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)fileStatus.getPath(), (Configuration)this.configuration);
                this.fileReader = ParquetFileReader.open((InputFile)inputFile);
                FileMetaData fileMetaData = this.fileReader.getFooter().getFileMetaData();
                this.schema = fileMetaData.getSchema();
                this.metadata = (GeoParquetMetadata)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue((String)fileMetaData.getKeyValueMetaData().get("geo"), GeoParquetMetadata.class);
                if (this.envelope != null && this.metadata != null && this.metadata.bbox() != null && (fileBBox = this.metadata.bbox()).size() == 4 && !(fileEnvelope = new Envelope(fileBBox.get(0).doubleValue(), fileBBox.get(2).doubleValue(), fileBBox.get(1).doubleValue(), fileBBox.get(3).doubleValue())).intersects(this.envelope)) {
                    this.fileReader.close();
                    this.fileReader = null;
                    continue;
                }
                this.columnIO = new ColumnIOFactory().getColumnIO(this.schema);
                this.currentRowGroup = 0;
                this.rowsReadInGroup = 0L;
                this.rowsInCurrentGroup = 0L;
                this.advanceToNextRowGroup();
                return;
            }
            catch (IOException e) {
                throw new GeoParquetException("Failed to create reader for " + fileStatus, e);
            }
        }
        this.fileReader = null;
    }

    private void advanceToNextRowGroup() throws IOException {
        if (this.currentRowGroup >= this.fileReader.getRowGroups().size()) {
            this.setupReaderForNextFile();
            return;
        }
        PageReadStore pages = this.fileReader.readNextFilteredRowGroup();
        if (pages == null) {
            this.setupReaderForNextFile();
            return;
        }
        this.rowsInCurrentGroup = pages.getRowCount();
        this.rowsReadInGroup = 0L;
        GeoParquetGroupRecordMaterializer materializer = new GeoParquetGroupRecordMaterializer(this.schema, this.metadata);
        FilterPredicate envelopeFilter = this.createEnvelopeFilter(this.schema, this.envelope);
        FilterCompat.Filter filter = envelopeFilter == null ? FilterCompat.NOOP : FilterCompat.get((FilterPredicate)envelopeFilter);
        this.recordReader = this.columnIO.getRecordReader(pages, (RecordMaterializer)materializer, filter);
        ++this.currentRowGroup;
    }

    private FilterPredicate createEnvelopeFilter(MessageType schema, Envelope envelope) {
        if (envelope == null || envelope.isNull() || envelope.equals((Object)new Envelope(-180.0, 180.0, -90.0, 90.0))) {
            return null;
        }
        Type type = schema.getType("bbox");
        if (type == null) {
            return null;
        }
        GroupType bbox = type.asGroupType();
        if (!(bbox.getFieldCount() == 4 && bbox.containsField("xmin") && bbox.containsField("ymin") && bbox.containsField("xmax") && bbox.containsField("ymax"))) {
            return null;
        }
        List types = bbox.getFields();
        if (types.stream().anyMatch(t -> !t.isPrimitive())) {
            return null;
        }
        List<PrimitiveType.PrimitiveTypeName> typeNames = types.stream().map(t -> t.asPrimitiveType().getPrimitiveTypeName()).toList();
        PrimitiveType.PrimitiveTypeName typeName = typeNames.get(0);
        if (!typeNames.stream().allMatch(arg_0 -> typeName.equals(arg_0))) {
            return null;
        }
        if (typeName != PrimitiveType.PrimitiveTypeName.DOUBLE && typeName != PrimitiveType.PrimitiveTypeName.FLOAT) {
            return null;
        }
        BiFunction<String, Number, FilterPredicate> filterPredicateCreator = (column, value) -> switch (typeName) {
            case PrimitiveType.PrimitiveTypeName.DOUBLE -> FilterApi.gtEq((Operators.Column)FilterApi.doubleColumn((String)column), (Comparable)Double.valueOf(value.doubleValue()));
            case PrimitiveType.PrimitiveTypeName.FLOAT -> FilterApi.gtEq((Operators.Column)FilterApi.floatColumn((String)column), (Comparable)Float.valueOf(value.floatValue()));
            default -> throw new IllegalStateException("Unexpected value: " + typeName);
        };
        return FilterApi.and((FilterPredicate)FilterApi.and((FilterPredicate)filterPredicateCreator.apply("bbox.xmin", envelope.getMinX()), (FilterPredicate)filterPredicateCreator.apply("bbox.xmax", envelope.getMaxX())), (FilterPredicate)FilterApi.and((FilterPredicate)filterPredicateCreator.apply("bbox.ymin", envelope.getMinY()), (FilterPredicate)filterPredicateCreator.apply("bbox.ymax", envelope.getMaxY())));
    }

    @Override
    public boolean tryAdvance(Consumer<? super GeoParquetGroup> action) {
        try {
            while (true) {
                if (this.fileReader == null) {
                    return false;
                }
                if (this.rowsReadInGroup < this.rowsInCurrentGroup) break;
                this.advanceToNextRowGroup();
            }
            GeoParquetGroup group = (GeoParquetGroup)this.recordReader.read();
            ++this.rowsReadInGroup;
            if (group != null) {
                action.accept(group);
            }
            return true;
        }
        catch (IOException e) {
            this.closeCurrentReader();
            throw new GeoParquetException("IOException caught while trying to read the next record.", e);
        }
    }

    private void closeCurrentReader() {
        if (this.fileReader != null) {
            try {
                this.fileReader.close();
            }
            catch (IOException e) {
                throw new GeoParquetException("Failed to close ParquetFileReader.", e);
            }
            finally {
                this.fileReader = null;
            }
        }
    }

    @Override
    public Spliterator<GeoParquetGroup> trySplit() {
        int remainingFiles = this.fileEndIndex - this.fileStartIndex;
        if (remainingFiles <= 1) {
            return null;
        }
        int mid = this.fileStartIndex + remainingFiles / 2;
        GeoParquetSpliterator split = new GeoParquetSpliterator(this.files, this.envelope, this.configuration, mid, this.fileEndIndex);
        this.fileEndIndex = mid;
        return split;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 1280;
    }
}

