/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql.util;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.sis.util.CharSequences;

public enum Dialect {
    ANSI(null, false, true, true),
    DERBY("derby", false, true, false),
    HSQL("hsqldb", false, true, true),
    POSTGRESQL("postgresql", true, true, true),
    ORACLE("oracle", false, true, true),
    SQLITE("sqlite", false, false, false);

    private final String protocol;
    public final boolean supportsTableInheritance;
    public final boolean supportsIndexInheritance = false;
    public final boolean supportsAlterTableWithAddConstraint;
    public final boolean supportsJavaTime;

    private Dialect(String protocol, boolean supportsTableInheritance, boolean supportsAlterTableWithAddConstraint, boolean supportsJavaTime) {
        this.protocol = protocol;
        this.supportsTableInheritance = supportsTableInheritance;
        this.supportsAlterTableWithAddConstraint = supportsAlterTableWithAddConstraint;
        this.supportsJavaTime = supportsJavaTime;
    }

    public static Dialect guess(DatabaseMetaData metadata) throws SQLException {
        int end;
        int start;
        String url = metadata.getURL();
        if (url != null && (start = url.indexOf(58)) >= 0 && "jdbc".equalsIgnoreCase((String)CharSequences.trimWhitespaces((CharSequence)url, (int)0, (int)start)) && (end = url.indexOf(58, ++start)) >= 0) {
            String protocol = (String)CharSequences.trimWhitespaces((CharSequence)url, (int)start, (int)end);
            for (Dialect candidate : Dialect.values()) {
                if (!protocol.equalsIgnoreCase(candidate.protocol)) continue;
                return candidate;
            }
        }
        return ANSI;
    }
}

