/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.proj;

import java.util.List;
import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionFactory;
import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.Point;
import mil.nga.sf.proj.GeometryTransform;
import mil.nga.sf.util.GeometryUtils;
import org.locationtech.proj4j.units.Units;

public class ProjectionGeometryUtils {
    private static final Projection WGS_84_PROJECTION = ProjectionFactory.getProjection((long)4326L);

    public static List<Point> geodesicPath(List<Point> points, double maxDistance, Projection projection) {
        List<Point> geodesicPath = points;
        if (projection != null) {
            if (!projection.isUnit(Units.DEGREES)) {
                GeometryTransform toWGS84 = GeometryTransform.create(projection, WGS_84_PROJECTION);
                geodesicPath = toWGS84.transform(geodesicPath);
            }
            geodesicPath = GeometryUtils.geodesicPath(geodesicPath, (double)maxDistance);
            if (!projection.isUnit(Units.DEGREES)) {
                GeometryTransform fromWGS84 = GeometryTransform.create(WGS_84_PROJECTION, projection);
                geodesicPath = fromWGS84.transform(geodesicPath);
            }
        }
        return geodesicPath;
    }

    public static GeometryEnvelope geodesicEnvelope(GeometryEnvelope envelope, Projection projection) {
        GeometryEnvelope geodesic = envelope;
        if (projection != null) {
            if (!projection.isUnit(Units.DEGREES)) {
                GeometryTransform toWGS84 = GeometryTransform.create(projection, WGS_84_PROJECTION);
                geodesic = toWGS84.transform(geodesic);
            }
            geodesic = GeometryUtils.geodesicEnvelope((GeometryEnvelope)geodesic);
            if (!projection.isUnit(Units.DEGREES)) {
                GeometryTransform fromWGS84 = GeometryTransform.create(WGS_84_PROJECTION, projection);
                geodesic = fromWGS84.transform(geodesic);
            }
        }
        return geodesic;
    }
}

