/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal;

import org.apache.sis.referencing.util.PositionalAccuracyConstant;
import org.apache.sis.util.internal.CloneAccess;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.referencing.operation.Matrix;

public final class AnnotatedMatrix
implements Matrix,
CloneAccess {
    private final Matrix matrix;
    public final PositionalAccuracy accuracy;

    private AnnotatedMatrix(Matrix matrix, PositionalAccuracy accuracy) {
        this.matrix = matrix;
        this.accuracy = accuracy;
    }

    public static Matrix indirect(Matrix matrix, boolean intersect) {
        return new AnnotatedMatrix(matrix, intersect ? PositionalAccuracyConstant.INDIRECT_SHIFT_APPLIED : PositionalAccuracyConstant.DATUM_SHIFT_OMITTED);
    }

    public int getNumRow() {
        return this.matrix.getNumRow();
    }

    public int getNumCol() {
        return this.matrix.getNumCol();
    }

    public boolean isIdentity() {
        return this.matrix.isIdentity();
    }

    public double getElement(int row, int column) {
        return this.matrix.getElement(row, column);
    }

    public void setElement(int row, int column, double value) {
        this.matrix.setElement(row, column, value);
    }

    public Matrix clone() {
        return new AnnotatedMatrix(this.matrix.clone(), this.accuracy);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnnotatedMatrix) {
            AnnotatedMatrix other = (AnnotatedMatrix)obj;
            return this.matrix.equals(other.matrix) && this.accuracy.equals(other.accuracy);
        }
        return false;
    }

    public int hashCode() {
        return this.matrix.hashCode();
    }

    public String toString() {
        return this.matrix.toString();
    }
}

